
// __________________________________________________________
//
//                         SbsPrint.h
//            SBS printf() & Friends Library V1.00
//                07-20-2001 Sven B. Schreiber
//                       sbs@orgon.com
// __________________________________________________________

#ifndef _SBSPRINT_H_
#define _SBSPRINT_H_

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// REVISION HISTORY
// =================================================================

/*

07-20-2001 V1.00 Original version (SBS).

*/

// =================================================================
// FUNCTION PROTOTYPES
// =================================================================

#ifdef  _INLINE_SBSPRINT_
#define _INLINE_SBSFILE_

#define DLL_EXPORT __declspec (dllexport)

#else   // #ifdef _INLINE_SBSPRINT_

#define DLL_EXPORT

#endif  // #ifdef _INLINE_SBSPRINT_

// -----------------------------------------------------------------

DLL_EXPORT VOID WINAPI _printf_init (PBYTE pbCaption,
                                     PWORD pwCaption);

DLL_EXPORT VOID WINAPI _printf_exit (VOID);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _vsprintfW (PWORD pwBuffer,
                                    PWORD pwFormat,
                                    PVOID pArguments);

DLL_EXPORT PWORD WINAPI _vbprintfW (PDWORD pdData,
                                    PWORD  pwFormat,
                                    PVOID  pArguments);

DLL_EXPORT INT WINAPI _vmprintfW (HWND  hWnd,
                                  UINT  uiType,
                                  PWORD pwCaption,
                                  PWORD pwFormat,
                                  PVOID pArguments);

DLL_EXPORT BOOL WINAPI _vdprintfW (HWND  hWnd,
                                   INT   iItem,
                                   PWORD pwFormat,
                                   PVOID pArguments);

DLL_EXPORT DWORD WINAPI _vfprintfW (HANDLE hFile,
                                    PWORD  pwFormat,
                                    PVOID  pArguments);

DLL_EXPORT DWORD WINAPI _veprintfW (PWORD pwFormat,
                                    PVOID pArguments);

DLL_EXPORT DWORD WINAPI _vprintfW (PWORD pwFormat,
                                   PVOID pArguments);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _sprintfW (PWORD pwBuffer,
                                   PWORD pwFormat,
                                   ...);

DLL_EXPORT PWORD WINAPI _bprintfW (PDWORD pdData,
                                   PWORD  pwFormat,
                                   ...);

DLL_EXPORT INT WINAPI _mprintfW (HWND  hWnd,
                                 UINT  uiType,
                                 PWORD pwCaption,
                                 PWORD pwFormat,
                                 ...);

DLL_EXPORT BOOL WINAPI _dprintfW (HWND  hWnd,
                                  INT   iItem,
                                  PWORD pwFormat,
                                  ...);

DLL_EXPORT DWORD WINAPI _fprintfW (HANDLE hFile,
                                   PWORD  pwFormat,
                                   ...);

DLL_EXPORT DWORD WINAPI _eprintfW (PWORD pwFormat,
                                   ...);

DLL_EXPORT DWORD WINAPI _printfW (PWORD pwFormat,
                                  ...);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _vsprintfA (PBYTE pbBuffer,
                                    PBYTE pbFormat,
                                    PVOID pArguments);

DLL_EXPORT PBYTE WINAPI _vbprintfA (PDWORD pdData,
                                    PBYTE  pbFormat,
                                    PVOID  pArguments);

DLL_EXPORT INT WINAPI _vmprintfA (HWND  hWnd,
                                  UINT  uiType,
                                  PBYTE pbCaption,
                                  PBYTE pbFormat,
                                  PVOID pArguments);

DLL_EXPORT BOOL WINAPI _vdprintfA (HWND  hWnd,
                                   INT   iItem,
                                   PBYTE pbFormat,
                                   PVOID pArguments);

DLL_EXPORT DWORD WINAPI _vfprintfA (HANDLE hFile,
                                    PBYTE  pbFormat,
                                    PVOID  pArguments);

DLL_EXPORT DWORD WINAPI _veprintfA (PBYTE pbFormat,
                                    PVOID pArguments);

DLL_EXPORT DWORD WINAPI _vprintfA (PBYTE pbFormat,
                                   PVOID pArguments);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _sprintfA (PBYTE pbBuffer,
                                   PBYTE pbFormat,
                                   ...);

DLL_EXPORT PBYTE WINAPI _bprintfA (PDWORD pdData,
                                   PBYTE  pbFormat,
                                   ...);

DLL_EXPORT INT WINAPI _mprintfA (HWND  hWnd,
                                 UINT  uiType,
                                 PBYTE pbCaption,
                                 PBYTE pbFormat,
                                 ...);

DLL_EXPORT BOOL WINAPI _dprintfA (HWND  hWnd,
                                  INT   iItem,
                                  PBYTE pbFormat,
                                  ...);

DLL_EXPORT DWORD WINAPI _fprintfA (HANDLE hFile,
                                   PBYTE  pbFormat,
                                   ...);

DLL_EXPORT DWORD WINAPI _eprintfA (PBYTE pbFormat,
                                   ...);

DLL_EXPORT DWORD WINAPI _printfA (PBYTE pbFormat,
                                  ...);

// -----------------------------------------------------------------

DLL_EXPORT BOOL WINAPI _vdprintfx (HWND  hWnd,
                                   INT   iItem,
                                   PVOID pFormat,
                                   PVOID pArguments);

DLL_EXPORT BOOL WINAPI _dprintfx (HWND  hWnd,
                                  INT   iItem,
                                  PVOID pFormat,
                                  ...);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _format_ansi (PWORD pwBuffer,
                                      DWORD dOffset,
                                      PBYTE pbData,
                                      DWORD dData,
                                      DWORD dWidth,
                                      DWORD dPrecision,
                                      WORD  wFill,
                                      BOOL  fRight,
                                      BOOL  fZero);

DLL_EXPORT DWORD WINAPI _format_unicode (PWORD pwBuffer,
                                         DWORD dOffset,
                                         PWORD pwData,
                                         DWORD dData,
                                         DWORD dWidth,
                                         DWORD dPrecision,
                                         WORD  wFill,
                                         BOOL  fRight,
                                         BOOL  fZero);

DLL_EXPORT DWORD WINAPI _format_decimal (PWORD pwBuffer,
                                         DWORD dOffset,
                                         DWORD dData,
                                         DWORD dWidth,
                                         DWORD dPrecision,
                                         WORD  wFill,
                                         BOOL  fRight,
                                         BOOL  fZero,
                                         BOOL  fPrefix,
                                         BOOL  fSigned);

DLL_EXPORT DWORD WINAPI _format_hex (PWORD pwBuffer,
                                     DWORD dOffset,
                                     DWORD dData,
                                     DWORD dWidth,
                                     DWORD dPrecision,
                                     WORD  wFill,
                                     BOOL  fRight,
                                     BOOL  fZero,
                                     BOOL  fPrefix,
                                     BOOL  fLower);

DLL_EXPORT DWORD WINAPI _format_single (PWORD  pwBuffer,
                                        DWORD  dOffset,
                                        PWORD  pwFormat,
                                        PDWORD pdFormat,
                                        PVOID *ppData,
                                        WORD   wFill,
                                        BOOL   fUnicode);

DLL_EXPORT DWORD WINAPI _format_multi (PWORD pwBuffer,
                                       DWORD dOffset,
                                       PWORD pwFormat,
                                       PVOID pArguments,
                                       WORD  wFill,
                                       BOOL  fUnicode);

// -----------------------------------------------------------------

DLL_EXPORT BOOL WINAPI _console_test (VOID);

DLL_EXPORT BOOL WINAPI _console_open (VOID);

DLL_EXPORT BOOL WINAPI _console_close (VOID);

DLL_EXPORT DWORD WINAPI _console_write (HANDLE hf,
                                        PVOID  pData,
                                        DWORD  dData);

// -----------------------------------------------------------------

#undef DLL_EXPORT

#include <SbsFile.h>

// =================================================================
// CONDITIONAL ANSI/UNICODE SYMBOLS
// =================================================================

#ifdef  UNICODE

#define _vsprintf _vsprintfW
#define _vbprintf _vbprintfW
#define _vmprintf _vmprintfW
#define _vdprintf _vdprintfW
#define _vfprintf _vfprintfW
#define _veprintf _veprintfW
#define _vprintf  _vprintfW

#define _sprintf  _sprintfW
#define _bprintf  _bprintfW
#define _mprintf  _mprintfW
#define _dprintf  _dprintfW
#define _fprintf  _fprintfW
#define _eprintf  _eprintfW
#define _printf   _printfW

#else   // #ifdef UNICODE

#define _vsprintf _vsprintfA
#define _vbprintf _vbprintfA
#define _vmprintf _vmprintfA
#define _vdprintf _vdprintfA
#define _vfprintf _vfprintfA
#define _veprintf _veprintfA
#define _vprintf  _vprintfA

#define _sprintf  _sprintfA
#define _bprintf  _bprintfA
#define _mprintf  _mprintfA
#define _dprintf  _dprintfA
#define _fprintf  _fprintfA
#define _eprintf  _eprintfA
#define _printf   _printfA

#endif  // #ifdef UNICODE

////////////////////////////////////////////////////////////////////
#ifdef _INLINE_SBSPRINT_
////////////////////////////////////////////////////////////////////

// =================================================================
// VARIABLES
// =================================================================

HANDLE _hStdInput     = INVALID_HANDLE_VALUE;
HANDLE _hStdOutput    = INVALID_HANDLE_VALUE;
HANDLE _hStdError     = INVALID_HANDLE_VALUE;

BOOL   _fStdHandles   = FALSE;
BOOL   _fStdFailure   = FALSE;
BOOL   _fStdTransient = FALSE;

PBYTE  _pbCaption     =  "";
PWORD  _pwCaption     = L"";
WORD   _wFill         = ' ';

// =================================================================
// STARTUP & CLEANUP
// =================================================================

VOID WINAPI _printf_init (PBYTE pbCaption,
                          PWORD pwCaption)
    {
    _pbCaption = pbCaption;
    _pwCaption = pwCaption;

    _finit ();
    return;
    }

// -----------------------------------------------------------------

VOID WINAPI _printf_exit (VOID)
    {
    _console_close ();
    _fexit ();
    return;
    }

// =================================================================
// vprintf() ROUTINES (UNICODE)
// =================================================================

DWORD WINAPI _vsprintfW (PWORD pwBuffer,
                         PWORD pwFormat,
                         PVOID pArguments)
    {
    return _format_multi (pwBuffer, 0, pwFormat, pArguments,
                          _wFill, TRUE);
    }

// -----------------------------------------------------------------

PWORD WINAPI _vbprintfW (PDWORD pdData,
                         PWORD  pwFormat,
                         PVOID  pArguments)
    {
    DWORD n;
    DWORD dData    = 0;
    PWORD pwBuffer = NULL;

    n = _vsprintfW (NULL, pwFormat, pArguments);

    if ((pwBuffer = _tnewW (n+1)) != NULL)
        {
        _vsprintfW (pwBuffer, pwFormat, pArguments);
        dData = n;
        }
    if (pdData != NULL) *pdData = dData;
    return pwBuffer;
    }

// -----------------------------------------------------------------

INT WINAPI _vmprintfW (HWND  hWnd,
                       UINT  uiType,
                       PWORD pwCaption,
                       PWORD pwFormat,
                       PVOID pArguments)
    {
    PWORD pwBuffer;
    INT   iId = IDABORT;

    if ((pwBuffer = _vbprintfW (NULL, pwFormat, pArguments))
        != NULL)
        {
        iId = MessageBoxW (hWnd, pwBuffer,
                           (pwCaption != NULL ?  pwCaption
                                              : _pwCaption),
                           uiType);

        _mfree (pwBuffer);
        }
    return iId;
    }

// -----------------------------------------------------------------

BOOL WINAPI _vdprintfW (HWND  hWnd,
                        INT   iItem,
                        PWORD pwFormat,
                        PVOID pArguments)
    {
    PWORD pwBuffer;
    BOOL  fOk = FALSE;

    if ((hWnd != NULL) && IsWindow (hWnd))
        {
        if ((pwBuffer = _vbprintfW (NULL, pwFormat, pArguments))
            != NULL)
            {
            fOk = (iItem != -1
                   ? SetDlgItemTextW (hWnd, iItem, pwBuffer)
                   : SetWindowTextW  (hWnd,        pwBuffer));

            _mfree (pwBuffer);
            }
        else
            {
            fOk = (iItem != -1
                   ? SetDlgItemTextW (hWnd, iItem, L"")
                   : SetWindowTextW  (hWnd,        L""));
            }
        }
    return fOk;
    }

// -----------------------------------------------------------------

DWORD WINAPI _vfprintfW (HANDLE hFile,
                         PWORD  pwFormat,
                         PVOID  pArguments)
    {
    PWORD pwBuffer;
    PBYTE pbBuffer;
    DWORD dData;
    DWORD n = 0;

    if ((pwBuffer = _vbprintfW (&dData, pwFormat, pArguments))
        != NULL)
        {
        if ((pbBuffer = _tnewW2A (pwBuffer, dData+1))
            != NULL)
            {
            n = _console_write (hFile, pbBuffer, dData);
            _mfree (pbBuffer);
            }
        _mfree (pwBuffer);
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _veprintfW (PWORD pwFormat,
                         PVOID pArguments)
    {
    _console_open ();
    return _vfprintfW (_hStdError, pwFormat, pArguments);
    }

// -----------------------------------------------------------------

DWORD WINAPI _vprintfW (PWORD pwFormat,
                        PVOID pArguments)
    {
    _console_open ();
    return _vfprintfW (_hStdOutput, pwFormat, pArguments);
    }

// =================================================================
// printf() ROUTINES (UNICODE)
// =================================================================

DWORD WINAPI _sprintfW (PWORD pwBuffer,
                        PWORD pwFormat,
                        ...)
    {
    return _vsprintfW (pwBuffer, pwFormat, (&pwFormat)+1);
    }

// -----------------------------------------------------------------

PWORD WINAPI _bprintfW (PDWORD pdData,
                        PWORD  pwFormat,
                        ...)
    {
    return _vbprintfW (pdData, pwFormat, (&pwFormat)+1);
    }

// -----------------------------------------------------------------

INT WINAPI _mprintfW (HWND  hWnd,
                      UINT  uiType,
                      PWORD pwCaption,
                      PWORD pwFormat,
                      ...)
    {
    return _vmprintfW (hWnd, uiType, pwCaption, pwFormat,
                       (&pwFormat)+1);
    }

// -----------------------------------------------------------------

BOOL WINAPI _dprintfW (HWND  hWnd,
                       INT   iItem,
                       PWORD pwFormat,
                       ...)
    {
    return _vdprintfW (hWnd, iItem, pwFormat, (&pwFormat)+1);
    }

// -----------------------------------------------------------------

DWORD WINAPI _fprintfW (HANDLE hFile,
                        PWORD  pwFormat,
                        ...)
    {
    return _vfprintfW (hFile, pwFormat, (&pwFormat)+1);
    }

// -----------------------------------------------------------------

DWORD WINAPI _eprintfW (PWORD pwFormat,
                        ...)
    {
    return _veprintfW (pwFormat, (&pwFormat)+1);
    }

// -----------------------------------------------------------------

DWORD WINAPI _printfW (PWORD pwFormat,
                       ...)
    {
    return _vprintfW (pwFormat, (&pwFormat)+1);
    }

// =================================================================
// vprintf() ROUTINES (ANSI)
// =================================================================

DWORD WINAPI _vsprintfA (PBYTE pbBuffer,
                         PBYTE pbFormat,
                         PVOID pArguments)
    {
    PWORD pwBuffer, pwFormat;
    DWORD n = 0;

    if ((pwFormat = _tnewA2W (pbFormat, -1)) != NULL)
        {
        n = _format_multi (NULL, 0, pwFormat, pArguments,
                           _wFill, FALSE);

        if (pbBuffer != NULL)
            {
            if ((pwBuffer = _tnewW (n+1)) != NULL)
                {
                _format_multi (pwBuffer, 0, pwFormat, pArguments,
                               _wFill, FALSE);

                _tcopyW2A (pbBuffer, pwBuffer, n+1);
                _mfree (pwBuffer);
                }
            else
                {
                pbBuffer [n = 0] = 0;
                }
            }
        _mfree (pwFormat);
        }
    return n;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _vbprintfA (PDWORD pdData,
                         PBYTE  pbFormat,
                         PVOID  pArguments)
    {
    PWORD pwFormat;
    PWORD pwBuffer;
    DWORD n;
    DWORD dData    = 0;
    PBYTE pbBuffer = NULL;

    if ((pwFormat = _tnewA2W (pbFormat, -1)) != NULL)
        {
        n = _format_multi (NULL, 0, pwFormat, pArguments,
                           _wFill, FALSE);

        if ((pwBuffer = _tnewW (n+1)) != NULL)
            {
            _format_multi (pwBuffer, 0, pwFormat, pArguments,
                           _wFill, FALSE);

            if ((pbBuffer = _tnewW2A (pwBuffer, n+1)) != NULL)
                {
                dData = n;
                }
            _mfree (pwBuffer);
            }
        _mfree (pwFormat);
        }
    if (pdData != NULL) *pdData = dData;
    return pbBuffer;
    }

// -----------------------------------------------------------------

INT WINAPI _vmprintfA (HWND  hWnd,
                       UINT  uiType,
                       PBYTE pbCaption,
                       PBYTE pbFormat,
                       PVOID pArguments)
    {
    PBYTE pbBuffer;
    INT   iId = IDABORT;

    if ((pbBuffer = _vbprintfA (NULL, pbFormat, pArguments))
        != NULL)
        {
        iId = MessageBoxA (hWnd, pbBuffer,
                           (pbCaption != NULL ?  pbCaption
                                              : _pbCaption),
                           uiType);

        _mfree (pbBuffer);
        }
    return iId;
    }

// -----------------------------------------------------------------

BOOL WINAPI _vdprintfA (HWND  hWnd,
                        INT   iItem,
                        PBYTE pbFormat,
                        PVOID pArguments)
    {
    PBYTE pbBuffer;
    BOOL  fOk = FALSE;

    if ((hWnd != NULL) && IsWindow (hWnd))
        {
        if ((pbBuffer = _vbprintfA (NULL, pbFormat, pArguments))
            != NULL)
            {
            fOk = (iItem != -1
                   ? SetDlgItemTextA (hWnd, iItem, pbBuffer)
                   : SetWindowTextA  (hWnd,        pbBuffer));

            _mfree (pbBuffer);
            }
        else
            {
            fOk = (iItem != -1
                   ? SetDlgItemTextA (hWnd, iItem, "")
                   : SetWindowTextA  (hWnd,        ""));
            }
        }
    return fOk;
    }

// -----------------------------------------------------------------

DWORD WINAPI _vfprintfA (HANDLE hFile,
                         PBYTE  pbFormat,
                         PVOID  pArguments)
    {
    PBYTE pbBuffer;
    DWORD dData;
    DWORD n = 0;

    if ((pbBuffer = _vbprintfA (&dData, pbFormat, pArguments))
        != NULL)
        {
        n = _console_write (hFile, pbBuffer, dData);
        _mfree (pbBuffer);
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _veprintfA (PBYTE pbFormat,
                         PVOID pArguments)
    {
    _console_open ();
    return _vfprintfA (_hStdError, pbFormat, pArguments);
    }

// -----------------------------------------------------------------

DWORD WINAPI _vprintfA (PBYTE pbFormat,
                        PVOID pArguments)
    {
    _console_open ();
    return _vfprintfA (_hStdOutput, pbFormat, pArguments);
    }

// =================================================================
// printf() ROUTINES (ANSI)
// =================================================================

DWORD WINAPI _sprintfA (PBYTE pbBuffer,
                        PBYTE pbFormat,
                        ...)
    {
    return _vsprintfA (pbBuffer, pbFormat, (&pbFormat)+1);
    }

// -----------------------------------------------------------------

PBYTE WINAPI _bprintfA (PDWORD pdData,
                        PBYTE  pbFormat,
                        ...)
    {
    return _vbprintfA (pdData, pbFormat, (&pbFormat)+1);
    }

// -----------------------------------------------------------------

INT WINAPI _mprintfA (HWND  hWnd,
                      UINT  uiType,
                      PBYTE pbCaption,
                      PBYTE pbFormat,
                      ...)
    {
    return _vmprintfA (hWnd, uiType, pbCaption,
                       pbFormat, (&pbFormat)+1);
    }

// -----------------------------------------------------------------

BOOL WINAPI _dprintfA (HWND  hWnd,
                       INT   iItem,
                       PBYTE pbFormat,
                       ...)
    {
    return _vdprintfA (hWnd, iItem, pbFormat, (&pbFormat)+1);
    }

// -----------------------------------------------------------------

DWORD WINAPI _fprintfA (HANDLE hFile,
                        PBYTE  pbFormat,
                        ...)
    {
    return _vfprintfA (hFile, pbFormat, (&pbFormat)+1);
    }

// -----------------------------------------------------------------

DWORD WINAPI _eprintfA (PBYTE pbFormat,
                        ...)
    {
    return _veprintfA (pbFormat, (&pbFormat)+1);
    }

// -----------------------------------------------------------------

DWORD WINAPI _printfA (PBYTE pbFormat,
                       ...)
    {
    return _vprintfA (pbFormat, (&pbFormat)+1);
    }

// =================================================================
// MORE printf() ROUTINES
// =================================================================

BOOL WINAPI _vdprintfx (HWND  hWnd,
                        INT   iItem,
                        PVOID pFormat,
                        PVOID pArguments)
    {
    BOOL fOk = FALSE;

    if ((hWnd != NULL) && IsWindow (hWnd))
        {
        fOk = (IsWindowUnicode (hWnd)
               ? _vdprintfW (hWnd, iItem, pFormat, pArguments)
               : _vdprintfA (hWnd, iItem, pFormat, pArguments));
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL WINAPI _dprintfx (HWND  hWnd,
                       INT   iItem,
                       PVOID pFormat,
                       ...)
    {
    return _vdprintfx (hWnd, iItem, pFormat, (&pFormat)+1);
    }

// =================================================================
// FORMATTED OUTPUT
// =================================================================

DWORD WINAPI _format_ansi (PWORD pwBuffer,
                           DWORD dOffset,
                           PBYTE pbData,
                           DWORD dData,
                           DWORD dWidth,
                           DWORD dPrecision,
                           WORD  wFill,
                           BOOL  fRight,
                           BOOL  fZero)
    {
    PWORD pwBuffer1;
    WORD  wData;
    DWORD i, j, k;
    DWORD n = 0;

    if (dData != -1)
        {
        i = dData;
        }
    else
        {
        i = 0;
        if (pbData != NULL) while (pbData [i]) i++;
        }
    j = (dPrecision == -1 ? i : max (i, dPrecision));
    n = max (i, dWidth);

    if (pwBuffer != NULL)
        {
        pwBuffer1 = pwBuffer + dOffset;
        wData     = (fZero ? '0' : wFill);

        if (fRight)
            {
            k = n;
            while (k > j) pwBuffer1 [--k] = wData;
            while (k > i) pwBuffer1 [--k] = ' ';
            k = 0;
            }
        else
            {
            k = 0;
            while (k < n - j) pwBuffer1 [k++] = wData;
            while (k < n - i) pwBuffer1 [k++] = ' ';
            }
        while (i--)
            {
            pwBuffer1 [k+i] = (pbData != NULL ? pbData [i] : wData);
            }
        }
    if (pwBuffer != NULL) pwBuffer [dOffset+n] = 0;
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _format_unicode (PWORD pwBuffer,
                              DWORD dOffset,
                              PWORD pwData,
                              DWORD dData,
                              DWORD dWidth,
                              DWORD dPrecision,
                              WORD  wFill,
                              BOOL  fRight,
                              BOOL  fZero)
    {
    PWORD pwBuffer1;
    WORD  wData;
    DWORD i, j, k;
    DWORD n = 0;

    if (dData != -1)
        {
        i = dData;
        }
    else
        {
        i = 0;
        if (pwData != NULL) while (pwData [i]) i++;
        }
    j = (dPrecision == -1 ? i : max (i, dPrecision));
    n = max (i, dWidth);

    if (pwBuffer != NULL)
        {
        pwBuffer1 = pwBuffer + dOffset;
        wData     = (fZero ? '0' : wFill);

        if (fRight)
            {
            k = n;
            while (k > j) pwBuffer1 [--k] = wData;
            while (k > i) pwBuffer1 [--k] = ' ';
            k = 0;
            }
        else
            {
            k = 0;
            while (k < n - j) pwBuffer1 [k++] = wData;
            while (k < n - i) pwBuffer1 [k++] = ' ';
            }
        while (i--)
            {
            pwBuffer1 [k+i] = (pwData != NULL ? pwData [i] : wData);
            }
        }
    if (pwBuffer != NULL) pwBuffer [dOffset+n] = 0;
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _format_decimal (PWORD pwBuffer,
                              DWORD dOffset,
                              DWORD dData,
                              DWORD dWidth,
                              DWORD dPrecision,
                              WORD  wFill,
                              BOOL  fRight,
                              BOOL  fZero,
                              BOOL  fPrefix,
                              BOOL  fSigned)
    {
    BOOL  fMinus;
    PWORD pwBuffer1;
    WORD  wPrefix, wData;
    DWORD dData1, i, j, k;
    DWORD n = 0;

    fMinus = (fSigned && ((LONG) dData < 0));
    dData1 = (fMinus ? 0 - dData : dData);

    for (i = dData1, j = 1; i >= 10; i /= 10, j++);

    if (dPrecision != -1) j = max (j, dPrecision);

    k = (fPrefix || fMinus ? j+1 : j);
    n = max (k, dWidth);

    wPrefix = (k == j ? 0 : (fMinus ? '-' : (dData1 ? '+' : ' ')));

    if (pwBuffer != NULL)
        {
        pwBuffer1 = pwBuffer + dOffset;
        wData     = (fZero ? '0' : wFill);

        if (fRight)
            {
            for (i = n; i > k; i--) pwBuffer1 [i-1] = wData;
            k = 0;
            }
        else
            {
            for (i = 0; i < n - j; i++) pwBuffer1 [i] = wData;
            i = n;
            k = (fZero ? 0 : n - k);
            }
        while (j--)
            {
            pwBuffer1 [--i] = (WORD) (dData1 % 10) + '0';
            dData1 /= 10;
            }
        if (wPrefix)
            {
            pwBuffer1 [k] = wPrefix;
            }
        }
    if (pwBuffer != NULL) pwBuffer [dOffset+n] = 0;
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _format_hex (PWORD pwBuffer,
                          DWORD dOffset,
                          DWORD dData,
                          DWORD dWidth,
                          DWORD dPrecision,
                          WORD  wFill,
                          BOOL  fRight,
                          BOOL  fZero,
                          BOOL  fPrefix,
                          BOOL  fLower)
    {
    PWORD pwBuffer1;
    WORD  wData;
    DWORD dData1, i, j, k;
    DWORD n = 0;

    dData1 = dData;

    for (i = dData1, j = 1; i >= 0x10; i >>= 4, j++);

    if (dPrecision != -1) j = max (j, dPrecision);

    k = (fPrefix ? j+2 : j);
    n = max (k, (fPrefix ? dWidth+2 : dWidth));

    if (pwBuffer != NULL)
        {
        pwBuffer1 = pwBuffer + dOffset;
        wData     = (fZero ? '0' : wFill);

        if (fRight)
            {
            for (i = n; i > k; i--) pwBuffer1 [i-1] = wData;
            k = 0;
            }
        else
            {
            for (i = 0; i < n - j; i++) pwBuffer1 [i] = wData;
            i = n;
            k = (fZero ? 0 : n - k);
            }
        wData = (fLower ? 'a' : 'A');
        while (j--)
            {
            if ((pwBuffer1 [--i] = (WORD) (dData1 & 0xF)) < 10)
                {
                pwBuffer1 [i] += '0';
                }
            else
                {
                pwBuffer1 [i] -= 10;
                pwBuffer1 [i] += wData;
                }
            dData1 >>= 4;
            }
        if (fPrefix)
            {
            pwBuffer1 [k  ] = '0';
            pwBuffer1 [k+1] = (fLower ? 'x' : 'X');
            }
        }
    if (pwBuffer != NULL) pwBuffer [dOffset+n] = 0;
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _format_single (PWORD  pwBuffer,
                             DWORD  dOffset,
                             PWORD  pwFormat,
                             PDWORD pdFormat,
                             PVOID *ppData,
                             WORD   wFill,
                             BOOL   fUnicode)
    {
    PVOID pData, pText;
    WORD  wData, wFill1;
    BOOL  fAnsi, fShort, fSigned, fLower, fRight, fZero, fPrefix;
    BOOL  fPrecision, fDone, fSkip;
    DWORD dPrecision, dWidth, dData, dFormat, dNumber;
    DWORD n = 0;

    pData   = (ppData   != NULL ? *ppData   : NULL);
    dFormat = (pdFormat != NULL ? *pdFormat : 0);

    if (pwFormat != NULL)
        {
        fAnsi      = !fUnicode;
        fShort     = FALSE;
        fSigned    = FALSE;
        fLower     = FALSE;
        fRight     = FALSE;
        fZero      = FALSE;
        fPrefix    = FALSE;

        wData      = '%';
        wFill1     = wFill;
        dWidth     =  0;
        dPrecision = -1;
        fPrecision = FALSE;
        fDone      = FALSE;

        while ((!fDone) && pwFormat [dFormat])
            {
            fSkip = TRUE;

            switch (pwFormat [dFormat])
                {
// operand size
                case 'l':
                    {
                    fShort = fAnsi = FALSE;
                    break;
                    }
                case 'h':
                    {
                    fShort = fAnsi = TRUE;
                    break;
                    }
// strings
                case 'S':
                    {
                    fAnsi = fUnicode;
                    }
                case 's':
                    {
                    pText = (pData != NULL
                             ? *(PVOID *) pData
                             : NULL);

                    if (fAnsi)
                        {
                        n = _format_ansi
                                (pwBuffer, dOffset,
                                 pText, -1,
                                 dWidth, dPrecision, wFill1,
                                 fRight, fZero);
                        }
                    else
                        {
                        n = _format_unicode
                                (pwBuffer, dOffset,
                                 pText, -1,
                                 dWidth, dPrecision, wFill1,
                                 fRight, fZero);
                        }
                    if (pData != NULL)
                        {
                        pData = (PBYTE) pData + sizeof (PVOID);
                        }
                    fDone = TRUE;
                    break;
                    }
// characters
                case 'C':
                    {
                    fAnsi = fUnicode;
                    }
                case 'c':
                    {
                    wData = (pData != NULL
                             ? (fAnsi
                                ? *(PBYTE) pData
                                : *(PWORD) pData)
                             : ' ');

                    if (pData != NULL)
                        {
                        pData = (PBYTE) pData + sizeof (DWORD);
                        }
                    }
                case '%':
                    {
                    n = _format_unicode
                            (pwBuffer, dOffset,
                             &wData, 1,
                             dWidth, dPrecision, wFill1,
                             fRight, fZero);

                    fDone = TRUE;
                    break;
                    }
// decimal numbers
                case 'd':
                case 'i':
                    {
                    fSigned = TRUE;
                    }
                case 'u':
                    {
                    dData = (pData != NULL
                             ? (fSigned
                                ? (fShort
                                   ? *(PSHORT) pData
                                   : *(PLONG ) pData)
                                : (fShort
                                   ? *(PWORD ) pData
                                   : *(PDWORD) pData))
                             : 0);

                    n = _format_decimal
                            (pwBuffer, dOffset, dData,
                             dWidth, dPrecision, wFill1,
                             fRight, fZero, fPrefix, fSigned);

                    if (pData != NULL)
                        {
                        pData = (PBYTE) pData + sizeof (DWORD);
                        }
                    fDone = TRUE;
                    break;
                    }
// hex numbers
                case 'x':
                    {
                    fLower = TRUE;
                    }
                case 'X':
                    {
                    dData = (pData != NULL
                             ? (fShort
                                ? *(PWORD ) pData
                                : *(PDWORD) pData)
                             : 0);

                    n = _format_hex
                            (pwBuffer, dOffset, dData,
                             dWidth, dPrecision, wFill1,
                             fRight, fZero, fPrefix, fLower);

                    if (pData != NULL)
                        {
                        pData = (PBYTE) pData + sizeof (DWORD);
                        }
                    fDone = TRUE;
                    break;
                    }
// output styles
                case '+':
                    {
                    if (pwFormat [dFormat+1])
                        {
                        wFill1 = pwFormat [++dFormat];
                        }
                    break;
                    }
                case '-':
                    {
                    fRight = TRUE;
                    break;
                    }
                case '0':
                    {
                    fZero = TRUE;
                    break;
                    }
                case '#':
                    {
                    fPrefix = TRUE;
                    break;
                    }
// output width
                default:
                    {
                    if (fPrecision = (pwFormat [dFormat] == '.'))
                        {
                        dFormat++;
                        dPrecision = 0;

                        fSkip = FALSE;
                        }
                    if ((pwFormat [dFormat] >= '0') &&
                        (pwFormat [dFormat] <= '9'))
                        {
                        dNumber = 0;

                        while ((pwFormat [dFormat] >= '0') &&
                               (pwFormat [dFormat] <= '9'))
                            {
                            dNumber *= 10;
                            dNumber += (pwFormat [dFormat++] - '0');
                            }
                        if (fPrecision)
                            {
                            dPrecision = dNumber;
                            }
                        else
                            {
                            dWidth = dNumber;
                            }
                        fSkip = FALSE;
                        }
                    break;
                    }
                }
            if (fSkip) dFormat++;
            }
        }
    if (pwBuffer != NULL) pwBuffer [dOffset+n] = 0;

    if (pdFormat != NULL) *pdFormat = dFormat;
    if (ppData   != NULL) *ppData   = pData;
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _format_multi (PWORD pwBuffer,
                            DWORD dOffset,
                            PWORD pwFormat,
                            PVOID pArguments,
                            WORD  wFill,
                            BOOL  fUnicode)
    {
    PVOID pData;
    DWORD i, j;
    DWORD n = 0;

    if (pwFormat != NULL)
        {
        if ((pData = pArguments) != NULL)
            {
            for (i = 0; pwFormat [i]; i = j)
                {
                for (j = i; pwFormat [j] && (pwFormat [j] != '%');
                     j++);

                n += _format_unicode (pwBuffer, dOffset+n,
                                      pwFormat+i, j-i,
                                      0, -1, wFill,
                                      TRUE, FALSE);

                if (pwFormat [j] == '%')
                    {
                    j++;

                    n += _format_single (pwBuffer, dOffset+n,
                                         pwFormat, &j, &pData,
                                         wFill, fUnicode);
                    }
                }
            }
        else
            {
            n = _format_unicode (pwBuffer, dOffset,
                                 pwFormat, -1,
                                 0, -1, wFill,
                                 TRUE, FALSE);
            }
        }
    if (pwBuffer != NULL) pwBuffer [dOffset+n] = 0;
    return n;
    }

// =================================================================
// CONSOLE MANAGEMENT
// =================================================================

BOOL WINAPI _console_test (VOID)
    {
    BYTE abTitle [0x1000];

    return GetConsoleTitleA (abTitle, sizeof (abTitle)) != 0;
    }

// -----------------------------------------------------------------

BOOL WINAPI _console_open (VOID)
    {
    if ((!_fStdHandles) && (!_fStdFailure))
        {
        _fStdTransient = (!_console_test ()) && AllocConsole ();

        if (_console_test ())
            {
            _hStdInput  = GetStdHandle (STD_INPUT_HANDLE);
            _hStdOutput = GetStdHandle (STD_OUTPUT_HANDLE);
            _hStdError  = GetStdHandle (STD_ERROR_HANDLE);

            if ((_hStdInput  != INVALID_HANDLE_VALUE) &&
                (_hStdOutput != INVALID_HANDLE_VALUE) &&
                (_hStdError  != INVALID_HANDLE_VALUE))
                {
                _fStdHandles = TRUE;
                }
            else
                {
                _hStdInput  = INVALID_HANDLE_VALUE;
                _hStdOutput = INVALID_HANDLE_VALUE;
                _hStdError  = INVALID_HANDLE_VALUE;
                }
            }
        if ((_fStdFailure = !_fStdHandles) && _fStdTransient)
            {
            FreeConsole ();
            _fStdTransient = FALSE;
            }
        }
    return _fStdHandles;
    }

// -----------------------------------------------------------------

BOOL WINAPI _console_close (VOID)
    {
    BOOL fOk = FALSE;

    if (_fStdHandles)
        {
        _hStdInput   = INVALID_HANDLE_VALUE;
        _hStdOutput  = INVALID_HANDLE_VALUE;
        _hStdError   = INVALID_HANDLE_VALUE;
        _fStdHandles = FALSE;

        fOk = TRUE;
        }
    if (_fStdTransient)
        {
        if (_console_test ()) FreeConsole ();
        _fStdTransient = FALSE;
        }
    _fStdFailure = FALSE;
    return fOk;
    }

// -----------------------------------------------------------------

DWORD WINAPI _console_write (HANDLE hf,
                             PVOID  pData,
                             DWORD  dData)
    {
    PBYTE pbData;
    DWORD n1, n2;
    DWORD n = 0;

    if ((hf != INVALID_HANDLE_VALUE) && (pData != NULL))
        {
        for (n = 0; n < dData; n += n2)
            {
            pbData = (PBYTE) pData + n;
            n1     = min (dData - n, 0x8000);
            n2     = 0;

            if ((!WriteFile (hf, pbData, n1, &n2, NULL)) ||
                (!n2)) break;
            }
        }
    return n;
    }

////////////////////////////////////////////////////////////////////
#endif // #ifdef _INLINE_SBSPRINT_
////////////////////////////////////////////////////////////////////

#endif // #ifndef _SBSPRINT_H_

// =================================================================
// END OF FILE
// =================================================================
