
// __________________________________________________________
//
//                         SbsText.h
//             SBS Text Management Library V1.00
//                07-20-2001 Sven B. Schreiber
//                       sbs@orgon.com
// __________________________________________________________

#ifndef _SBSTEXT_H_
#define _SBSTEXT_H_

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// REVISION HISTORY
// =================================================================

/*

07-20-2001 V1.00 Original version (SBS).

*/

// =================================================================
// SINGLE-CHARACTER CONVERSION MACROS
// =================================================================

#define GERMAN_ASCII(_b)   (_abGermanAscii [_b])
#define ASCII_ANSI(_b)     (_abAsciiAnsi   [_b])
#define ANSI_ASCII(_b)     (_abAnsiAscii   [_b])
#define ANSI_UNICODE(_b)   (_awAnsiUnicode [_b])
#define UNICODE_ANSI(_w)   (_abUnicodeAnsi [_w])

#define GERMAN_ANSI(_b)    ASCII_ANSI   (GERMAN_ASCII (_b))
#define GERMAN_UNICODE(_b) ANSI_UNICODE (GERMAN_ANSI  (_b))

#define ASCII_UNICODE(_b)  ANSI_UNICODE (ASCII_ANSI   (_b))
#define UNICODE_ASCII(_w)  ANSI_ASCII   (UNICODE_ANSI (_w))

// =================================================================
// FUNCTION PROTOTYPES
// =================================================================

#ifdef  _INLINE_SBSTEXT_
#define _INLINE_SBSWCHAR_

#define DLL_EXPORT __declspec (dllexport)

#else   // #ifdef _INLINE_SBSTEXT_

#define DLL_EXPORT

#endif  // #ifdef _INLINE_SBSTEXT_

// -----------------------------------------------------------------

DLL_EXPORT VOID WINAPI _tinit (VOID);

DLL_EXPORT VOID WINAPI _texit (VOID);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _tsizeA (PBYTE pbData);

DLL_EXPORT DWORD WINAPI _tsizeW (PWORD pwData);

DLL_EXPORT PBYTE WINAPI _tzeroA (PBYTE pbTo,
                                 DWORD dChars);

DLL_EXPORT PWORD WINAPI _tzeroW (PWORD pwTo,
                                 DWORD dChars);

DLL_EXPORT PBYTE WINAPI _tfillA (PBYTE pbTo,
                                 DWORD dChars,
                                 BYTE  bData);

DLL_EXPORT PWORD WINAPI _tfillW (PWORD pwTo,
                                 DWORD dChars,
                                 WORD  wData);

DLL_EXPORT LONG WINAPI _tcompA (PBYTE pbData1,
                                PBYTE pbData2);

DLL_EXPORT LONG WINAPI _tcompW (PWORD pwData1,
                                PWORD pwData2);

DLL_EXPORT LONG WINAPI _tcompnA (PBYTE pbData1,
                                 PBYTE pbData2,
                                 DWORD dLimit);

DLL_EXPORT LONG WINAPI _tcompnW (PWORD pwData1,
                                 PWORD pwData2,
                                 DWORD dLimit);

DLL_EXPORT LONG WINAPI _tcompiA (PBYTE pbData1,
                                 PBYTE pbData2);

DLL_EXPORT LONG WINAPI _tcompiW (PWORD pwData1,
                                 PWORD pwData2);

DLL_EXPORT LONG WINAPI _tcompniA (PBYTE pbData1,
                                  PBYTE pbData2,
                                  DWORD dLimit);

DLL_EXPORT LONG WINAPI _tcompniW (PWORD pwData1,
                                  PWORD pwData2,
                                  DWORD dLimit);

DLL_EXPORT LONG WINAPI _tcompxA (PBYTE pbData1,
                                 DWORD dData1,
                                 PBYTE pbData2,
                                 DWORD dData2,
                                 BOOL  fTestZero,
                                 PBYTE pbWeights);

DLL_EXPORT LONG WINAPI _tcompxW (PWORD pwData1,
                                 DWORD dData1,
                                 PWORD pwData2,
                                 DWORD dData2,
                                 BOOL  fTestZero,
                                 PWORD pwWeights);

DLL_EXPORT PBYTE WINAPI _tconv (PBYTE pbTo,
                                PBYTE pbFrom,
                                DWORD dChars,
                                PBYTE pbTable);

DLL_EXPORT PBYTE WINAPI _tcopyA2A (PBYTE pbTo,
                                   PBYTE pbFrom,
                                   DWORD dChars);

DLL_EXPORT PWORD WINAPI _tcopyA2W (PWORD pwTo,
                                   PBYTE pbFrom,
                                   DWORD dChars);

DLL_EXPORT PBYTE WINAPI _tcopyW2A (PBYTE pbTo,
                                   PWORD pwFrom,
                                   DWORD dChars);

DLL_EXPORT PWORD WINAPI _tcopyW2W (PWORD pwTo,
                                   PWORD pwFrom,
                                   DWORD dChars);

DLL_EXPORT DWORD WINAPI _tcopyA (PBYTE pbTo,
                                 PBYTE pbFrom);

DLL_EXPORT DWORD WINAPI _tcopyW (PWORD pwTo,
                                 PWORD pwFrom);

DLL_EXPORT DWORD WINAPI _tcopynA (PBYTE pbTo,
                                  PBYTE pbFrom,
                                  DWORD dLimit);

DLL_EXPORT DWORD WINAPI _tcopynW (PWORD pwTo,
                                  PWORD pwFrom,
                                  DWORD dLimit);

DLL_EXPORT DWORD WINAPI _tconcA (PBYTE pbTo,
                                 PBYTE pbFrom);

DLL_EXPORT DWORD WINAPI _tconcW (PWORD pwTo,
                                 PWORD pwFrom);

DLL_EXPORT DWORD WINAPI _tconcnA (PBYTE pbTo,
                                  PBYTE pbFrom,
                                  DWORD dLimit);

DLL_EXPORT DWORD WINAPI _tconcnW (PWORD pwTo,
                                  PWORD pwFrom,
                                  DWORD dLimit);

DLL_EXPORT PBYTE WINAPI _tcharA (PBYTE pbData,
                                 BYTE  bData);

DLL_EXPORT PWORD WINAPI _tcharW (PWORD pwData,
                                 WORD  wData);

DLL_EXPORT PBYTE WINAPI _tcharrA (PBYTE pbData,
                                  BYTE  bData);

DLL_EXPORT PWORD WINAPI _tcharrW (PWORD pwData,
                                  WORD  wData);

// -----------------------------------------------------------------

#undef DLL_EXPORT

#include <SbsWChar.h>

// =================================================================
// CONDITIONAL ANSI/UNICODE SYMBOLS
// =================================================================

#define _tcopybA(_t,_f) _tcopynA((_t),(_f),sizeof(_t))
#define _tcopybW(_t,_f) _tcopynW((_t),(_f),sizeof(_t)/sizeof(WORD))

#ifdef  UNICODE

#define _tsize         _tsizeW
#define _tzero         _tzeroW
#define _tfill         _tfillW
#define _tcomp         _tcompW
#define _tcompn        _tcompnW
#define _tcompi        _tcompiW
#define _tcompni       _tcompniW
#define _tcompx        _tcompxW
#define _tcopyT2A      _tcopyW2A
#define _tcopyT2W      _tcopyW2W
#define _tcopyA2T      _tcopyA2W
#define _tcopyW2T      _tcopyW2W
#define _tcopy         _tcopyW
#define _tcopyn        _tcopynW
#define _tcopyb        _tcopybW
#define _tconc         _tconcW
#define _tconcn        _tconcnW
#define _tchar         _tcharW
#define _tcharr        _tcharrW

#else   // #ifdef UNICODE

#define _tsize         _tsizeA
#define _tzero         _tzeroA
#define _tfill         _tfillA
#define _tcomp         _tcompA
#define _tcompn        _tcompnA
#define _tcompi        _tcompiA
#define _tcompni       _tcompniA
#define _tcompx        _tcompxA
#define _tcopyT2A      _tcopyA2A
#define _tcopyT2W      _tcopyA2W
#define _tcopyA2T      _tcopyA2A
#define _tcopyW2T      _tcopyW2A
#define _tcopy         _tcopyA
#define _tcopyn        _tcopynA
#define _tcopyb        _tcopybA
#define _tconc         _tconcA
#define _tconcn        _tconcnA
#define _tchar         _tcharA
#define _tcharr        _tcharrA

#endif  // #ifdef UNICODE

////////////////////////////////////////////////////////////////////
#ifndef _INLINE_SBSTEXT_
////////////////////////////////////////////////////////////////////

__declspec (dllimport) BYTE _abUnicodeAnsi     [SBS_UNICODE];

__declspec (dllimport) WORD _awWeightsUnicode  [SBS_UNICODE];
__declspec (dllimport) WORD _awWeightsUnicodeI [SBS_UNICODE];

__declspec (dllimport) BYTE _abWeightsAnsi     [SBS_ANSI];
__declspec (dllimport) BYTE _abWeightsAnsiI    [SBS_ANSI];

////////////////////////////////////////////////////////////////////
#else // #ifndef _INLINE_SBSTEXT_
////////////////////////////////////////////////////////////////////

__declspec (dllexport) BYTE _abUnicodeAnsi     [SBS_UNICODE];

__declspec (dllexport) WORD _awWeightsUnicode  [SBS_UNICODE];
__declspec (dllexport) WORD _awWeightsUnicodeI [SBS_UNICODE];

__declspec (dllexport) BYTE _abWeightsAnsi     [SBS_ANSI];
__declspec (dllexport) BYTE _abWeightsAnsiI    [SBS_ANSI];

// =================================================================
// STARTUP & CLEANUP
// =================================================================

VOID WINAPI _tinit (VOID)
    {
    _winit (_abUnicodeAnsi, _awWeightsUnicode, _awWeightsUnicodeI,
                            _abWeightsAnsi,    _abWeightsAnsiI);
    return;
    }

// -----------------------------------------------------------------

VOID WINAPI _texit (VOID)
    {
    _wexit ();
    return;
    }

// =================================================================
// STRING MANIPULATION
// =================================================================

DWORD WINAPI _tsizeA (PBYTE pbData)
    {
    DWORD n = 0;

    __asm
        {
                    mov     edi, pbData
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    dec     ecx
                    mov     n, ecx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tsizeW (PWORD pwData)
    {
    DWORD n = 0;

    __asm
        {
                    mov     edi, pwData
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    dec     ecx
                    mov     n, ecx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tzeroA (PBYTE pbTo,
                      DWORD dChars)
    {
    PBYTE pbNext = pbTo;

    __asm
        {
                    mov     edi, pbTo
                    mov     ecx, dChars

                    test    edi, edi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    xor     eax, eax

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     stosd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     stosb

                    mov     pbNext, edi
        _return:
        }
    return pbNext;
    }

// -----------------------------------------------------------------

PWORD WINAPI _tzeroW (PWORD pwTo,
                      DWORD dChars)
    {
    PWORD pwNext = pwTo;

    __asm
        {
                    mov     edi, pwTo
                    mov     ecx, dChars

                    test    edi, edi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    xor     eax, eax

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     stosd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     stosw

                    mov     pwNext, edi
        _return:
        }
    return pwNext;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tfillA (PBYTE pbTo,
                      DWORD dChars,
                      BYTE  bData)
    {
    PBYTE pbNext = pbTo;

    __asm
        {
                    mov     edi, pbTo
                    mov     ecx, dChars

                    test    edi, edi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    mov     ah, bData
                    mov     al, ah
                    shl     eax, 8
                    mov     al, ah
                    shl     eax, 8
                    mov     al, ah

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     stosd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     stosb

                    mov     pbNext, edi
        _return:
        }
    return pbNext;
    }

// -----------------------------------------------------------------

PWORD WINAPI _tfillW (PWORD pwTo,
                      DWORD dChars,
                      WORD  wData)
    {
    PWORD pwNext = pwTo;

    __asm
        {
                    mov     edi, pwTo
                    mov     ecx, dChars

                    test    edi, edi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    mov     ax,wData
                    shl     eax, 16
                    mov     ax,wData

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     stosd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     stosw

                    mov     pwNext, edi
        _return:
        }
    return pwNext;
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompA (PBYTE pbData1,
                     PBYTE pbData2)
    {
    return _tcompxA (pbData1, -1,
                     pbData2, -1,
                     TRUE, _abWeightsAnsi);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompW (PWORD pwData1,
                     PWORD pwData2)
    {
    return _tcompxW (pwData1, -1,
                     pwData2, -1,
                     TRUE, _awWeightsUnicode);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompnA (PBYTE pbData1,
                      PBYTE pbData2,
                      DWORD dLimit)
    {
    return _tcompxA (pbData1, dLimit,
                     pbData2, dLimit,
                     TRUE, _abWeightsAnsi);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompnW (PWORD pwData1,
                      PWORD pwData2,
                      DWORD dLimit)
    {
    return _tcompxW (pwData1, dLimit,
                     pwData2, dLimit,
                     TRUE, _awWeightsUnicode);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompiA (PBYTE pbData1,
                      PBYTE pbData2)
    {
    return _tcompxA (pbData1, -1,
                     pbData2, -1,
                     TRUE, _abWeightsAnsiI);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompiW (PWORD pwData1,
                      PWORD pwData2)
    {
    return _tcompxW (pwData1, -1,
                     pwData2, -1,
                     TRUE, _awWeightsUnicodeI);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompniA (PBYTE pbData1,
                       PBYTE pbData2,
                       DWORD dLimit)
    {
    return _tcompxA (pbData1, dLimit,
                     pbData2, dLimit,
                     TRUE, _abWeightsAnsiI);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompniW (PWORD pwData1,
                       PWORD pwData2,
                       DWORD dLimit)
    {
    return _tcompxW (pwData1, dLimit,
                     pwData2, dLimit,
                     TRUE, _awWeightsUnicodeI);
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompxA (PBYTE pbData1,
                      DWORD dData1,
                      PBYTE pbData2,
                      DWORD dData2,
                      BOOL  fTestZero,
                      PBYTE pbWeights)
    {
    LONG n = 0;

    __asm
        {
                    mov     esi, pbData1
                    mov     edi, pbData2
                    mov     ebx, pbWeights

                    cmp     esi, edi
                    jz      _return

                    test    esi, esi
                    jz      _label05
                    test    edi, edi
                    jz      _label05

                    xor     ecx, ecx
                    xor     eax, eax
                    xor     edx, edx
                    jmp     _label04

        _label01:   mov     al, [esi]
                    mov     dl, [edi]

                    test    ebx, ebx
                    jz      _label02
                    mov     al, [ebx+eax]
                    mov     dl, [ebx+edx]

        _label02:   cmp     eax, edx
                    jnz     _label07

                    cmp     fTestZero, 0
                    jz      _label03
                    test    eax, edx
                    jz      _return

        _label03:   inc     ecx
                    inc     esi
                    inc     edi

        _label04:   cmp     ecx, dData1
                    jz      _label06
                    cmp     ecx, dData2
                    jz      _label06
                    jmp     _label01

        _label05:   cmp     esi, edi
                    jmp     _label07

        _label06:   mov     eax, dData1
                    cmp     eax, dData2
                    jz      _return
        _label07:   sbb     eax, eax
                    shl     eax, 1
                    inc     eax
                    mov     n, eax
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

LONG WINAPI _tcompxW (PWORD pwData1,
                      DWORD dData1,
                      PWORD pwData2,
                      DWORD dData2,
                      BOOL  fTestZero,
                      PWORD pwWeights)
    {
    LONG n = 0;

    __asm
        {
                    mov     esi, pwData1
                    mov     edi, pwData2
                    mov     ebx, pwWeights

                    cmp     esi, edi
                    jz      _return

                    test    esi, esi
                    jz      _label05
                    test    edi, edi
                    jz      _label05

                    xor     ecx, ecx
                    xor     eax, eax
                    xor     edx, edx
                    jmp     _label04

        _label01:   mov     ax, [esi]
                    mov     dx, [edi]

                    test    ebx, ebx
                    jz      _label02
                    mov     ax, [ebx+eax*2]
                    mov     dx, [ebx+edx*2]

        _label02:   cmp     eax, edx
                    jnz     _label07

                    cmp     fTestZero, 0
                    jz      _label03
                    test    eax, edx
                    jz      _return

        _label03:   inc     ecx
                    add     esi, 2
                    add     edi, 2

        _label04:   cmp     ecx, dData1
                    jz      _label06
                    cmp     ecx, dData2
                    jz      _label06
                    jmp     _label01

        _label05:   cmp     esi, edi
                    jmp     _label07

        _label06:   mov     eax, dData1
                    cmp     eax, dData2
                    jz      _return
        _label07:   sbb     eax, eax
                    shl     eax, 1
                    inc     eax
                    mov     n, eax
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tconv (PBYTE pbTo,
                     PBYTE pbFrom,
                     DWORD dChars,
                     PBYTE pbTable)
    {
    PBYTE pbNext = pbTo;

    __asm
        {
                    mov     edi, pbTo
                    mov     esi, pbFrom
                    mov     ecx, dChars
                    mov     ebx, pbTable
                    xor     eax, eax

                    test    edi, edi
                    jz      _return
                    test    esi, esi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    test    ebx, ebx
                    jnz     _label03

                    cmp     ecx, -1
                    jnz     _label01

                    xchg    edi, esi
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx
                    xchg    edi, esi

        _label01:   cmp     esi, edi
                    jnz     _label02
                    add     edi, ecx
                    jmp     _label06

        _label02:   mov     edx, ecx
                    shr     ecx, 2
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     movsb

                    jmp     _label06

        _label03:   cmp     ecx, -1
                    jz      _label05

        _label04:   lodsb
                    mov     al, [ebx+eax]
                    stosb
                    dec     ecx
                    jnz     _label04
                    jmp     _label06

        _label05:   lodsb
                    mov     al, [ebx+eax]
                    stosb
                    test    al, al
                    jnz     _label05

        _label06:   mov     pbNext, edi
        _return:
        }
    return pbNext;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tcopyA2A (PBYTE pbTo,
                        PBYTE pbFrom,
                        DWORD dChars)
    {
    PBYTE pbNext = pbTo;

    __asm
        {
                    mov     esi, pbTo
                    mov     edi, pbFrom
                    mov     ecx, dChars

                    test    esi, esi
                    jz      _return
                    test    edi, edi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    cmp     ecx, -1
                    jnz     _label01

                    xor     eax, eax
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx

        _label01:   xchg    edi, esi

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     movsb

                    mov     pbNext, edi
        _return:
        }
    return pbNext;
    }

// -----------------------------------------------------------------

PWORD WINAPI _tcopyA2W (PWORD pwTo,
                        PBYTE pbFrom,
                        DWORD dChars)
    {
    PWORD pwNext = pwTo;

    __asm
        {
                    mov     edi, pwTo
                    mov     esi, pbFrom
                    mov     ecx, dChars

                    test    edi, edi
                    jz      _return
                    test    esi, esi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    xor     eax, eax
                    mov     ebx, offset _awAnsiUnicode
                    cmp     ecx, -1
                    jz      _label02

        _label01:   xor     ah, ah
                    lodsb
                    mov     ax, [ebx+eax*2]
                    stosw
                    dec     ecx
                    jnz     _label01
                    jmp     _label03

        _label02:   xor     ah, ah
                    lodsb
                    mov     ax, [ebx+eax*2]
                    stosw
                    test    eax, eax
                    jnz     _label02

        _label03:   mov     pwNext, edi
        _return:
        }
    return pwNext;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tcopyW2A (PBYTE pbTo,
                        PWORD pwFrom,
                        DWORD dChars)
    {
    PBYTE pbNext = pbTo;

    __asm
        {
                    mov     edi, pbTo
                    mov     esi, pwFrom
                    mov     ecx, dChars

                    test    edi, edi
                    jz      _return
                    test    esi, esi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    xor     eax, eax
                    mov     ebx, offset _abUnicodeAnsi
                    cmp     ecx, -1
                    jz      _label02

        _label01:   lodsw
                    mov     al, [ebx+eax]
                    stosb
                    dec     ecx
                    jnz     _label01
                    jmp     _label03

        _label02:   lodsw
                    mov     al, [ebx+eax]
                    stosb
                    test    al, al
                    jnz     _label02

        _label03:   mov     pbNext, edi
        _return:
        }
    return pbNext;
    }

// -----------------------------------------------------------------

PWORD WINAPI _tcopyW2W (PWORD pwTo,
                        PWORD pwFrom,
                        DWORD dChars)
    {
    PWORD pwNext = pwTo;

    __asm
        {
                    mov     esi, pwTo
                    mov     edi, pwFrom
                    mov     ecx, dChars

                    test    esi, esi
                    jz      _return
                    test    edi, edi
                    jz      _return
                    test    ecx, ecx
                    jz      _return

                    cmp     ecx, -1
                    jnz     _label01

                    xor     eax, eax
                    repnz   scasw
                    not     ecx
                    sub     edi, ecx
                    sub     edi, ecx

        _label01:   xchg    edi, esi

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     movsw

                    mov     pwNext, edi
        _return:
        }
    return pwNext;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tcopyA (PBYTE pbTo,
                      PBYTE pbFrom)
    {
    DWORD n = 0;

    __asm
        {
                    mov     esi, pbTo
                    mov     edi, pbFrom
                    xor     eax, eax

                    test    esi, esi
                    jz      _return
                    mov     [esi], al

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     movsb

                    dec     edx
                    mov     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tcopyW (PWORD pwTo,
                      PWORD pwFrom)
    {
    DWORD n = 0;

    __asm
        {
                    mov     esi, pwTo
                    mov     edi, pwFrom
                    xor     eax, eax

                    test    esi, esi
                    jz      _return
                    mov     [esi], ax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    sub     edi, ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     movsw

                    dec     edx
                    mov     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tcopynA (PBYTE pbTo,
                       PBYTE pbFrom,
                       DWORD dLimit)
    {
    DWORD n = 0;

    __asm
        {
                    mov     esi, pbTo
                    mov     edi, pbFrom
                    mov     edx, dLimit
                    xor     eax, eax

                    test    esi, esi
                    jz      _return
                    test    edx, edx
                    jz      _return
                    mov     [esi], al

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    cmp     ecx, edx
                    jna     _label01
                    mov     ecx, edx
        _label01:   dec     ecx

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     movsb

                    stosb
                    mov     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tcopynW (PWORD pwTo,
                       PWORD pwFrom,
                       DWORD dLimit)
    {
    DWORD n = 0;

    __asm
        {
                    mov     esi, pwTo
                    mov     edi, pwFrom
                    mov     edx, dLimit
                    xor     eax, eax

                    test    esi, esi
                    jz      _return
                    test    edx, edx
                    jz      _return
                    mov     [esi], ax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    sub     edi, ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    cmp     ecx, edx
                    jna     _label01
                    mov     ecx, edx
        _label01:   dec     ecx

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     movsw

                    stosw
                    mov     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tconcA (PBYTE pbTo,
                      PBYTE pbFrom)
    {
    DWORD n = 0;

    __asm
        {
                    mov     edi, pbTo
                    mov     esi, pbFrom
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    dec     ecx
                    mov     n, ecx

                    test    esi, esi
                    jz      _return

                    dec     edi
                    xchg    edi, esi

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     movsb

                    dec     edx
                    add     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tconcW (PWORD pwTo,
                      PWORD pwFrom)
    {
    DWORD n = 0;

    __asm
        {
                    mov     edi, pwTo
                    mov     esi, pwFrom
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    dec     ecx
                    mov     n, ecx

                    test    esi, esi
                    jz      _return

                    dec     edi
                    dec     edi
                    xchg    edi, esi

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    sub     edi, ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     movsw

                    dec     edx
                    add     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tconcnA (PBYTE pbTo,
                       PBYTE pbFrom,
                       DWORD dLimit)
    {
    DWORD n = 0;

    __asm
        {
                    mov     edi, pbTo
                    mov     esi, pbFrom
                    mov     edx, dLimit
                    xor     eax, eax

                    test    edi, edi
                    jz      _return
                    test    edx, edx
                    jz      _return

                    mov     ecx, edx
                    repnz   scasb
                    inc     ecx
                    sub     edx, ecx
                    mov     n, edx

                    dec     edi
                    mov     [edi], al

                    test    esi, esi
                    jz      _return

                    mov     edx, ecx
                    xchg    edi, esi

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    cmp     ecx, edx
                    jna     _label01
                    mov     ecx, edx
        _label01:   dec     ecx

                    mov     edx, ecx
                    shr     ecx, 2
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 3
                    rep     movsb

                    stosb
                    add     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _tconcnW (PWORD pwTo,
                       PWORD pwFrom,
                       DWORD dLimit)
    {
    DWORD n = 0;

    __asm
        {
                    mov     edi, pwTo
                    mov     esi, pwFrom
                    mov     edx, dLimit
                    xor     eax, eax

                    test    edi, edi
                    jz      _return
                    test    edx, edx
                    jz      _return

                    mov     ecx, edx
                    repnz   scasw
                    inc     ecx
                    sub     edx, ecx
                    mov     n, edx

                    dec     edi
                    dec     edi
                    mov     [edi], ax

                    test    esi, esi
                    jz      _return

                    mov     edx, ecx
                    xchg    edi, esi

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    sub     edi, ecx
                    sub     edi, ecx
                    xchg    edi, esi

                    cmp     ecx, edx
                    jna     _label01
                    mov     ecx, edx
        _label01:   dec     ecx

                    mov     edx, ecx
                    shr     ecx, 1
                    rep     movsd

                    mov     ecx, edx
                    and     ecx, 1
                    rep     movsw

                    stosw
                    mov     n, edx
        _return:
        }
    return n;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tcharA (PBYTE pbData,
                      BYTE  bData)
    {
    PBYTE pbHit = NULL;

    __asm
        {
                    mov     edi, pbData
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    sub     edi, ecx

                    mov     al, bData
                    repnz   scasb
                    jnz     _return

                    dec     edi
                    mov     pbHit, edi
        _return:
        }
    return pbHit;
    }

// -----------------------------------------------------------------

PWORD WINAPI _tcharW (PWORD pwData,
                      WORD  wData)
    {
    PWORD pwHit = NULL;

    __asm
        {
                    mov     edi, pwData
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    sub     edi, ecx
                    sub     edi, ecx

                    mov     ax, wData
                    repnz   scasw
                    jnz     _return

                    dec     edi
                    dec     edi
                    mov     pwHit, edi
        _return:
        }
    return pwHit;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _tcharrA (PBYTE pbData,
                       BYTE  bData)
    {
    PBYTE pbHit = NULL;

    __asm
        {
                    mov     edi, pbData
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasb
                    not     ecx
                    dec     edi

                    mov     al, bData
                    std
                    repnz   scasb
                    cld
                    jnz     _return

                    inc     edi
                    mov     pbHit, edi
        _return:
        }
    return pbHit;
    }

// -----------------------------------------------------------------

PWORD WINAPI _tcharrW (PWORD pwData,
                       WORD  wData)
    {
    PWORD pwHit = NULL;

    __asm
        {
                    mov     edi, pwData
                    xor     eax, eax

                    test    edi, edi
                    jz      _return

                    or      ecx, -1
                    repnz   scasw
                    not     ecx
                    dec     edi
                    dec     edi

                    mov     ax, wData
                    std
                    repnz   scasw
                    cld
                    jnz     _return

                    inc     edi
                    inc     edi
                    mov     pwHit, edi
        _return:
        }
    return pwHit;
    }

////////////////////////////////////////////////////////////////////
#endif // #ifndef _INLINE_SBSTEXT_
////////////////////////////////////////////////////////////////////

#endif // #ifndef _SBSTEXT_H_

// =================================================================
// END OF FILE
// =================================================================
