; unWrapper for 'ReflexiveGameWrapper'
; Windows 9x/ME, NT/2000/XP
; created by eraser, Sep 25 2008
; last update: Oct 06 2008

; !!! THIS IS AN EXPERIMENTAL VERSION !!!

; This application and its source code are for
; private study or research purposes only!

; devoted to ARTeam
; thx goes to anorganix and Shub-Nigurrath

; thx goes also to EliCZ, MazeGen and Hypnotix
; for casual consultations and motivation

.386
.model flat,stdcall
option casemap:none

include c:\masm32\include\windows.inc
include c:\masm32\include\user32.inc
include c:\masm32\include\kernel32.inc
include c:\masm32\include\comdlg32.inc
include c:\masm32\include\imagehlp.inc

includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\comdlg32.lib
includelib c:\masm32\lib\imagehlp.lib

.const
FILESIZE		equ MAX_PATH
NUMBER_OF_API	equ 3

.data
szFilter		db "Executable files",0,"*.exe",0,0
szMsgTitle		db "ReflexiveGameUnWrapper created by eraser",0
szMsgCreatePrEr	db "Unable to load/start the selected executable file!",0
szMsgReadError 	db "The memory could not be read!",0
szMsgWriteError db "The memory could not be write!",0
szMsgMemAllocEr db "Unable to allocate free memory!",0
szMsgLdrOpenEr	db "Unable to open the target file!",0
szMsgFileOpenEr	db "Unable to open an encrypted file (usually RWG)!",0
szMsgFileNewEr	db "Error creating a decrypted file!",0
szMsgFileReadEr	db "An error occured while reading the encrypted file!",0
szMsgNotPEFile	db "The RWG file is invalid! Not a valid Win32 application!",0
szMsgFileWritEr db "Error writing data to the new encrypted file!",0
szMsgSuccess	db "Unwrapped file (usually .RWG.EXE extension) has been successfully created! Check your game folder.",0
szMsgDbgError	db "Debuggee failed. There are several possible reasons for this:",13,10
				db 13,10
				db "1. You haven't pressed the 'Play Game' button.",13,10
				db "2. The created process has been terminated!",13,10
				db "3. The game's trial period has expired due to a built-in time limit.",13,10
				db "4. Unknow target or unknow error.",13,10
				db 13,10
				db "Note: In Win9x/ME due to system instability perform the restart and try it again.",0
szDotExe		db ".exe",0
align 4
szKernel32		db "kernel32.dll",0
szCreateProcess db "CreateProcessA",0
szWritePrMem	db "WriteProcessMemory",0
szOpenProcess	db "OpenProcess",0
align 4
hRWGFile		dd INVALID_HANDLE_VALUE
breakpoint		db 0CCh				; int 3
align 4

.data?
ofn				OPENFILENAME <>
sinfo			STARTUPINFO <>
pi				PROCESS_INFORMATION <>
de				DEBUG_EVENT <>
align 4								; aligned due to NT
ct				CONTEXT <>

szFile			db FILESIZE dup (?)
szDir			db FILESIZE dup (?)
szRWGFile		db FILESIZE dup (?)
align 4
dwBaseAddr		dd ?
pDecrypted		dd ?
dwSize			dd ?
dwProcessId		dd ?
hProcess		dd ?
buf				db FILESIZE dup (?)
dwAddr			dd ?
hLoaderFile		dd ?
dwLoaderSize	dd ?
dwRWGSize		dd ?
pRWGAddr		dd ?
pLoaderAddr		dd ?
dwBytesRorW		dd ?
pCP				dd ?				; pointer to CreateProcess
pWPM			dd ?				; pointer to WriteProcessMemory
pOPr			dd ?				; pointer to OpenProcess
pNTh			dd ?
ContinueStatus	dd ?
fe				dd ? 				; first system exception (program is loaded and ready)
original		db ?
align 4
pAPI			dd ?
dwAPI			dd ?				; number of APIs in NUMBER_OF_API
pBPAddr			dd ?

.code

	db "eraser, Oct/2008",0

align 4
start:

	mov [ofn.lStructSize], sizeof ofn
	mov [ofn.lpstrFilter], offset szFilter
	mov [ofn.lpstrFile], offset szFile
	mov [ofn.nMaxFile], FILESIZE
	mov [ofn.Flags], OFN_FILEMUSTEXIST+OFN_PATHMUSTEXIST+OFN_LONGNAMES+OFN_EXPLORER
	
	invoke GetOpenFileName, addr ofn
	or eax, eax
	jz exit
	
	cld
	mov esi, offset szFile
	mov edi, offset szDir
	movzx ecx, [ofn.nFileOffset]
	rep movsb
	mov byte ptr [edi], 0			; szDir is NULL terminated, however...
	
	; ##############################
	; # fit the loader into a memory
	invoke CreateFile, addr szFile, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL
	mov [hLoaderFile], eax
	cmp eax, INVALID_HANDLE_VALUE
	je loader_open_error
	
	invoke GetFileSize, [hLoaderFile], NULL
	mov [dwLoaderSize], eax
	; read the whole RWG file into the memory	
	invoke VirtualAlloc, NULL, eax, MEM_COMMIT, PAGE_READWRITE
	mov [pLoaderAddr], eax
	invoke ReadFile, [hLoaderFile], eax, [dwLoaderSize], addr dwBytesRorW, NULL
	
	invoke CloseHandle, [hLoaderFile]
	mov [hLoaderFile], INVALID_HANDLE_VALUE
	
	mov eax, [dwBytesRorW]
	sub eax, [dwLoaderSize]
	jnz rwg_read_error
	
	; detecting a valid PE File
	mov edi, [pLoaderAddr]
	assume edi: ptr IMAGE_DOS_HEADER
	mov ax, [edi].e_magic
	cmp ax, IMAGE_DOS_SIGNATURE
	jne invalid_pe_file

	add edi, [edi].e_lfanew
	mov [pNTh], edi
	assume edi: ptr IMAGE_NT_HEADERS
	mov eax, [edi].Signature
	cmp eax, IMAGE_NT_SIGNATURE
	jne invalid_pe_file
	
	; ###############################################################
	; # find imports (CreateProcess, OpenProcess, WriteProcessMemory)
	mov eax, [edi].OptionalHeader.ImageBase
	mov [dwBaseAddr], eax

	mov eax, [edi].OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT * sizeof IMAGE_DATA_DIRECTORY].VirtualAddress
	invoke ImageRvaToVa, edi, [pLoaderAddr], eax, NULL
	mov edi, eax
	assume edi: ptr IMAGE_IMPORT_DESCRIPTOR
	.while ([edi].FirstThunk != 0)
		invoke ImageRvaToVa, [pNTh], [pLoaderAddr], [edi].Name1, NULL
		invoke lstrcmpi, addr szKernel32, eax
		or eax, eax
		jnz next_import_desc
		
		mov esi, [edi].OriginalFirstThunk
		mov ebx, [edi].FirstThunk
		or esi, esi
		jnz raw_offset
		
		mov esi, ebx
	raw_offset:
		invoke ImageRvaToVa, [pNTh], [pLoaderAddr], esi, NULL
		mov esi, eax
		.while (dword ptr [esi] != 0)
			test dword ptr [esi], IMAGE_ORDINAL_FLAG32
			jnz import_by_ordinal
			
			invoke ImageRvaToVa, [pNTh], [pLoaderAddr], dword ptr [esi], NULL
			assume eax: ptr IMAGE_IMPORT_BY_NAME
			lea eax, [eax].Name1
			mov [pAPI], eax 
			invoke lstrcmp, addr szCreateProcess, [pAPI]
			or eax, eax
			jnz next_api_opr
			
			mov [pCP], ebx
			inc [dwAPI]
			jmp check_if_done
			
		next_api_opr:
			invoke lstrcmp, addr szOpenProcess, [pAPI]
			or eax, eax
			jnz next_api_wpm
			
			mov [pOPr], ebx
			inc [dwAPI]
			jmp check_if_done
		
		next_api_wpm:
			invoke lstrcmp, addr szWritePrMem, [pAPI]
			or eax, eax
			jnz check_if_done
			
			mov [pWPM], ebx
			inc [dwAPI]
			
		check_if_done:
			cmp [dwAPI], NUMBER_OF_API
			je api_found
			
		import_by_ordinal:
		next_thunk:
			add esi, sizeof IMAGE_THUNK_DATA
			add ebx, sizeof IMAGE_THUNK_DATA
		.endw
		
	next_import_desc:
		add edi, sizeof IMAGE_IMPORT_DESCRIPTOR
	.endw

api_found:
	cmp [pCP], 0
	jz debug_error
	
	cmp [pOPr], 0
	jz debug_error
	
	cmp [pWPM], 0
	jz debug_error
	
	invoke VirtualFree, [pLoaderAddr], 0, MEM_RELEASE	
	mov [pLoaderAddr], 0
	
	mov eax, [dwBaseAddr]
	add [pCP], eax
	add [pOPr], eax
	add [pWPM], eax
	
	
	; ###########################
	; # create process - debuggee
	invoke GetStartupInfo, addr sinfo
	invoke CreateProcess, addr szFile, NULL, NULL, NULL, FALSE, DEBUG_PROCESS + DEBUG_ONLY_THIS_PROCESS, NULL, NULL, addr sinfo, addr pi
	or eax, eax
	jz createproc_error

	.while (TRUE)
		invoke WaitForDebugEvent, addr de, INFINITE
		
		mov [ContinueStatus], DBG_EXCEPTION_NOT_HANDLED
		
		; case EXCEPTION_DEBUG_EVENT:
		.if (de.dwDebugEventCode == EXCEPTION_DEBUG_EVENT)
			; case EXCEPTION_BREAKPOINT
			.if (de.u.Exception.pExceptionRecord.ExceptionCode == EXCEPTION_BREAKPOINT)
				.if (!fe)
					inc [fe]
					
					invoke ReadProcessMemory, [pi.hProcess], [pCP], addr pCP, sizeof pCP, NULL
					invoke ReadProcessMemory, [pi.hProcess], [pOPr], addr pOPr, sizeof pOPr, NULL
					invoke ReadProcessMemory, [pi.hProcess], [pWPM], addr pWPM, sizeof pWPM, NULL
					
					; save opcode (CreateProcess)
					invoke ReadProcessMemory, [pi.hProcess], [pCP], addr original, sizeof original, NULL
					or eax, eax
					jz read_error
					; placing the first breakpoint (CreateProcess)
					invoke WriteProcessMemory, [pi.hProcess], [pCP], addr breakpoint, sizeof breakpoint, NULL
					or eax, eax
					jz write_error
					
					mov eax, [pCP]
					mov [pBPAddr], eax
				.endif
				
				mov eax, [pBPAddr]
				.if (de.u.Exception.pExceptionRecord.ExceptionAddress == eax)
					
					; decrement eip
					mov ct.ContextFlags, CONTEXT_CONTROL
					invoke GetThreadContext, [pi.hThread], addr ct
					dec ct.regEip
					invoke SetThreadContext, [pi.hThread], addr ct
					
					; restore the original opcode (CreateProcess)
					invoke WriteProcessMemory, [pi.hProcess], [pBPAddr], addr original, sizeof original, NULL
					or eax, eax
					jz write_error
					
					
					mov eax, [pBPAddr]
					.if (eax == [pCP])
						; get the RWG file name
						mov eax, [ct.regEsp]
						add eax, 4				; 1. parameter (lpApplicationName)
						
						invoke ReadProcessMemory, [pi.hProcess], eax, addr dwAddr, sizeof dwAddr, NULL
						invoke ReadProcessMemory, [pi.hProcess], [dwAddr], addr buf, sizeof buf, NULL
						
						invoke lstrcpy, addr szRWGFile, addr szDir
						invoke lstrcat, addr szRWGFile, addr buf
						
						mov eax, [pOPr]
						mov [pBPAddr], eax
						
					.elseif (eax == [pOPr])
						; get ProcessId
						mov eax, [ct.regEsp]
						add eax, 12			; 3. parameter (ProcessId)
						
						invoke ReadProcessMemory, [pi.hProcess], eax, addr dwProcessId, sizeof dwProcessId, NULL
								
						mov eax, [pWPM]
						mov [pBPAddr], eax
						
					.elseif (eax == [pWPM])
						; restore the original opcode (WriteProcessMemory)
						invoke WriteProcessMemory, [pi.hProcess], [pWPM], addr original, sizeof original, NULL
						or eax, eax
						jz write_error
						
						; get base address, decrypted chain, size
						mov ebx, [ct.regEsp]
						add ebx, 8				; 2. parameter (lpBaseAddress)
						
						invoke ReadProcessMemory, [pi.hProcess], ebx, addr dwBaseAddr, sizeof dwBaseAddr, NULL
						
						add ebx, 4				; 3. parameter (lpBuffer)
						invoke ReadProcessMemory, [pi.hProcess], ebx, addr pDecrypted, sizeof pDecrypted, NULL
						
						add ebx, 4				; 4. parameter (nSize)
						invoke ReadProcessMemory, [pi.hProcess], ebx, addr dwSize, sizeof dwSize, NULL

						; save the decrypted chain
						invoke VirtualAlloc, NULL, [dwSize], MEM_COMMIT, PAGE_READWRITE
						test eax, eax
						jz mem_alloc_error
						push eax
						
						invoke ReadProcessMemory, [pi.hProcess], [pDecrypted], eax, [dwSize], NULL
						
						pop [pDecrypted]
						
						.break					
					.endif
					
					; save opcode
					invoke ReadProcessMemory, [pi.hProcess], [pBPAddr], addr original, sizeof original, NULL
					or eax, eax
					jz read_error
					; placing breakpoint
					invoke WriteProcessMemory, [pi.hProcess], [pBPAddr], addr breakpoint, sizeof breakpoint, NULL
					or eax, eax
					jz write_error
				.endif
				
				mov [ContinueStatus], DBG_CONTINUE
			.endif
			
		; case EXIT_PROCESS_DEBUG_EVENT:
		.elseif ([de.dwDebugEventCode] == EXIT_PROCESS_DEBUG_EVENT)
			.break
		.endif
		
		invoke ContinueDebugEvent, [de.dwProcessId], [de.dwThreadId], [ContinueStatus]
	.endw
	
	
	cmp [dwProcessId], 0
	je debug_error
	
	cmp [dwBaseAddr], 0
	je debug_error
	
	cmp [pDecrypted], 0
	je debug_error

	; terminate the RWG process
	invoke OpenProcess, PROCESS_TERMINATE, 0, [dwProcessId]
	mov [hProcess], eax

	invoke TerminateProcess, [hProcess], 0
	invoke CloseHandle, [hProcess]
	mov [hProcess], 0

	; terminate the process
	invoke TerminateProcess, [pi.hProcess], 0
	
	invoke CloseHandle, [pi.hProcess]
	invoke CloseHandle, [pi.hThread]

	xor eax, eax
	mov [pi.hProcess], eax
	mov [pi.hThread], eax
	
	; #####################
	; # read encrypted file
	invoke CreateFile, addr szRWGFile, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL
	mov [hRWGFile], eax
	cmp eax, INVALID_HANDLE_VALUE
	je rwg_open_error
	
	invoke GetFileSize, [hRWGFile], NULL
	mov [dwRWGSize], eax
	; read the whole RWG file into the memory	
	invoke VirtualAlloc, NULL, eax, MEM_COMMIT, PAGE_READWRITE
	test eax, eax
	jz mem_alloc_error
	mov [pRWGAddr], eax
	invoke ReadFile, [hRWGFile], eax, [dwRWGSize], addr dwBytesRorW, NULL
	
	invoke CloseHandle, [hRWGFile]
	mov [hRWGFile], INVALID_HANDLE_VALUE
	
	mov eax, [dwBytesRorW]
	sub eax, [dwRWGSize]
	jnz rwg_read_error

	; detecting a valid PE File
	mov edi, [pRWGAddr]
	assume edi: ptr IMAGE_DOS_HEADER
	mov ax, [edi].e_magic
	cmp ax, IMAGE_DOS_SIGNATURE
	jne invalid_pe_file

	add edi, [edi].e_lfanew
	assume edi: ptr IMAGE_NT_HEADERS
	mov eax, [edi].Signature
	cmp eax, IMAGE_NT_SIGNATURE
	jne invalid_pe_file

	; get RAW offset
	mov eax, [dwBaseAddr]
	sub eax, [edi].OptionalHeader.ImageBase

	invoke ImageRvaToVa, edi, [pRWGAddr], eax, NULL
	
	; ############################
	; # put in the decrypted chain
	cld
	mov esi, [pDecrypted]			; decrypted chain
	mov edi, eax

	; optimized transfer
	mov ecx, [dwSize]
	shr ecx, 2
	rep movsd

	mov ecx, [dwSize]
	and ecx, 3
	rep movsb

	; #######################
	; # create decrypted file
	invoke lstrcat, addr szRWGFile, addr szDotExe

	invoke CreateFile, addr szRWGFile, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
	mov [hRWGFile], eax
	cmp eax, INVALID_HANDLE_VALUE
	je rwg_create_error

	invoke WriteFile, eax, [pRWGAddr], [dwRWGSize], addr dwBytesRorW, NULL
	invoke CloseHandle, [hRWGFile]
	mov [hRWGFile], INVALID_HANDLE_VALUE

	mov eax, [dwBytesRorW]
	sub eax, [dwRWGSize]
	jnz rwg_write_error

	jmp good_job


finishing:
	cmp [hProcess], 0
	je cleanup_rwg_terminated

	; terminate the RWG process
	invoke TerminateProcess, [hProcess], 0
	invoke CloseHandle, [hProcess]

align 4
cleanup_rwg_terminated:
	cmp [pi.hProcess], 0
	je cleanup_terminated

	; it would be better to prove this by calling WaitForSingleObject
	invoke TerminateProcess, [pi.hProcess], 0

	invoke CloseHandle, [pi.hProcess]
	invoke CloseHandle, [pi.hThread]

align 4
cleanup_terminated:
	cmp [pLoaderAddr], 0
	je cleanup_loader_chain_released
	invoke VirtualFree, [pLoaderAddr], 0, MEM_RELEASE
align 4
cleanup_loader_chain_released:
	cmp [pDecrypted], 0
	je cleanup_decrp_chain_released
	invoke VirtualFree, [pDecrypted], 0, MEM_RELEASE

align 4
cleanup_decrp_chain_released:
	cmp [pRWGAddr], 0
	je cleanup_RWG_chain_released
	invoke VirtualFree, pRWGAddr, 0, MEM_RELEASE

align 4
cleanup_RWG_chain_released:
	cmp [hLoaderFile], INVALID_HANDLE_VALUE
	je cleanup_loader_file_closed
	invoke CloseHandle, [hLoaderFile]

align 4
cleanup_loader_file_closed:
	cmp [hRWGFile], INVALID_HANDLE_VALUE
	je cleanup_file_closed
	invoke CloseHandle, [hRWGFile]

align 4
cleanup_file_closed:

align 4
exit:
	invoke ExitProcess, 0			; terminate this unwrapper


align 4
createproc_error:
	lea eax, [szMsgCreatePrEr]
	jmp show_msgbox

align 4
read_error:
	lea eax, [szMsgReadError]
	jmp show_msgbox

align 4
write_error:
	lea eax, [szMsgWriteError]
	jmp show_msgbox

align 4
debug_error:
	lea eax, [szMsgDbgError]
	jmp show_msgbox

align 4
mem_alloc_error:
    lea eax, [szMsgMemAllocEr]
    jmp show_msgbox

align 4
loader_open_error:
	lea eax, [szMsgLdrOpenEr]
	jmp show_msgbox
	
align 4
rwg_open_error:
	lea eax, [szMsgFileOpenEr]
	jmp show_msgbox

align 4
rwg_read_error:
	lea eax, [szMsgFileReadEr]
	jmp show_msgbox

align 4
invalid_pe_file:
	lea eax, [szMsgNotPEFile]
	jmp show_msgbox

align 4
rwg_create_error:
	lea eax, [szMsgFileNewEr]
	jmp show_msgbox

align 4
rwg_write_error:
	lea eax, [szMsgFileWritEr]
	jmp show_msgbox

align 4
good_job:
	lea eax, [szMsgSuccess]
	push MB_OK
	jmp here

align 4
show_msgbox:
	push MB_ICONEXCLAMATION

align 4
here:
	push offset szMsgTitle
	push eax						; displayed message
	push NULL
	call MessageBox

	jmp finishing

end start
