/*
 * Decompiled with CFR 0.152.
 */
package FlashReader;

import FlashReader.SwfReader;
import FlashReader.SwfTools;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

public class Headers
extends SwfTools {
    private HashMap<String, ArrayList<Integer>> headers;
    private SwfReader swf;

    public Headers(SwfReader swf) {
        this.swf = swf;
    }

    public HashMap<String, ArrayList<Integer>> getSwfHeader(ByteBuffer bbuf) {
        bbuf.rewind();
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        this.headers = new HashMap();
        this.headers.put("SWF", Headers.array(bbuf.position(), bbuf.getShort()));
        bbuf.position(3);
        this.headers.put("Wersja", Headers.array(bbuf.position(), bbuf.get()));
        this.headers.put("Rozmiar", Headers.array(bbuf.position(), Headers.unsignedInt(bbuf.getInt())));
        int nbitInt = Headers.readUBits(5, bbuf);
        int potrzebnychNbit = nbitInt * 4 + 5;
        potrzebnychNbit = 8 - potrzebnychNbit % 8 + potrzebnychNbit;
        bbuf.position(bbuf.position() - 1);
        String wymiary = "";
        int i = 0;
        while (i < potrzebnychNbit / 8) {
            byte b = bbuf.get();
            int unb = Headers.unsignedByte(b);
            String tmp = Integer.toBinaryString(unb);
            int l = 8 - tmp.length();
            if (tmp.length() < 8) {
                int ii = 0;
                while (ii < l) {
                    tmp = "0" + tmp;
                    ++ii;
                }
            }
            wymiary = String.valueOf(wymiary) + tmp;
            ++i;
        }
        wymiary = wymiary.substring(5);
        String xMin = wymiary.substring(0, nbitInt);
        String xMax = wymiary.substring(nbitInt, nbitInt * 2);
        String yMin = wymiary.substring(nbitInt * 2, nbitInt * 3);
        String yMax = wymiary.substring(nbitInt * 3, nbitInt * 4);
        int xMinInt = 0;
        int xMaxInt = 0;
        int yMinInt = 0;
        int yMaxInt = 0;
        try {
            xMinInt = Integer.parseInt(xMin, 2);
            xMaxInt = Integer.parseInt(xMax, 2);
            yMinInt = Integer.parseInt(yMin, 2);
            yMaxInt = Integer.parseInt(yMax, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.headers.put("xMin", Headers.array(bbuf.position(), xMinInt));
        this.headers.put("xMax", Headers.array(bbuf.position(), xMaxInt));
        this.headers.put("yMin", Headers.array(bbuf.position(), yMinInt));
        this.headers.put("yMax", Headers.array(bbuf.position(), yMaxInt));
        short frameRate = bbuf.getShort();
        frameRate = Short.reverseBytes(frameRate);
        this.headers.put("FrameRate", Headers.array(bbuf.position(), Headers.unsignedShort(frameRate)));
        short frameCount = bbuf.getShort();
        frameRate = Short.reverseBytes(frameCount);
        this.headers.put("FrameCount", Headers.array(bbuf.position() - 2, Headers.unsignedShort(frameCount)));
        return this.headers;
    }

    public String getWersja() {
        return "" + this.headers.get("Wersja").get(1);
    }

    public String getRozmiar() {
        return "" + this.headers.get("Rozmiar").get(1);
    }

    public String getxMin() {
        return "" + this.headers.get("xMin").get(1);
    }

    public String getxMax() {
        return "" + this.headers.get("xMax").get(1);
    }

    public String getyMin() {
        return "" + this.headers.get("yMin").get(1);
    }

    public String getyMax() {
        return "" + this.headers.get("yMax").get(1);
    }

    public String getFrameRate() {
        return "" + this.headers.get("FrameRate").get(1);
    }

    public String getFrameCount() {
        return "" + this.headers.get("FrameCount").get(1);
    }

    public HashMap<String, ArrayList<Integer>> getHeaders() {
        return this.headers;
    }
}

