/*
 * Decompiled with CFR 0.152.
 */
package FlashReader;

import FlashReader.ClassInfo;
import FlashReader.CpoolInfo;
import FlashReader.ExceptionInfo;
import FlashReader.Headers;
import FlashReader.InstanceInfo;
import FlashReader.MetadataInfo;
import FlashReader.MethodBodyInfo;
import FlashReader.MethodInfo;
import FlashReader.OptionInfo;
import FlashReader.ScriptInfo;
import FlashReader.SwfTools;
import FlashReader.TraitInfo;
import GUI.GUIswfReader;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class SwfReader
extends SwfTools {
    public Statusy status = Statusy.NIE_MA_PLIKU;
    public GUIswfReader gui;
    private HashMap<String, String> tags = new HashMap();
    public ByteBuffer bbuf;
    public ByteBuffer bbuf_copy;
    private ArrayList<HashMap<String, Integer>> tagi;
    public ArrayList<HashMap<String, Integer>> doABC;
    public CpoolInfo cpoolInfo;
    public ClassInfo classInfo;
    private ExceptionInfo exceptionInfo;
    public InstanceInfo instanceInfo;
    private MetadataInfo metadataInfo;
    public MethodBodyInfo methodBodyInfo;
    private MethodInfo methodInfo;
    private OptionInfo optionInfo;
    private ScriptInfo scriptInfo;
    public Headers headers;
    public TraitInfo traitInfo;
    public static ResourceBundle msgs;

    private void putTags() {
        String[] tags = new String[]{"End", "ShowFrame", "DefineShape", "", "PlaceObject", "RemoveObject", "DefineBits", "DefineButton", "JPEGTables", "SetBackgroundColor", "DefineFont", "DefineText", "DoAction", "DefineFontInfo", "DefineSound", "StartSound", "", "DefineButtonSound", "SoundStreamHead", "SoundStreamBlock", "DefineBitsLossless", "DefineBitsJPEG2", "DefineShape2", "DefineButtonCxform", "Protect", "", "PlaceObject2", "", "RemoveObject2", "", "", "", "DefineShape3", "DefineText2", "DefineButton2", "DefineBitsJPEG3", "DefineBitsLossless2", "DefineEditText", "", "DefineSprite", "", "", "", "FrameLabel", "", "SoundStreamHead2", "DefineMorphShape", "", "DefineFont2", "", "", "", "", "", "", "", "ExportAssets", "ImportAssets", "EnableDebugger", "DoInitAction", "DefineVideoStream", "VideoFrame", "DefineFontInfo2", "", "EnableDebugger2", "ScriptLimits", "SetTabIndex", "", "", "FileAttributes", "PlaceObject3", "ImportAssets2", "", "DefineFontAlignZones", "CSMTextSettings", "DefineFont3", "SymbolClass", "Metadata", "DefineScalingGrid", "", "", "", "DoABC", "DefineShape4", "DefineMorphShape2", "", "DefineSceneAndFrameLabelData", "DefineBinaryData", "DefineFontName", "StartSound2"};
        int iter = tags.length;
        int i = 0;
        while (i < iter) {
            if (!tags[i].equals("")) {
                this.tags.put("" + i, tags[i]);
            }
            ++i;
        }
    }

    public String getTag(int tag) {
        return this.tags.get("" + tag);
    }

    public SwfReader() {
        this.putTags();
        Locale defLoc = Locale.getDefault();
        msgs = ResourceBundle.getBundle("Language", defLoc);
    }

    public int[] czytajTag(ByteBuffer bbuf, int position) {
        bbuf.position(position);
        byte b1 = bbuf.get();
        byte b2 = bbuf.get();
        String bs1 = Integer.toBinaryString(SwfReader.unsignedByte(b1));
        String bs2 = Integer.toBinaryString(SwfReader.unsignedByte(b2));
        String bs = "";
        int bs1l = 8 - bs1.length();
        int i = 0;
        while (i < bs1l) {
            bs1 = "0" + bs1;
            ++i;
        }
        int bs2l = 8 - bs2.length();
        int i2 = 0;
        while (i2 < bs2l) {
            bs2 = "0" + bs2;
            ++i2;
        }
        bs = String.valueOf(bs2) + bs1;
        int tag = Integer.parseInt(bs.substring(0, 10), 2);
        int rozmiar = Integer.parseInt(bs.substring(10, bs.length()), 2);
        if (rozmiar >= 63) {
            rozmiar = SwfReader.unsignedInt(bbuf.getInt());
        }
        int[] codeAndLength = new int[]{tag, rozmiar};
        return codeAndLength;
    }

    public void zapiszSWF(File file, int level) {
        try {
            FileOutputStream f = new FileOutputStream(file);
            DataOutputStream out = new DataOutputStream(f);
            if (level != 0) {
                byte[] tmp = Arrays.copyOfRange(this.bbuf.array(), 0, 8);
                tmp[0] = 67;
                out.write(tmp);
                byte[] tmp2 = this.kompresuj(this.bbuf, level);
                if (tmp2 != null) {
                    out.write(this.kompresuj(this.bbuf, level));
                }
            } else {
                out.write(this.bbuf.array());
            }
            this.gui.showInfo(msgs.getString("Isaved"));
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void czytajSwf(File file) {
        try {
            FileInputStream f = new FileInputStream(file);
            DataInputStream in = new DataInputStream(f);
            this.bbuf = ByteBuffer.allocate(in.available());
            this.bbuf.order(ByteOrder.LITTLE_ENDIAN);
            byte[] b = new byte[in.available()];
            in.readFully(b);
            this.bbuf.put(b);
            in.close();
            this.bbuf.rewind();
            this.bbuf_copy = ByteBuffer.allocate(this.bbuf.capacity());
            this.bbuf_copy.order(ByteOrder.LITTLE_ENDIAN);
            this.bbuf_copy.put(this.bbuf);
            this.headers();
        }
        catch (FileNotFoundException e) {
            System.err.println("Brak pliku");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void kopiujBufor() {
        this.bbuf = this.bbuf_copy;
        this.bbuf_copy.position(0);
        this.bbuf.position(0);
        this.bbuf_copy = ByteBuffer.allocate(this.bbuf.capacity());
        this.bbuf_copy.put(this.bbuf);
        this.bbuf_copy.position(0);
        this.bbuf.position(0);
    }

    public String getDoABC(int poz) {
        this.doABC(this.getBbuf(), poz);
        return "" + this.cpoolInfo + this.methodInfo + this.metadataInfo + this.instanceInfo + this.classInfo + this.scriptInfo + this.methodBodyInfo;
    }

    public void doABC(ByteBuffer bbuf, int position) {
        bbuf.position(position);
        this.czytajTag(bbuf, position);
        int kDoAbcLazyInitializeFlag = Integer.parseInt(Integer.toBinaryString(bbuf.getInt()), 2);
        char c = '\u0000';
        String name = "";
        while ((c = (char)bbuf.get()) != '\u0000') {
            name = String.valueOf(name) + c;
        }
        int minor_version = SwfReader.unsignedShort(bbuf.getShort());
        int major_version = SwfReader.unsignedShort(bbuf.getShort());
        this.cpoolInfo = new CpoolInfo(this);
        this.cpoolInfo.cpool_info(bbuf, bbuf.position());
        OptionInfo optionInfo = new OptionInfo();
        this.methodInfo = new MethodInfo(this, this.cpoolInfo, optionInfo);
        this.methodInfo.method_info(bbuf, bbuf.position());
        this.metadataInfo = new MetadataInfo(this, this.cpoolInfo);
        this.metadataInfo.metadata_info(bbuf, bbuf.position());
        this.traitInfo = new TraitInfo(this.cpoolInfo, this);
        this.instanceInfo = new InstanceInfo(this, this.cpoolInfo, this.traitInfo);
        this.instanceInfo.instance_info(bbuf, bbuf.position());
        this.classInfo = new ClassInfo(this, this.traitInfo);
        this.classInfo.class_info(bbuf, bbuf.position(), this.instanceInfo.getClass_count());
        this.scriptInfo = new ScriptInfo(this, this.traitInfo);
        this.scriptInfo.script_info(bbuf, bbuf.position());
        this.exceptionInfo = new ExceptionInfo(this);
        this.methodBodyInfo = new MethodBodyInfo(this, this.exceptionInfo, this.traitInfo);
        this.methodBodyInfo.method_body_info(bbuf, bbuf.position());
    }

    public ByteBuffer getBbuf() {
        return this.bbuf;
    }

    public String getPozostaleTagi() {
        String pozostaleTagi = "";
        this.doABC = new ArrayList();
        this.tagi = new ArrayList();
        boolean i = false;
        while (this.getBbuf().position() < this.getBbuf().capacity()) {
            HashMap<String, Integer> hm = new HashMap<String, Integer>();
            int pos = this.getBbuf().position();
            int[] tab = this.czytajTag(this.getBbuf(), this.getBbuf().position());
            String tag = this.getTag(tab[0]);
            if (tag == null) {
                tag = msgs.getString("undefinedTag");
            }
            hm.put("" + tab[0], pos);
            this.tagi.add(hm);
            if (("" + tab[0]).contains("82")) {
                this.doABC.add(hm);
            }
            pozostaleTagi = String.valueOf(pozostaleTagi) + "\nTag: " + tab[0] + ", " + tag + ", " + msgs.getString("length") + ": " + tab[1] + ", " + msgs.getString("position") + ": " + pos;
            this.getBbuf().position(this.getBbuf().position() + tab[1]);
        }
        this.gui.setComboBox(this.doABC);
        return pozostaleTagi;
    }

    public void setGui(GUIswfReader gui) {
        this.gui = gui;
    }

    public static void main(String[] args) {
        SwfReader swf = new SwfReader();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GUIswfReader window = new GUIswfReader(SwfReader.this);
                    window.getFrame().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Statusy getStatus() {
        return this.status;
    }

    public void changeDoABCsize(int poz, int size) {
        this.bbuf_copy.order(ByteOrder.LITTLE_ENDIAN);
        this.bbuf_copy.putInt(poz + 2, size);
    }

    public void changeSWFsize(int size) {
        this.bbuf_copy.order(ByteOrder.LITTLE_ENDIAN);
        int pos = this.headers.getHeaders().get("Rozmiar").get(0);
        this.bbuf_copy.putInt(pos, size);
    }

    public int removeFromByteBuffer(ByteBuffer bb, int[] poz, int[] length) {
        int size = 0;
        ByteBuffer b = bb == null ? this.bbuf_copy : bb;
        byte[] by = b.array();
        ArrayList<Byte> al = new ArrayList<Byte>();
        int i = 0;
        while (i < by.length) {
            al.add(by[i]);
            ++i;
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        toRemove.add(null);
        int i2 = 0;
        while (i2 < poz.length) {
            int i3 = 0;
            while (i3 < length[i2]) {
                al.set(poz[i2] + i3, null);
                ++size;
                ++i3;
            }
            ++i2;
        }
        al.removeAll(toRemove);
        by = new byte[al.size()];
        int i4 = 0;
        while (i4 < by.length) {
            by[i4] = (Byte)al.get(i4);
            ++i4;
        }
        if (bb == null) {
            this.bbuf_copy = ByteBuffer.wrap(by);
            this.bbuf_copy.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            bb = ByteBuffer.wrap(by);
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        return size;
    }

    public int removeAndAddToByteBuffer(Integer[] poz, Integer[] length, ArrayList<ArrayList<Byte>> dane) {
        int usuniete = 0;
        byte[] b = this.bbuf_copy.array();
        ArrayList<Byte> al = new ArrayList<Byte>();
        int i = 0;
        while (i < b.length) {
            al.add(b[i]);
            ++i;
        }
        i = 0;
        while (i < poz.length) {
            int n;
            if (dane.get(i).size() <= length[i]) {
                n = 0;
                int i2 = poz[i];
                while (i2 < poz[i] + length[i]) {
                    if (n < dane.get(i).size()) {
                        al.set(i2, dane.get(i).get(n));
                    } else {
                        al.set(i2, null);
                        ++usuniete;
                    }
                    ++n;
                    ++i2;
                }
            } else {
                n = 0;
                int dodalem = 0;
                int i2 = poz[i];
                while (i2 < poz[i] + dane.get(i).size()) {
                    if (n < dane.get(i).size() && n < length[i]) {
                        al.set(i2, dane.get(i).get(n));
                    } else if (n >= length[i]) {
                        al.add(i2, dane.get(i).get(n));
                        ++dodalem;
                        --usuniete;
                    }
                    ++n;
                    ++i2;
                }
                int i3 = i + 1;
                while (i3 < poz.length) {
                    int n2 = i3++;
                    poz[n2] = poz[n2] + dodalem;
                }
            }
            ++i;
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        toRemove.add(null);
        al.removeAll(toRemove);
        b = new byte[al.size()];
        int i2 = 0;
        while (i2 < b.length) {
            b[i2] = (Byte)al.get(i2);
            ++i2;
        }
        this.bbuf_copy = ByteBuffer.wrap(b);
        return usuniete;
    }

    public Headers headers() {
        this.headers = new Headers(this);
        this.headers.getSwfHeader(this.bbuf);
        return this.headers;
    }

    public byte[] kompresuj(ByteBuffer bbuf, int level) {
        byte[] output = new byte[bbuf.capacity()];
        Deflater compresser = new Deflater(level);
        byte[] doKompresji = Arrays.copyOfRange(bbuf.array(), 8, bbuf.capacity());
        if (bbuf.array()[0] == 70) {
            compresser.setInput(doKompresji);
            compresser.finish();
            int compressedDataLength = compresser.deflate(output);
            return Arrays.copyOf(output, compressedDataLength);
        }
        this.gui.showError(msgs.getString("Wcompress"));
        return null;
    }

    public void dekompresuj() {
        if (this.bbuf.array()[0] == 67) {
            Inflater decompresser = new Inflater();
            int size = this.headers.getHeaders().get("Rozmiar").get(1);
            decompresser.setInput(this.bbuf.array(), 8, this.bbuf.capacity() - 8);
            byte[] result = new byte[size - 8];
            try {
                int resultLength = decompresser.inflate(result);
            }
            catch (DataFormatException e1) {
                e1.printStackTrace();
            }
            decompresser.end();
            byte[] headers = new byte[8];
            this.bbuf.position(0);
            this.bbuf.get(headers, 0, 8);
            headers[0] = 70;
            headers[1] = 87;
            headers[2] = 83;
            this.bbuf = ByteBuffer.allocate(size);
            this.bbuf.order(ByteOrder.LITTLE_ENDIAN);
            this.bbuf_copy = ByteBuffer.allocate(this.bbuf.capacity());
            this.bbuf_copy.order(ByteOrder.LITTLE_ENDIAN);
            this.bbuf.rewind();
            this.bbuf.put(headers);
            this.bbuf.put(result);
            this.bbuf_copy.rewind();
            this.bbuf_copy = ByteBuffer.wrap(this.bbuf.array());
            this.gui.showInfo(msgs.getString("decompressed"));
        } else {
            this.gui.showError(msgs.getString("Wdecompressed"));
        }
    }

    public static enum Statusy {
        JEST_PLIK_I_DANE,
        JEST_PLIK,
        NIE_MA_PLIKU;

    }
}

