#include <idc.idc>

static rotargv() 
{
auto argv1;

auto argv;
auto argc;
	argv = DbgDword(esp + 0x0C);
	argc = DbgDword(esp + 0x08);
	Message("argc = %d, argv = %a\n",argc, argv);	
	argv1 = DbgDword(argv + (argc - 1)*4);
	Message("last arg: %s\n", GetString(argv1, -1, ASCSTR_C));
auto i;

auto arg;
	for (i = argc - 2; i >= 1; i--) 
	{
		arg = DbgDword(argv + 4*i);
		Message("%a\n",arg);
		
		PatchDword(argv + (i+1)*4, arg);
		
	}

	PatchDword(argv + 4, argv1);

	return 0;
}

static call_qqq() 
{
auto ptr;
	ptr = LocByName("perl_call_pv");
	if (ptr == -1) 
		ptr = LocByName("Perl_call_pv");
	if (ptr == -1) {
		Message("ERROR getting perl_call_pv address\n");
		return -1;
	}
	Message("perl_call_pv is at: %a\n", ptr);

auto esp_save;
auto ebp_save;
	esp_save = esp;
	ebp_save = ebp;

auto pctx;
	pctx = DbgDword(esp);

	esp = esp - 4;
	PatchDword(esp, eip);
	esp = esp - 4;
	PatchDword(esp, ebp);
	ebp = esp; /* 4 for return addr */

	// emulated call frame; see dSP PUSHMARK preceding normal perl_call_pv call

auto fn;
	fn = "qqq";
auto ch;

	esp = esp - 4;

auto str_ptr;
	str_ptr = esp;
	
	ch = 'q';
	PatchDbgByte(esp + 0, ch);
	PatchDbgByte(esp + 1, ch);
	PatchDbgByte(esp + 2, ch);
	PatchDbgByte(esp + 3, 0);




	esp = esp - 4;
	PatchDword(esp, 0x0A);	

	esp = esp - 4;
	PatchDword(esp, str_ptr);

	esp = esp - 4;
	PatchDword(esp, pctx);

	esp = esp - 4;
	PatchDword(esp, eip);

auto eip_save;
	eip_save = eip;
	eip = ptr;

	RunTo(eip_save);
	if (GetDebuggerEvent(WFNE_SUSP, 20) != BREAKPOINT) {
		Message("Error running to %a\n",eip_save);
		return -1;
	}
	esp = esp_save;
	ebp = ebp_save;

	return 0;
}

static main()
{
auto pp;
	pp = LocByName(".perl_parse");
	if (pp == BADADDR) {
		Message("ERROR: could not find perl_parse\n");
		return -1;
	}
	
auto ppcallea;
	ppcallea = RfirstB(pp);
	if (ppcallea == BADADDR) {
		Jump(pp);
		Message("ERROR: could not find reference to perl_parse\n");	
		return -1;
	}

	if (RnextB(pp, ppcallea) != BADADDR) {
		Message("ERROR: more than 1 reference to perl_parse\n");	
		return -1;
	}
	
	Jump(ppcallea);

auto pr;
	pr = LocByName(".perl_run");
	if (pr == BADADDR) {
		Message("ERROR: could not find perl_run\n");
		return -1;
	}
	
auto prcallea;
	prcallea = RfirstB(pr);
	if (prcallea == BADADDR) {
		Jump(pr);
		Message("ERROR: could not find reference to perl_run\n");	
		return -1;
	}

	if (RnextB(pr, prcallea) != BADADDR) {
		Message("ERROR: more than 1 reference to perl_run\n");	
		return -1;
	}


	RunTo(ppcallea);

	if (GetDebuggerEvent(WFNE_SUSP, 20) != BREAKPOINT) {
		Message("Error running to %a\n", ppcallea);
		return -1;
	}

	if (rotargv() != 0)
		return -1;


	RunTo(prcallea);
	if (GetDebuggerEvent(WFNE_SUSP, 20) != BREAKPOINT) {
		Message("Error running to %a\n", prcallea);
		return -1;
	}

	if (call_qqq() != 0)
		return -1;

	//StopDebugger();
	return 0;	
}