#! /bin/bash

#CALL_PV_REAL_NAME=perl_call_pv
CALL_PV_REAL_NAME=Perl_call_pv
#depending on perl version this name may be different, e. g. Perl_call_pv or perl_call_pv


if [ $# -ne 1 ] ;
then
	echo 'Usage: decomp.sh <program>'
	exit -1
fi


exetype=`readelf -h $1 | awk '/Class: (.*)/{print $2}'`

# Use ltrace to find addresses from where perl_parse and perl_run are called
# If something goes wrong in getting these addresses, one should examine "ltrace -i <program>" output 
str=`ltrace -i $1 2>&1 | egrep -i 'perl_parse\(|perl_run\(' | awk '{ l = length($1); print substr($1,2,l-2)}'`

i=0
for addr in $str
do
	i=$(( $i+1 ))
	a[$i]=$(( $addr-5 ))
#	echo $i:$addr
done

if [ $i -ne 2 ]
then
	echo "Error getting break addresses (run \"ltrace -i $1\" to see what's happening)"
	exit -1
fi

echo ${a[1]}
echo ${a[2]}

echo "break *"${a[1]}>gdb.cmds
echo 'run' >>gdb.cmds
echo 'x/i $pc'>>gdb.cmds

echo \"$exetype\"

if [ "$exetype" == "ELF64" ] ;
then
	
	echo 'set $a={long}$rcx@5' >>gdb.cmds
else
	echo 'set $a={char*}({void*}($esp+0xC))@5' >>gdb.cmds
fi
echo 'set $tmp=$a[4]' >>gdb.cmds
echo 'set $a[4]=$a[3]' >>gdb.cmds
echo 'set $a[3]=$a[2]' >>gdb.cmds
echo 'set $a[2]=$a[1]' >>gdb.cmds
echo 'set $a[1]=$tmp' >>gdb.cmds
echo "until *"${a[2]}>>gdb.cmds
echo 'x/i $pc'>>gdb.cmds

#gdb --command=gdb.cmds --args $1 -mqq 
#exit

if [ "$exetype" == "ELF64" ] ;
then
echo 'set $rsp=$rsp-8' >>gdb.cmds
echo 'set *(long*)$rsp=$pc' >>gdb.cmds
echo 'set $rsp=$rsp-8' >>gdb.cmds
echo 'set $rbp_save=$rbp' >>gdb.cmds
echo 'set $rbp=$rsp' >>gdb.cmds
echo 'frame 0' >>gdb.cmds
echo 'frame' >>gdb.cmds
echo 'set *(long*)$rsp=$rbp_save' >>gdb.cmds
echo 'frame' >>gdb.cmds
echo 'p $rsp' >>gdb.cmds
echo 'p $rbp' >>gdb.cmds
echo 'set $rsi=0x0A' >>gdb.cmds
echo 'set $rdi="qqq"' >>gdb.cmds
echo 'set $rip_save=$pc' >>gdb.cmds
echo 'set $rsp=$rsp-8' >>gdb.cmds
echo 'set *(long*)$rsp=$rip_save' >>gdb.cmds
echo 'set $pc='$CALL_PV_REAL_NAME >>gdb.cmds
echo 'until *$rip_save' >>gdb.cmds
echo 'kill' >>gdb.cmds
echo 'quit' >>gdb.cmds
else
	echo 'set $pctx=*(long*)$esp' >>gdb.cmds
	echo 'set $esp = $esp - 4' >>gdb.cmds
	echo 'set *(long*)$esp = $pc' >>gdb.cmds
	echo 'set $esp = $esp - 4' >>gdb.cmds
	echo 'set *(long*)$esp = $ebp' >>gdb.cmds
	echo 'set $ebp=$esp' >>gdb.cmds
	echo 'frame 0' >>gdb.cmds
	
	echo 'set $esp = $esp - 4' >>gdb.cmds
	echo 'set *(long*)$esp=0x0A' >>gdb.cmds

	echo 'set $esp = $esp - 4' >>gdb.cmds
	echo 'set *(long*)$esp="qqq"' >>gdb.cmds

	echo 'set $esp = $esp - 4' >>gdb.cmds
	echo 'set *(long*)$esp=$pctx' >>gdb.cmds
	
	echo 'set $esp = $esp - 4' >>gdb.cmds
	echo 'set *(long*)$esp=$pc' >>gdb.cmds

	echo 'set $eip_save = $eip' >>gdb.cmds

	echo 'set $pc='$CALL_PV_REAL_NAME >>gdb.cmds
	echo 'until *$eip_save' >>gdb.cmds
	echo 'kill' >>gdb.cmds
	echo 'quit' >>gdb.cmds

fi

gdb --command=gdb.cmds --args $1 -mqq 

