// ==========================================================
// ** SecMaker - Version 2 **

// Have fun with the source... although I was too lazy to comment it

// E-Mail: Lighten-Sunrise@gmx.de
// WEB : www.sunshine2k.de || www.sunshine.2kx.de
// Sunshine, February 2k4
// ==========================================================


#include <windows.h>
#include <commctrl.h>
#include "resource.h"


#define WIN32_LEAN_AND_MEAN


HINSTANCE		hInst;
char			filename[MAX_PATH];
LPSTR			filterstring = "EXE Files (*.exe)\0*.exe\0All Files (*.*)\0*.*\0\0";
char			secname[8];
DWORD			secsize;
DWORD			characteristic;
HWND			MainWinHwnd;
DWORD			oldcharac;
// global var to make sure that characteristics window is opened once
BOOL			CharacWinVisible = FALSE;



POINT ArrayPoints[] =
{
	5,15,
	5,250,
	10,255,
	320,255,
	325,250,
	325,15,
	320,10,
	10,10,
	5,15
};


POINT RgnPtsCharacDlg[] =
{
	5,15,
	5,280,
	160,280,
	180,300,
	275,300,
	275,190,
	240,155,
	240,15,
	5,15
};


POINT ArrayPointsLine[] =
{
	60,35,
	240,35
};


int isHex(char c)
{
   return ( ((c>='0') && (c<='9')) || ((c>='A') && (c<='F')) || 
            ((c>='a') && (c<='f')) ) ? 1 : 0;
}

int HextoDec(char* str)
{
	int temp, result,len;

	temp = 1;
	result = 0;
	str = CharUpper(str);
	len = lstrlen(str);

	for (int i=0;i<len;i++)
	{
		if ((str[len-1-i] >= '0') & (str[len-1-i] <= '9'))
		{
			result = result + ((str[len-1-i] - '0') * temp);
		}

        if ((str[len-1-i] >= 'A') & (str[len-1-i] <= 'F')) 
		{
			result = result + ((str[len-1-i] - 'A' + 10) * temp);
		}

		temp = temp * 16;

	}

	return result;
}


//** Main function
int AddSection(HWND hwnd)
{
	HANDLE					hFile, hFileMap;
	LPVOID					pMap;
	PIMAGE_DOS_HEADER		pDosh;
	PIMAGE_NT_HEADERS		pPeh;
	PIMAGE_SECTION_HEADER	pSech;
	DWORD					elfanew;
	DWORD					ImageSize;
	// infos from last section
	DWORD			FirstSec_RawOff;
	DWORD			LastSec_RawOff;
	DWORD			LastSec_RawSize;
	DWORD			LastSec_VirOff;
	
	// values for new section
	DWORD			NewVirSize; // virtual size of new section
	DWORD			NewRawSize;
	DWORD			NewVirOff;
	DWORD			NewRawOff;

	DWORD ImageBase;
	int Section_Count;
	DWORD Section_Align;
	DWORD File_Align;


	hFile = CreateFile(filename,GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
			               NULL,OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,0);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		MessageBox(hwnd,"File not opened","Error",MB_ICONSTOP);
		return 0;
	}

	hFileMap = CreateFileMapping(hFile,NULL,PAGE_READWRITE,0,0,0);
	if (hFileMap == NULL)
	{
		MessageBox(hwnd,"Not able to create filemapping","Error",MB_ICONSTOP);
		CloseHandle(hFile);
		return 0;
	}		

    pMap = MapViewOfFile(hFileMap,FILE_MAP_ALL_ACCESS,0,0,0);
	if (pMap == NULL)
	{
		MessageBox(hwnd,"Error while mapping file!","Error",MB_ICONSTOP);
		CloseHandle(hFileMap);
		CloseHandle(hFile);
		return 0;
	}

	DWORD filesize = GetFileSize(hFile,NULL);

	pDosh = (PIMAGE_DOS_HEADER)pMap;
	pPeh = (PIMAGE_NT_HEADERS)((DWORD)pMap + pDosh->e_lfanew);
	if (pPeh->Signature != 0x4550)
	{
		MessageBox(hwnd,"It's NOT a PE File!", "Aborting", MB_ICONSTOP);
		return 0;
	}

	// Get overall infos
	elfanew = pDosh->e_lfanew;
	ImageBase = pPeh->OptionalHeader.ImageBase;
	Section_Count = pPeh->FileHeader.NumberOfSections;
	Section_Align = pPeh->OptionalHeader.SectionAlignment;
	File_Align = pPeh->OptionalHeader.FileAlignment;
	ImageSize = pPeh->OptionalHeader.SizeOfImage;

	// Get Raw Offset of first section
	pSech = (PIMAGE_SECTION_HEADER)((DWORD)pPeh + (DWORD)sizeof(IMAGE_NT_HEADERS));
	FirstSec_RawOff = pSech->PointerToRawData;

	// Get infos from last section
	pSech = PIMAGE_SECTION_HEADER((DWORD)pSech + ( (Section_Count-1) * (DWORD)sizeof(IMAGE_SECTION_HEADER)));
	LastSec_RawOff = pSech->PointerToRawData;
	LastSec_RawSize = pSech->SizeOfRawData;
	LastSec_VirOff = pSech->VirtualAddress;

	// Ok enough infos... unmap file
	UnmapViewOfFile(pMap);
	CloseHandle(hFileMap);

	// -- Now really start adding section --
	// Check space between PE Header and first section
	if ( FirstSec_RawOff - (elfanew + 0xF8 + 40 * Section_Count) < 40 )
	{
		MessageBox(hwnd, "No enough free space in the PE Header to add informations about a new section!", "Error", MB_ICONSTOP);
		CloseHandle(hFile);
		return 0;
	}


	if (SetFilePointer(hFile,(elfanew + 0xF8 + 40 * Section_Count), NULL, FILE_BEGIN) == 0xFFFFFFFF)
	{
		MessageBox(hwnd, "Not able to set filepointer!", "Aborting...", MB_ICONSTOP);
		CloseHandle(hFile);
		return 0;
	}

	DWORD bw, dwtempvar;
	WriteFile(hFile,(LPCVOID)(secname),8,&bw,NULL); // section name

	// calculate virtual size (take care of section alignment)
	dwtempvar = secsize;
	if (dwtempvar <= Section_Align)
		dwtempvar = Section_Align;
	else
		dwtempvar = ((dwtempvar / Section_Align) + 1) * Section_Align;
	
	WriteFile(hFile,(LPCVOID)&dwtempvar,4,&bw,NULL); // virtual size
	NewVirSize = dwtempvar;

	// Virtual Offset
	if (LastSec_RawSize < Section_Align)
		dwtempvar = LastSec_VirOff + Section_Align; 
	else
		if ((LastSec_RawSize % Section_Align) == 0)
		  dwtempvar = (((LastSec_RawSize / Section_Align)) * Section_Align) + LastSec_VirOff; else
		  dwtempvar = (((LastSec_RawSize / Section_Align)+1) * Section_Align) + LastSec_VirOff;	

	WriteFile(hFile,(LPCVOID)&dwtempvar,4,&bw,NULL); // virtual offset
	NewVirOff = dwtempvar;

	// calculate new raw size
	if (secsize <= File_Align)
	{
		dwtempvar = File_Align;
	}
	else
	{
		dwtempvar = (( (secsize / File_Align) +1) * File_Align);// + LastSec_VirOff; 
	}

	

	WriteFile(hFile,(LPCVOID)&dwtempvar,4,&bw,NULL); // raw size 
	NewRawSize = dwtempvar;


	// calculate Raw Offset
	if (LastSec_RawSize < File_Align)
		dwtempvar = LastSec_RawOff + File_Align; else
		dwtempvar = (((LastSec_RawSize / File_Align)) * File_Align) + LastSec_RawOff;
	//dwtempvar = LastSec
	WriteFile(hFile,(LPCVOID)&dwtempvar,4,&bw,NULL); // Raw Offset
	NewRawOff = dwtempvar;


	// Characteristics
	SetFilePointer(hFile, 0x0C, NULL, FILE_CURRENT);
	dwtempvar = characteristic;
	WriteFile(hFile,(LPCVOID)&dwtempvar,4,&bw,NULL);


	// set Number of Sections
	SetFilePointer(hFile, (elfanew + 0x06), NULL, FILE_BEGIN);
	dwtempvar = Section_Count + 1;
	WriteFile(hFile,(LPCVOID)&dwtempvar,2,&bw,NULL);

	// Set new ImageSize
	SetFilePointer(hFile, (elfanew + 0x50), NULL, FILE_BEGIN);
	dwtempvar = NewVirOff + NewVirSize;
	WriteFile(hFile,(LPCVOID)&dwtempvar,4,&bw,NULL);

	// Append new section to file
	if (SetFilePointer(hFile,LastSec_RawOff + LastSec_RawSize + NewRawSize, NULL, FILE_BEGIN) == 0xFFFFFFFF)
	{
		MessageBox(hwnd, "Not able to set filepointer!", "Aborting...", MB_ICONSTOP);
		return 0;
	}

	SetEndOfFile(hFile);

	CloseHandle(hFile);

	return 1;
	
}


BOOL AboutProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	
	switch(msg)
	{
	case WM_COMMAND:
		{
			switch(wparam)
			{
			case ID_ABOUTX:
				{
					EndDialog(hwnd,0);
				}
				break;

			default:break;

			}
		}

	case WM_CTLCOLORDLG: 
	case WM_CTLCOLORSTATIC:
		{         
			HBRUSH hb = CreateSolidBrush(RGB(255,255,255));       
			SetBkColor((HDC)wparam, RGB(255,255,255));        
			return (int)(GetStockObject(WHITE_BRUSH));
		}
		break;

		
	case WM_LBUTTONDOWN:
		{
			ReleaseCapture();  
			SendMessage(hwnd, WM_SYSCOMMAND, 0xf012, 0);	  
		}
		break;


	default:break;

	}

	return FALSE;
}




BOOL CharacProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	
	switch(msg)
	{
	case WM_CLOSE:
		{
            CharacWinVisible = FALSE;
			EndDialog(hwnd,0);
		}
		break;

	case WM_INITDIALOG:
		{
			HRGN Rgn;


			RECT rect;
			GetWindowRect(hwnd,&rect);
			MoveWindow(hwnd,rect.left + 200, rect.top, rect.right - rect.left, rect.bottom - rect.top, FALSE);
			
			//BYTE b = HIBYTE((characteristic));
			
			if ((characteristic | 0x10000000) == characteristic) // shareable
				SendMessage(GetDlgItem(hwnd,IDC_CHECK1),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x20000000) == characteristic) // executable
				SendMessage(GetDlgItem(hwnd,IDC_CHECK2),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x40000000) == characteristic) // readable
				SendMessage(GetDlgItem(hwnd,IDC_CHECK3),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x80000000) == characteristic) // writeable
				SendMessage(GetDlgItem(hwnd,IDC_CHECK4),BM_SETCHECK,BST_CHECKED,0);

			if ((characteristic | 0x01000000) == characteristic) // extended relocations
				SendMessage(GetDlgItem(hwnd,IDC_CHECK5),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x02000000) == characteristic) // can be discarded
				SendMessage(GetDlgItem(hwnd,IDC_CHECK6),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x04000000) == characteristic) // // not cachable
				SendMessage(GetDlgItem(hwnd,IDC_CHECK7),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x08000000) == characteristic) // // not pageable
				SendMessage(GetDlgItem(hwnd,IDC_CHECK8),BM_SETCHECK,BST_CHECKED,0);

			if ((characteristic | 0x00001000) == characteristic) // comdat
				SendMessage(GetDlgItem(hwnd,IDC_CHECK9),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x00000800) == characteristic) // not become part of image
				SendMessage(GetDlgItem(hwnd,IDC_CHECK10),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x04000200) == characteristic) // comments, informations
				SendMessage(GetDlgItem(hwnd,IDC_CHECK11),BM_SETCHECK,BST_CHECKED,0);

			if ((characteristic | 0x00000080) == characteristic) // uninitialized data
				SendMessage(GetDlgItem(hwnd,IDC_CHECK12),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x00000040) == characteristic) // initialized data
				SendMessage(GetDlgItem(hwnd,IDC_CHECK13),BM_SETCHECK,BST_CHECKED,0);
			if ((characteristic | 0x00000020) == characteristic) // contains code
				SendMessage(GetDlgItem(hwnd,IDC_CHECK14),BM_SETCHECK,BST_CHECKED,0);


			Rgn = CreatePolygonRgn(RgnPtsCharacDlg,8,WINDING);
			SetWindowRgn( hwnd, Rgn, FALSE );
					  
		}
		break;

	case WM_LBUTTONDOWN:
	  {
		  ReleaseCapture();
		  SendMessage(hwnd, WM_SYSCOMMAND, 0xf012, 0);
	  }
	  break;

	 case WM_CTLCOLORDLG: 
	 case WM_CTLCOLORSTATIC:
	  {
          HBRUSH hb = CreateSolidBrush(RGB(255,255,255));
          SetBkColor((HDC)wparam, RGB(255,255,255));
          return (int)(GetStockObject(WHITE_BRUSH));
	  }
	  break;

		  
	case WM_PAINT:
	  {
		  PAINTSTRUCT ps;
		  HDC hdc;

		  for (int i=0; i<=8; i++)
			{
				if (RgnPtsCharacDlg[i].x < 200)
					RgnPtsCharacDlg[i].x = RgnPtsCharacDlg[i].x -3; else
					RgnPtsCharacDlg[i].x = RgnPtsCharacDlg[i].x - 4;			  
				if (RgnPtsCharacDlg[i].y < 200)
					RgnPtsCharacDlg[i].y = RgnPtsCharacDlg[i].y -3; else
					RgnPtsCharacDlg[i].y = RgnPtsCharacDlg[i].y - 4;
			}

		  hdc = BeginPaint(hwnd, &ps);
		  HPEN hp = CreatePen(PS_SOLID,1,RGB(0,0,0));
		  SelectObject(hdc,hp);	
		  Polyline(hdc,RgnPtsCharacDlg,9);
		  DeleteObject(hp);
		  EndPaint(hwnd,&ps);

		  for (i=0; i<=8; i++)
			{
				if (RgnPtsCharacDlg[i].x < 200)
					RgnPtsCharacDlg[i].x = RgnPtsCharacDlg[i].x +3; else
					RgnPtsCharacDlg[i].x = RgnPtsCharacDlg[i].x + 4;			  
				if (RgnPtsCharacDlg[i].y < 200)
					RgnPtsCharacDlg[i].y = RgnPtsCharacDlg[i].y +3; else
					RgnPtsCharacDlg[i].y = RgnPtsCharacDlg[i].y + 4;
			}
	  }
	  break;


	case WM_COMMAND:
		{
			switch(wparam)
			{
			case ID_CLOSE:
				{
					char buf[MAX_PATH];
					characteristic = oldcharac;
					
					wsprintf(buf,"%08X",characteristic);
					SetDlgItemText(MainWinHwnd, ID_CSTATIC, buf);

					CharacWinVisible = FALSE;
				    EndDialog(hwnd,0);
				}
				break;
			
			case ID_ACCEPT:
				{
					CharacWinVisible = FALSE;
					EndDialog(hwnd,0);
				}
				break;

			
			

			default://case ID_ACCEPT:
				{
					char buf[MAX_PATH];
					characteristic = 0;
					// shareable
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK1),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x10000000;
					// executable
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK2),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x20000000;
					// readable
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK3),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x40000000;
					// writeable
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK4),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x80000000;

					// extended relocations
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK5),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x01000000;
					// can be discarded
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK6),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x02000000;
					// not cachable
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK7),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x04000000;
					// not pageable
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK8),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x08000000;


					// comdat
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK9),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x00001000;
					// not become part of image
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK10),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x00000800;
					// comments, informations
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK11),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x00000200;


					// uninitialized data
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK12),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x00000080;
					// initialized data
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK13),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x00000040;
					// contians code
					if (SendMessage(GetDlgItem(hwnd,IDC_CHECK14),BM_GETCHECK,0,0) == BST_CHECKED)
						characteristic = characteristic | 0x00000020;

					wsprintf(buf,"%08X",characteristic);
					SetDlgItemText(MainWinHwnd, ID_CSTATIC, buf);

					
				}
				break;

			//default:break;
			}
		}
		break;


	default:break;

	}

	return FALSE;
}



BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	HDC hdc;
	PAINTSTRUCT ps;

  switch(msg)
  {
  

  case WM_INITDIALOG:
	  {
		  MainWinHwnd = hwnd;
		  HRGN Rgn;
		  HBRUSH hb;
		  hb = CreateSolidBrush(RGB(0,255,0));

		  
		  Rgn = CreatePolygonRgn(ArrayPoints,8,WINDING);
		  
		   
		  SetWindowRgn( hwnd, Rgn, FALSE );
		  SetWindowText(hwnd, "SecMaker V2");
		  SetDlgItemText(hwnd, ID_CSTATIC,"E0000020");
		  for (int i=0; i<=8; i++)
		  {
			  if (ArrayPoints[i].x < 200)
				  ArrayPoints[i].x = ArrayPoints[i].x -3; else
				  ArrayPoints[i].x = ArrayPoints[i].x - 4;
			  if (ArrayPoints[i].y < 200)
				  ArrayPoints[i].y = ArrayPoints[i].y -3; else
				  ArrayPoints[i].y = ArrayPoints[i].y - 4;
		  }
		  		  
		  SendMessage(GetDlgItem(hwnd,ID_HEX), BM_SETCHECK, BST_CHECKED	,0);
		
	  }
	  break;

  case WM_PAINT:
	  {
		 
		  hdc = BeginPaint(hwnd, &ps);

		  HPEN hp = CreatePen(PS_SOLID,1,RGB(0,0,0));
		  SelectObject(hdc,hp);	
		  
		  Polyline(hdc, ArrayPoints, 9);
		  Polyline(hdc, ArrayPointsLine,2);
		  
		  DeleteObject(hp);
	
		  EndPaint(hwnd, &ps);
	  }
	  break;


  
  case WM_CTLCOLORDLG:
  case WM_CTLCOLORSTATIC:
	  {
          HBRUSH hb = CreateSolidBrush(RGB(255,255,255));
          SetBkColor((HDC)wparam, RGB(255,255,255));
          return (int)(GetStockObject(WHITE_BRUSH));
	  }
	  break;

  case WM_LBUTTONDOWN:
	  {
		  ReleaseCapture();
		  SendMessage(hwnd, WM_SYSCOMMAND, 0xf012, 0);
	  }
	  break;

  case WM_COMMAND:
	  {
		  switch(wparam)
		  {
		  
		  case ID_X:
			  {				  
				  EndDialog(hwnd,0);
				  PostQuitMessage(0);
			  }
			  break;

		  case ID_V:
			  {
				  ShowWindow(hwnd,SW_MINIMIZE);
			  }
			  break;

		  case ID_OPENBUT:
			  {
				  OPENFILENAME ofn;

				  ZeroMemory(&ofn, sizeof(OPENFILENAME));
			      ofn.lStructSize = sizeof(OPENFILENAME);	
				  ofn.hwndOwner = hwnd;	
				  ofn.hInstance = hInst;	
				  ofn.lpstrFilter = filterstring;	
				  ofn.lpstrFile = filename;	
				  ofn.nMaxFile =  512;
				  ofn.lpstrTitle = "Choose file...";	
				  ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_LONGNAMES | OFN_EXPLORER | OFN_HIDEREADONLY;	
				  if (GetOpenFileName(&ofn))
				  {
					  SetWindowText(GetDlgItem(hwnd,ID_FILESTATIC),filename);
					  EnableWindow(GetDlgItem(hwnd,ID_ADDBUT),TRUE);
					  EnableWindow(GetDlgItem(hwnd,ID_TEST),TRUE);
				  }
			  }
			  break;

		  case ID_ADDBUT:
			  {

				  BOOL bSuccess;
				  int secnamelen = GetDlgItemText(hwnd, ID_SECNAME, secname,8); 	
				  if (secnamelen == 0)
				  {
					  MessageBox(hwnd, "You have to enter a section name! (Max. 8 char)", "Missing Info",MB_ICONSTOP);
					  return 0;
				  }

				  if (SendMessage(GetDlgItem(hwnd,ID_DEC), BM_GETCHECK, 0, 0) == BST_CHECKED)
				  {  // decimal 
					  
					  
					  int ResInt = GetDlgItemInt(hwnd, ID_SECSIZE, &bSuccess, FALSE);		  
					  if (bSuccess == FALSE)				  
					  {					
						  MessageBox(hwnd,"Not a valid Integer value!",":-(",MB_ICONSTOP);						
						  return 0;				  
					  }
					  secsize = ResInt;
				  }
				  else
				  {  // hexadecimal
					  char buffer[MAX_PATH];
					  GetDlgItemText(hwnd,ID_SECSIZE,buffer,sizeof(buffer));

					  // check if entered value is valid hex value	
					  int len = lstrlen(buffer);	
					  for(int i=0;i<len;i++)	
					  {							
						  if (isHex(buffer[i]) == 0)
						  {			
							  MessageBox(hwnd,"You have entered an invalid hexadecimal value!",":-(",MB_ICONSTOP);		
							  return 0;
						  }	
					  }

					  secsize = HextoDec(buffer);
				  }



				

				  // Backup ?
				  if (SendMessage(GetDlgItem(hwnd,ID_BACKUP), BM_GETCHECK, 0, 0) == BST_CHECKED)
				  {
					  char backupfile[MAX_PATH];
					  
					  lstrcpy(backupfile,filename);
					  int len = lstrlen(backupfile);
					  backupfile[len-4] = 0;
					  lstrcat( backupfile,    ".bak");
					  
					  if (CopyFile(filename, backupfile, FALSE) == FALSE)
					  {
						  if (MessageBox(hwnd, "CopyFile failed! Continue?","error",MB_YESNO) == IDNO);
							return 0; 
					  }
				  }

				  if (AddSection(hwnd) ==1) MessageBox(hwnd, "Section successfully added!", "Done", MB_OK | MB_ICONINFORMATION);
				 
			  }
			  break;

		  case ID_CHARAC:
			  {	
				  if (CharacWinVisible) return 0;

				  char buffer[MAX_PATH];
				  GetDlgItemText(hwnd,ID_CSTATIC,buffer,sizeof(buffer));

				  // check if entered value is valid hex value	
				  int len = lstrlen(buffer);	
				  for(int i=0;i<len;i++)	
				  {							
					  if (isHex(buffer[i]) == 0)
					  {			
						  MessageBox(hwnd,"You have entered an invalid hexadecimal value!",":-(",MB_ICONSTOP);		
						  return 0;
					  }	
				  }
				  characteristic = HextoDec(buffer);
				  // save characteristic
				  oldcharac = characteristic;

				  CharacWinVisible = TRUE;
				  DialogBoxParam(hInst, MAKEINTRESOURCE(102),NULL,(DLGPROC)CharacProc, NULL);

			  }
			  break;

		  case ID_TEST:
			  {				  
				  STARTUPINFO si;
				  PROCESS_INFORMATION pi;
				  ZeroMemory(&si, sizeof(si));
				  ZeroMemory(&pi, sizeof(pi));
				  si.cb = sizeof(STARTUPINFO);
				  if (!(CreateProcess(filename, NULL, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi)))
				  {
					MessageBox(hwnd, "Could not create process! Maybe I've messed up the file... :-(", "Error", MB_ICONSTOP);
					return 0;
				  }
				  ResumeThread(pi.hThread);			
			  }	
			  break;

		  default:break;
		  }
	  }
	  break;
  case WM_CLOSE: 
	  {
		  EndDialog(hwnd,0);
	  }
	  break;

  case WM_LBUTTONDBLCLK:
	  {
		  RECT rect;
		  rect.left = 50; rect.top = 15;
		  rect.right = 50 + 210; rect.bottom = rect.top + 20;
		  POINT p;
		  p.x = (LOWORD(lparam));
		  p.y = (HIWORD(lparam));
		  if (PtInRect(&rect, p ))
			  DialogBoxParam(hInst, MAKEINTRESOURCE(103),NULL,(DLGPROC)AboutProc, NULL);
	  }
	  break;



  default:break;	  
  }
  
  return FALSE;
}


int WINAPI WinMain(HINSTANCE hinstance, HINSTANCE hprevinstance, LPSTR lpcmdline, int ncmdshow)
{
	hInst = GetModuleHandle(0);
	DialogBoxParamA(hinstance, MAKEINTRESOURCE(101), NULL, (DLGPROC)DlgProc, NULL);

	return 0;
}

// ** Entry Point ** (function originally written by Matt Pietrek)
int WINAPI WinMainCRTStartup(void)
{
    STARTUPINFO				StartupInfo={sizeof(STARTUPINFO),0};
    int				        mainret;
    char				*lpszCommandLine = GetCommandLine();
    
    // skip past program name (first token in command line).
    if( *lpszCommandLine == '"' )  // check for and handle quoted program name
    {
        // scan, and skip over, subsequent characters until  another
        // double-quote or a null is encountered
        while( *lpszCommandLine && (*lpszCommandLine != '"') )
            lpszCommandLine++;

        // if we stopped on a double-quote (usual case), skip over it.
        if( *lpszCommandLine == '"' )
            lpszCommandLine++;
    }
    else    
    {
        // first token wasn't a quote
        while ( *lpszCommandLine > ' ' )
            lpszCommandLine++;
    }

    // skip past any white space preceeding the second token.
    while ( *lpszCommandLine && (*lpszCommandLine <= ' ') )
        lpszCommandLine++;

    GetStartupInfo(&StartupInfo);

    mainret = WinMain( GetModuleHandle(NULL),
                       NULL,
                       lpszCommandLine,
                       StartupInfo.dwFlags & STARTF_USESHOWWINDOW
                            ? StartupInfo.wShowWindow : SW_SHOWDEFAULT );

    ExitProcess(mainret);
    
    return mainret;
}
