#include <stdio.h>
#include "windows.h"
#include "plugin.h"

/* BUG: Distinguishes windows by title when saving; this can go wrong as
	follows:
	
	- you have selected the CPU window as stay on top
	- the CPU window has the title "CPU - main thread"
	- you close OllyDbg
	- the plugin saves the window title "CPU - main thread" as stay
	  on top
	- you start OllyDbg again without immediately executing a file,
	  so the CPU window will have the title "CPU"
	- as the titles do not match, so the saved setting is not restored

	I guess I could fix this for the CPU window by distinguishing using
	class names, but that would go wrong with multiple windows of the 
	same class.

	Would need specification for every possible class name if it can be
	instantiated multiple times or not.

   BUG: Does not save stay on top state when a window is closed, when it
        is created again it will not be stay on top initially, whether or
	not it was stay on top when it was closed.
*/

#define STAYONTOP_VERSION "1.0"

#define TIMER_STAYONTOP 123

#define MAX_SEL_WINDOWS 25
#define MAX_WINDOWS 25
#define MAX_WINDOWTITLE 256

LRESULT CALLBACK stayontop_wndproc(HWND hw, UINT msg, WPARAM wp, LPARAM lp);
void display_stayontop_window();

HINSTANCE instance;
HWND ollymain;

char stayontop_classname[32];
HWND stayontop_wnd = NULL;
HWND listbox;
char temp_string[256];
HBRUSH background;

int loaded = 0;

int xd, yd, wd, hd;

char str_restore[] = "restore window";
char str_wndpos[] = "window pos";
char str_wnd_count[] = "windows";
char str_wnd[] = "window";

t_table stayontop_table;

BOOL WINAPI DllMain(HINSTANCE new_instance, DWORD fdwReason, LPVOID lpvReserved) {
	instance = new_instance;
	return TRUE;
}

extc int __declspec(dllexport) __cdecl ODBG_Plugininit(int ollydbgversion, HWND hw, ulong *features) {
	ollymain = hw;

	if(Registerpluginclass(stayontop_classname, NULL, instance, stayontop_wndproc)<0) {
		return -1;
	}
	
	if(Plugingetvalue(VAL_RESTOREWINDOWPOS)!=0 && Pluginreadintfromini(instance, str_restore,0)!=0) {
		display_stayontop_window();
	}

	Addtolist(0, 0, "Stay on top plugin v" STAYONTOP_VERSION "; compiled " __DATE__ " " __TIME__ " CET");
	Addtolist(0, -1, "  Copyright (C) 2002 Matthijs Laan <matthijsln@xs4all.nl>");
	return 0;
}

extc int  __declspec(dllexport) __cdecl ODBG_Plugindata(char shortname[32]) {
	strcpy(shortname, "Stay on top");
	return PLUGIN_VERSION;
}

extc void __declspec(dllexport) __cdecl ODBG_Pluginaction(int origin,int action,void *item) {
	if(!action) {
		display_stayontop_window();
	}
}

extc int __declspec(dllexport) __cdecl ODBG_Pluginclose(void) {
	Pluginwriteinttoini(instance, str_restore, stayontop_wnd ? 1 : 0);
	return 0;
}

LRESULT CALLBACK stayontop_wndproc(HWND hw, UINT msg, WPARAM wp, LPARAM lp) {
	switch(msg) {
		case WM_CREATE: {
			background = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));

			listbox = CreateWindowEx(WS_EX_CLIENTEDGE, "LISTBOX", "", WS_CHILD | WS_VSCROLL | WS_VISIBLE | LBS_NOINTEGRALHEIGHT | LBS_HASSTRINGS | LBS_MULTIPLESEL, 0, 0, 0, 0, hw, NULL, instance, 0);

			SendMessage(listbox, WM_SETFONT, (WPARAM)GetStockObject(DEFAULT_GUI_FONT), 0);
			
			SetTimer(hw, TIMER_STAYONTOP, 100, NULL);
			break;
		}
		case WM_SIZE: {
			RECT r;
			GetClientRect(hw, &r);
			MoveWindow(listbox, 2, 2, r.right - 4, r.bottom - 4, TRUE);
		}
		case WM_TIMER: {
			if(wp==TIMER_STAYONTOP) {
				HWND mdiwnd, wnd;
				int wnd_count;
				int i, j, changed;
				int sel_count;
				static HWND windows[MAX_WINDOWS];
				static int selected[MAX_SEL_WINDOWS];
				static int too_many_windows = 0;
				static HWND selected_windows[MAX_SEL_WINDOWS];

				/* get all MDI child windows, the highest in Z order fist */
				wnd = NULL;
				mdiwnd = FindWindowEx(ollymain, NULL, "MDIClient", NULL);

				wnd_count = 0;
				changed = 0;
				while(wnd = FindWindowEx(mdiwnd, wnd, NULL, NULL)) {
					if(wnd_count==MAX_WINDOWS) {
						if(!too_many_windows) {
							Addtolist(0,1,"Error; Stay on top plugin limited to %d windows; recompile with higher MAX_WINDOWS", MAX_WINDOWS);
							too_many_windows = 1;
						}
						return 0;
					}
					if(windows[wnd_count]!=wnd) {
						changed = 1;
					}
					windows[wnd_count++] = wnd;
				}
				too_many_windows = 0;

				sel_count = SendMessage(listbox, LB_GETSELCOUNT, 0, 0);
				if(sel_count>MAX_SEL_WINDOWS) {
					Addtolist(0,1,"Error; Stay on top plugin limited to %d stay on top windows; recompile with higher MAX_SEL_WINDOWS", MAX_SEL_WINDOWS);
					SendMessage(listbox, LB_RESETCONTENT, 0, 0);
					return 0;
				}
				
				SendMessage(listbox, LB_GETSELITEMS, sel_count, (LPARAM)selected);

				for(i=0; i<sel_count; i++) {
					selected_windows[i] = (HWND)SendMessage(listbox, LB_GETITEMDATA, selected[i], 0);
				}

				/* set MDI child windows' Z orders */
				if(sel_count) {
					HWND current_hwnd = HWND_TOP;

					for(i=0; i<wnd_count; i++) {
						for(j=0; j<sel_count; j++) {
							if(windows[i]==selected_windows[j]) {
								SetWindowPos(windows[i], current_hwnd, 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
								current_hwnd = windows[i];
								break;
							}
						}
					}
				}

				/* refresh listbox, if necessary */

				if(changed) {
					SendMessage(listbox, LB_RESETCONTENT, 0, 0);

					for(i = 0; i<wnd_count; i++) {
						GetWindowText(windows[i], temp_string, sizeof(temp_string)-1);
						SendMessage(listbox, LB_ADDSTRING, 0, (LPARAM)temp_string);
						SendMessage(listbox, LB_SETITEMDATA, i, (LPARAM)windows[i]);

						for(j = 0; j<sel_count; j++) {
							if(windows[i]==selected_windows[j]) {
								SendMessage(listbox, LB_SETSEL, TRUE, i);
								break;
							}
						}
					}
				}
				
				if(!loaded) {
					char temp[25];
					static int partially_loaded = 0;
					static int saved_windows;
					static int saved_window_index = 0;

					if(!partially_loaded) {
						saved_windows = Pluginreadintfromini(instance, str_wnd_count, 0);
						partially_loaded = 1;
					} else {
						int index;

						_snprintf(temp, sizeof(temp)-1, "%s%d", str_wnd, saved_window_index++);
						Pluginreadstringfromini(instance, temp, temp_string, "");

						if((index=SendMessage(listbox, LB_FINDSTRINGEXACT, -1, (LPARAM)temp_string))!=LB_ERR) {
							SendMessage(listbox, LB_SETSEL, TRUE, index);
						}

						if(--saved_windows==0) {
							loaded = 1;
						}
					}
				}
			}
			break;
		}
		case WM_DESTROY: {
			RECT r;
			int w, h;
			int i;
			int sel_count;
			char temp[25];
			int selected[MAX_SEL_WINDOWS];

			KillTimer(hw, TIMER_STAYONTOP) ;

			/* save window pos */
			GetWindowRect(hw, &r);
			w = r.right - r.left;
			h = r.bottom - r.top;
			ScreenToClient(FindWindowEx(ollymain, NULL, "MDIClient", NULL), (POINT *)&r);
			_snprintf(temp_string, sizeof(temp_string)-1, "%d,%d,%d,%d", r.left, r.top, w, h);
			Pluginwritestringtoini(instance, str_wndpos, temp_string);

			/* save stay on top windows */
			sel_count = SendMessage(listbox, LB_GETSELCOUNT, 0, 0);
			if(sel_count>MAX_SEL_WINDOWS) {
				Addtolist(0,1,"Error; Stay on top plugin limited to %d stay on top windows; recompile with higher MAX_SEL_WINDOWS", MAX_SEL_WINDOWS);
				SendMessage(listbox, LB_RESETCONTENT, 0, 0);
				sel_count = 0;
			}
			
			Pluginwriteinttoini(instance, str_wnd_count, sel_count);

			SendMessage(listbox, LB_GETSELITEMS, sel_count, (LPARAM)selected);

			for(i=0; i<sel_count; i++) {
				SendMessage(listbox, LB_GETTEXT, selected[i], (LPARAM)temp_string);
				_snprintf(temp, sizeof(temp)-1, "%s%d", str_wnd, i);
				Pluginwritestringtoini(instance, temp, temp_string);
			}

			stayontop_wnd = 0;
			return 0;
		}
	}
	return DefMDIChildProc(hw, msg, wp, lp);
}

void display_stayontop_window() {
	if(stayontop_wnd) {
		SetWindowPos(stayontop_wnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
	} else {
		int x, y, w, h;

		stayontop_table.mode = TABLE_USERDEF | TABLE_NOHSCR;
		stayontop_table.hscroll = 0;
		
		stayontop_wnd = Newtablewindow(&stayontop_table, 0, 0, stayontop_classname, "Stay on top");
		
		Pluginreadstringfromini(instance, str_wndpos, temp_string, "0,0,70,100");
		sscanf(temp_string, "%d,%d,%d,%d", &x, &y, &w, &h);
		SetWindowPos(stayontop_wnd, 0, x, y, w, h, SWP_NOZORDER);
		ShowScrollBar(stayontop_wnd, SB_BOTH, FALSE);
		SetClassLong(stayontop_wnd, GCL_HBRBACKGROUND, COLOR_BTNFACE+1);
	}
}
