/*
 * strace.c
 * 
 * Copyright (c) 2000-2002, BindView Corporation.
 *
 * See LICENSE file.
 *
 */

#include <stdio.h>
#include "struct_info.h"


#define NUM_ENTRIES(x) ((sizeof(x))/(sizeof ((x)[0])))

extern FILE *output;

typedef unsigned long ULONG;
typedef unsigned char UCHAR;

/*
 * the definition of a struct element, for printing purposes
 */
struct struct_elem {
    int type;
    int size;
    char *name;
};

enum elem_types {
    eULONG = 1,
    eULONGx,
    eUCHAR,
    eLARGE_INTEGER,
    eUNICODE_STRING,
};


static void
pprint_struct (char *buff, size_t len, struct struct_elem *pstruct)
{
    size_t used = 0;

    fprintf (output, "{");
    while (pstruct->type != 0 && used + pstruct->size <= len) {
        switch (pstruct->type) {
        case eULONG:
            fprintf (output, "%s=%d,", pstruct->name, *(unsigned long *)buff);
            break;

        case eULONGx:
            fprintf (output, "%s=0x%x,", pstruct->name, *(unsigned long *)buff);
            break;

        case eUCHAR:
            fprintf (output, "%s=%d,", pstruct->name, *buff);
            break;

        case eLARGE_INTEGER:
            fprintf (output, "%s={0x%x, 0x%x},", pstruct->name,
                    *(unsigned long *)buff,
                    *((unsigned long *)buff+1));
            break;

        case eUNICODE_STRING:
            /* FIXME: do something more useful */
            fprintf (output, "%s={0x%x, 0x%x},", pstruct->name,
                    *(unsigned long *)buff,
                    *((unsigned long *)buff+1));
            break;

        default:
            break;
        }
        used += pstruct->size;
        buff += pstruct->size;
        pstruct++;
    }
    fprintf (output, "}, ");
}

void
print_generic_info_buff (void *p, size_t len, unsigned int info_class,
                         char *info_type, struct struct_elem *structs[],
                         unsigned int num_structs)
{
    if ((info_class < num_structs)
        && (structs[info_class] != NULL)) {
        pprint_struct (p, len, structs[info_class]);
    } else {
        fprintf (output, "{%s info, class %d, size %d}, ", info_type, info_class,
                len);
    }
}


/*
 * System infos
 */

struct struct_elem system_info_basic_struct[] = {
    { eULONG, sizeof (ULONG), "Unknown" },
    { eULONG, sizeof (ULONG), "MaximumIncrement" },
    { eULONGx, sizeof (ULONG), "PhysicalPageSize" },
    { eULONGx, sizeof (ULONG), "NumberOfPhysicalPages" },
    { eULONGx, sizeof (ULONG), "LowestPhysicalPage" },
    { eULONGx, sizeof (ULONG), "HighestPhysicalPage" },
    { eULONGx, sizeof (ULONG), "AllocationGranularity" },
    { eULONGx, sizeof (ULONG), "LowestUserAddress" },
    { eULONGx, sizeof (ULONG), "HighestUserAddress" },
    { eULONG, sizeof (ULONG), "ActiveProcessors" },
    { eUCHAR, sizeof (UCHAR), "NumberProcessors" },
    { 0, 0, NULL },
};


struct struct_elem *system_infos[] = {
    system_info_basic_struct,
};
unsigned int num_system_infos = NUM_ENTRIES (system_infos);


/*
 * Object infos
 */

struct struct_elem object_info_basic_struct[] = {
    { eULONG,  sizeof (ULONG), "Attributes" },
    { eULONGx, sizeof (ULONG), "GrantedAccess" },
    { eULONG,  sizeof (ULONG), "HandleCount" },
    { eULONG,  sizeof (ULONG), "PointerCount" },
    { eULONGx, sizeof (ULONG), "PagedPoolUsage" },
    { eULONGx, sizeof (ULONG), "NonPagedPoolUsage" },
    { eULONGx, sizeof (ULONG), "Reserved" },
    { eULONGx, sizeof (ULONG), "Reserved[1]" },
    { eULONGx, sizeof (ULONG), "Reserved[2]" },
    { eULONG, sizeof (ULONG), "NameInfoLen" },
    { eULONG, sizeof (ULONG), "TypeInfoLen" },
    { eULONG, sizeof (ULONG), "SDLen" },
    { eLARGE_INTEGER, 8, "CreateTime" },
    { 0, 0, NULL },
};

struct struct_elem object_info_name_struct[] = {
    { eUNICODE_STRING,  8, "Name" },
    { 0, 0, NULL },
};

struct struct_elem object_info_type_struct[] = {
    { eUNICODE_STRING,  8, "Name" },
    { eULONG,  sizeof (ULONG), "ObjectCount" },
    { eULONG,  sizeof (ULONG), "HandleCount" },
    /* FIXME: more to add here */
    { 0, 0, NULL },
};

struct struct_elem object_info_all_types_struct[] = {
    { eULONG,  sizeof (ULONG), "NumberOfTypes" },
    /* FIXME: more to add here */
    { 0, 0, NULL },
};

struct struct_elem object_info_handle_struct[] = {
    { eUCHAR,  sizeof (UCHAR), "Inherit" },
    { eUCHAR,  sizeof (UCHAR), "ProtectFromClose" },
    /* FIXME: more to add here */
    { 0, 0, NULL },
};

struct struct_elem *object_infos[] = {
    object_info_basic_struct,
    object_info_name_struct,
    object_info_type_struct,
    object_info_all_types_struct,
    object_info_handle_struct,
};
unsigned int num_object_infos = NUM_ENTRIES (object_infos);


/*
 * Memory infos
 */
struct struct_elem memory_info_basic_struct[] = {
    { eULONGx, sizeof (ULONG), "BaseAddress" },
    { eULONGx, sizeof (ULONG), "AllocationBase" },
    { eULONGx, sizeof (ULONG), "AllocationProtect" },
    { eULONGx, sizeof (ULONG), "RegionSize" },
    { eULONGx, sizeof (ULONG), "State" },
    { eULONGx, sizeof (ULONG), "Protect" },
    { eULONGx, sizeof (ULONG), "Type" },
    { 0, 0, NULL },
};

struct struct_elem *memory_infos[] = {
    memory_info_basic_struct,
};
unsigned int num_memory_infos = NUM_ENTRIES (memory_infos);


/*
 * Section infos
 */
struct struct_elem section_info_basic_struct[] = {
    { eULONGx, sizeof (ULONG), "BaseAddress" },
    { eULONGx, sizeof (ULONG), "Attributes" },
    { eLARGE_INTEGER, 8, "Size" },
    { 0, 0, NULL },
};

struct struct_elem *section_infos[] = {
    section_info_basic_struct,
};
unsigned int num_section_infos = NUM_ENTRIES (section_infos);


/*
 * Thread infos
 */
struct struct_elem thread_info_basic_struct[] = {
    { eULONGx, sizeof (ULONG), "ExitStatus" },
    { eULONGx, sizeof (ULONG), "TebBaseAddress" },
    { eULONG, sizeof (ULONG), "Pid" },
    { eULONG, sizeof (ULONG), "Tid" },
    /* FIXME: there's more here */
    { 0, 0, NULL },
};

struct struct_elem thread_info_impersonation_struct[] = {
    { eULONG, sizeof (ULONG), "ImpToken" },
};

struct struct_elem thread_info_win32_start_addr_struct[] = {
    { eULONGx, sizeof (ULONG), "StartAddress(LpcReceivedMsgId)" },
};

struct struct_elem thread_info_zero_tls_struct[] = {
    { eULONGx, sizeof (ULONG), "ZeroTlsCell" },
};

struct struct_elem *thread_infos[] = {
    thread_info_basic_struct,
    NULL,
    NULL,
    NULL,
    NULL,
    thread_info_impersonation_struct,
    NULL,
    NULL,
    NULL,
    thread_info_win32_start_addr_struct,
    thread_info_zero_tls_struct,
};
unsigned int num_thread_infos = NUM_ENTRIES (thread_infos);


/*
 * Process infos
 */

struct struct_elem process_info_basic_struct[] = {
    { eULONGx, sizeof (ULONG), "ExitStatus" },
    { eULONGx, sizeof (ULONG), "PebBaseAddress" },
    { eULONGx, sizeof (ULONG), "AffinityMask" },
    { eULONG, sizeof (ULONG), "BasePriority" },
    { eULONG, sizeof (ULONG), "Pid" },
    { eULONG, sizeof (ULONG), "ParentPid" },
    { 0, 0, NULL },
};

struct struct_elem process_info_session_struct[] = {
    { eULONG, sizeof (ULONG), "SessionId" },
    { 0, 0, NULL },
};


struct struct_elem *process_infos[] = {
    process_info_basic_struct,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    process_info_session_struct,
};
unsigned int num_process_infos = NUM_ENTRIES (process_infos);


/*
 * Job infos
 */

struct struct_elem *job_infos[] = {
    NULL,
};
unsigned int num_job_infos = NUM_ENTRIES (job_infos);


/*
 * Token infos
 */

struct struct_elem *token_infos[] = {
    NULL,
};
unsigned int num_token_infos = NUM_ENTRIES (token_infos);


/*
 * Timer infos
 */

struct struct_elem timer_info_basic_struct[] = {
    { eLARGE_INTEGER, 8, "TimeRemaining" },
    { eUCHAR, sizeof (UCHAR), "SignalState" },
    { 0, 0, NULL },
};

struct struct_elem *timer_infos[] = {
    timer_info_basic_struct,
};
unsigned int num_timer_infos = NUM_ENTRIES (timer_infos);


/*
 * Event infos
 */

struct struct_elem event_info_basic_struct[] = {
    { eULONG, sizeof (ULONG), "EventType" },
    { eULONG, sizeof (ULONG), "SignalState" },
    { 0, 0, NULL },
};

struct struct_elem *event_infos[] = {
    event_info_basic_struct,
};
unsigned int num_event_infos = NUM_ENTRIES (event_infos);


/*
 * Semaphore infos
 */

struct struct_elem semaphore_info_basic_struct[] = {
    { eULONG, sizeof (ULONG), "CurrentCount" },
    { eULONG, sizeof (ULONG), "MaximumCount" },
    { 0, 0, NULL },
};

struct struct_elem *semaphore_infos[] = {
    semaphore_info_basic_struct,
};
unsigned int num_semaphore_infos = NUM_ENTRIES (semaphore_infos);


/*
 * Mutant infos
 */

struct struct_elem mutant_info_basic_struct[] = {
    { eULONG, sizeof (ULONG), "SignalState" },
    { eUCHAR, sizeof (UCHAR), "Owned" },
    { eUCHAR, sizeof (UCHAR), "Abandoned" },
    { 0, 0, NULL },
};

struct struct_elem *mutant_infos[] = {
    mutant_info_basic_struct,
};
unsigned int num_mutant_infos = NUM_ENTRIES (mutant_infos);


