/*
 * types.c
 * 
 * Copyright (c) 2000, BindView Corporation.
 *
 * See LICENSE file.
 *
 */


#include <windows.h>
#include <winnt.h>

#include "../driver/syscalls.h"
#include "types.h"
#include "struct_info.h"
#include "../driver/ioctlcmd.h"
#include <stdio.h>

extern FILE *output;

#define MagicFoo(type) extern void copy_arg_##type (void *, DWORD);
#include "../driver/typesx.h"
#undef MagicFoo

struct type_info all_types[] = {
#define MagicFoo(type) { copy_arg_##type },
#include "../driver/typesx.h"
#undef MagicFoo
};

const char *lookup_winmsg (unsigned int msg);

#define NUM_ENTRIES(x) ((sizeof(x))/(sizeof ((x)[0])))

/*
 * define the copy functions for real, now
 */
void
copy_arg_DWORD (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "%d, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

void
copy_arg_DWORDx (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

/*
 * define the copy functions for real, now
 */
void
copy_arg_PDWORD (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 8) {
        if (ent->args[*pbytes_used/4] == 0) {
            fprintf (output, "%d, ", ent->args[*pbytes_used/4 + 1]);
        } else {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        }
        *pbytes_used += 8;
    }
}

void
copy_arg_PDWORDx (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 8) {
        if (ent->args[*pbytes_used/4] == 0) {
            fprintf (output, "(0x%x), ", ent->args[*pbytes_used/4 + 1]);
        } else {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        }
        *pbytes_used += 8;
    }
}


/*
 * define the copy functions for real, now
 */
void
copy_arg_HANDLE (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "%d, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

/*
 * define the copy functions for real, now
 */
void
copy_arg_PHANDLE (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 8) {
        if (ent->args[*pbytes_used/4] == 0) {
            fprintf (output, "%d, ", ent->args[*pbytes_used/4 + 1]);
        } else {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        }
        *pbytes_used += 8;
    }
}


void
copy_arg_POBJ_ATTRIB (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int len;

    if (ent->args_size >= *pbytes_used + 8) {
        if (ent->args[*pbytes_used/4] == -1) {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
            *pbytes_used += 8;
        } else {
            *pbytes_used += 4;
            fprintf (output, "{%d, %d, 0x%x, %d, %d, ",
                    ent->args[*pbytes_used/4],
                    ent->args[*pbytes_used/4+1],
                    ent->args[*pbytes_used/4+3],
                    ent->args[*pbytes_used/4+4],
                    ent->args[*pbytes_used/4+5]);
            *pbytes_used += 0x18;

            if (ent->args[*pbytes_used/4] == -1) {
                fprintf (output, "0x%x", ent->args[*pbytes_used/4 + 1]);
                *pbytes_used += 8;
            } else {
                *pbytes_used += 4;
                len = *(unsigned short *)(&ent->args[*pbytes_used/4]);
                *pbytes_used += 8;

                if (ent->args[*pbytes_used/4] == -1) {
                    fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
                    *pbytes_used += 8;
                } else {
                    *pbytes_used += 4;
                    fwprintf (output, L"\"%.*s\"", len/2, &ent->args[*pbytes_used/4]);
                    *pbytes_used += ((len +3) / 4) * 4;
                }
            }
            fprintf (output, "}, ");
        }
    }
}



void
copy_arg_PUNICODE_STRING (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int len;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        len = *(unsigned short *)(&ent->args[*pbytes_used/4]);
        *pbytes_used += 8;

        if (ent->args[*pbytes_used/4] == -1) {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
            *pbytes_used += 8;
        } else {
            *pbytes_used += 4;
            fwprintf (output, L"\"%.*s\", ", len/2, &ent->args[*pbytes_used/4]);
            *pbytes_used += ((len +3) / 4) * 4;
        }
    }
}

void
copy_arg_ACCESS_MASK (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

void
copy_arg_PCLIENT_ID (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        fprintf (output, "{%d, %d}, ",
                ent->args[*pbytes_used/4],
                ent->args[*pbytes_used/4+1]);
        *pbytes_used += 8;
    }
}

void
copy_arg_PIO_STATUS_BLOCK (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        fprintf (output, "{status=0x%x, info=%d}, ",
                ent->args[*pbytes_used/4],
                ent->args[*pbytes_used/4+1]);
        *pbytes_used += 8;
    }
}


void
copy_arg_PLARGE_INTEGER (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        fprintf (output, "{%d, %d}, ",
                ent->args[*pbytes_used/4],
                ent->args[*pbytes_used/4+1]);
        *pbytes_used += 8;
    }
}


void
copy_arg_PLUID (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        fprintf (output, "{%d, %d}, ",
                ent->args[*pbytes_used/4],
                ent->args[*pbytes_used/4+1]);
        *pbytes_used += 8;
    }
}


void
copy_arg_PSECURITY_QOS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        fprintf (output, "{%d, %d, %d, %d}, ",
                ent->args[*pbytes_used/4],
                ent->args[*pbytes_used/4+1],
                ((char *)(&ent->args[*pbytes_used/4+2]))[0],
                ((char *)(&ent->args[*pbytes_used/4+2]))[1]
                );
        *pbytes_used += 12;
    }
}


static char *lpc_msg_types[] = {
    "new_msg",
    "request",
    "reply",
    "datagram",
    "lost_reply",
    "port_closed",
    "client_died",
    "exception",
    "debug_event",
    "error_event",
    "conn_req",
};

static const char *lpc_msg_type (int type)
{
    if ((type >= 0) &&
        (type <= (sizeof (lpc_msg_types) / sizeof (lpc_msg_types[0]))))
    {
        return lpc_msg_types[type];
    }
    return NULL;
}


void
print_buffer_as_bytes (unsigned char *buf, size_t len)
{
    unsigned int i;
    fprintf (output, "\"");
    for (i=0; i<len; i++) {
        if (isprint (buf[i])) {
            fprintf (output, "%c", buf[i]);
        } else {
            fprintf (output, "\\%o", buf[i]);
        }
    }
    fprintf (output, "\"");
}


void
copy_arg_PLPC_MESSAGE (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    struct foo {
        unsigned short len;
        unsigned short tot_len;
        unsigned short msg_typ;
        unsigned short virt_rang_off;
        unsigned long pid;
        unsigned long tid;
        unsigned long mid;
        unsigned long sctn_sz;
    } *pmsg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        const char *type;
        unsigned long data_size;
        *pbytes_used += 4;
        data_size = ent->args[*pbytes_used/4];
        *pbytes_used += 4;
        pmsg = (struct foo *) &(ent->args[*pbytes_used/4]);
        type = lpc_msg_type (pmsg->msg_typ);
        fprintf (output, "{%d, %d, ",
                pmsg->len,
                pmsg->tot_len);
        if (type) {
            fprintf (output, "%s, ", type);
        } else {
            fprintf (output, "%d, ", pmsg->msg_typ);
        }
        fprintf (output, "%d, %d, %d, %d, %d} ",
                pmsg->virt_rang_off,
                pmsg->pid,
                pmsg->tid,
                pmsg->mid,
                pmsg->sctn_sz);
        *pbytes_used += sizeof (*pmsg);
        print_buffer_as_bytes ((char *)&(ent->args[*pbytes_used/4]),
                               data_size);
        fprintf (output, " ");
        *pbytes_used += data_size;
    }
}

void
copy_arg_PLPC_SECTIONINFO (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    struct foo {
        unsigned long len;
        unsigned long handle;
        unsigned long hmmm1;
        unsigned long sz;
        unsigned long cli_addr;
        unsigned long srv_addr;
    } *pmsg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        pmsg = (struct foo *) &(ent->args[*pbytes_used/4]);
        fprintf (output, "{%d, %d, %d, %d, %d, %d}, ",
                pmsg->len,
                pmsg->handle,
                pmsg->hmmm1,
                pmsg->sz,
                pmsg->cli_addr,
                pmsg->srv_addr);
        *pbytes_used += sizeof (*pmsg);
    }
}

void
copy_arg_PLPC_SECTIONMAPINFO (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    struct foo {
        unsigned long len;
        unsigned long sz;
        unsigned long srv_addr;
    } *pmsg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        pmsg = (struct foo *) &(ent->args[*pbytes_used/4]);
        fprintf (output, "{%d, %d, %d}, ",
                pmsg->len,
                pmsg->sz,
                pmsg->srv_addr);
        *pbytes_used += sizeof (*pmsg);
    }
}

void
copy_arg_PSECURITY_DESCRIPTOR (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    SECURITY_DESCRIPTOR *pSD;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        pSD = (SECURITY_DESCRIPTOR*) &(ent->args[*pbytes_used/4]);
        fprintf (output, "{%d, %d, 0x%x, %d, %d, %d, %d}, ",
                pSD->Revision,
                pSD->Sbz1,
                pSD->Control,
                pSD->Owner,
                pSD->Group,
                pSD->Sacl,
                pSD->Dacl);
        *pbytes_used += sizeof (*pSD);
    }
}



char *system_info_class[] = {
    "Basic",
    "Processor",
    "Performance",
    "TimeOfDay",
    "NotImpl(4)",
    "ProcessesAndThreads",
    "CallCounts",
    "Configuration",
    "ProcessorTimes",
    "GlobalFlag",
    "NotImpl(10)",
    "Module",
    "Lock",
    "NotImpl(13)",
    "NotImpl(14)",
    "NotImpl(15)",
    "Handle",
    "Object",
    "Pagefile",
    "InstructionEmulationCounts",
    "Invalid(20)",
    "Cache",
    "PoolTag",
    "ProcessorStatistics",
    "Dpc",
    "NotImpl(25)",
    "LoadImage",
    "UnloadImage",
    "TimeAdjustment",
    "NotImpl(29)",
    "NotImpl(30)",
    "NotImpl(31)",
    "CrashDump",
    "Exception",
    "CrashDumpState",
    "KernelDebugger",
    "ContextSwitch",
    "RegistryQuota",
    "LoadAndCallImage",
    "PrioritySeparation",
    "NotImpl(40)",
    "NotImpl(41)",
    "Invalid(42)",
    "Invalid(43)",
    "TimeZone",
    "Lookaside",
    "SetTimeSlipEvent",
    "CreateSession",
    "DeleteSession",
    "Invalid(49)",
    "RangeStart",
    "Verifier",
    "AddVerifier",
    "SessionProcesses",
};
#define NUM_SYSTEM_INFO_CLASS (sizeof (system_info_class) / sizeof (system_info_class[0]))
void
copy_arg_SYSTEM_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_SYSTEM_INFO_CLASS) {
            fprintf (output, "%s, ", system_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}

void
copy_arg_generic_info_buff (void *e, DWORD arg, char *info_type,
                            struct struct_elem *structs[],
                            unsigned int num_structs)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int info_class;
    unsigned int buf_size;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;

        info_class = ent->args[*pbytes_used/4];
        buf_size = ent->args[*pbytes_used/4+1];
        print_generic_info_buff (&(ent->args[*pbytes_used/4+2]),
                                 buf_size, info_class,
                                 info_type, structs, num_structs);
        *pbytes_used += buf_size + 8;
    }
}


char *object_info_class[] = {
    "Basic",
    "Name",
    "Type",
    "AllTypes",
    "Handle",
};
void
copy_arg_OBJECT_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (object_info_class)) {
            fprintf (output, "%s, ", object_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}

char *memory_info_class[] = {
    "Basic",
    "WorkingSetList",
    "SectionName",
    "BasicVlm",
};
#define NUM_MEMORY_INFO_CLASS (sizeof (memory_info_class) / sizeof (memory_info_class[0]))
void
copy_arg_MEMORY_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_MEMORY_INFO_CLASS) {
            fprintf (output, "%s, ", memory_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *section_info_class[] = {
    "Basic",
    "Image",
};
#define NUM_SECTION_INFO_CLASS (sizeof (section_info_class) / sizeof (section_info_class[0]))
void
copy_arg_SECTION_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (section_info_class)) {
            fprintf (output, "%s, ", section_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *thread_info_class[] = {
    "Basic",
    "Times",
    "Priority",
    "BasePriority",
    "AffinityMask",
    "ImpersonationToken",
    "DescriptorTableEntry",
    "EnableAlignmentFaultFixup",
    "EventPair",
    "Win32StartAddress(LpcReceivedMessageId)",
    "ZeroTlsCell",
    "PerformanceCount",
    "AmILastThread",
    "IdealProcessor",
    "PriorityBoost",
    "SetTlsArrayAddress",
    "IsIoPending",
    "HideFromDebugger",
};
void
copy_arg_THREAD_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (thread_info_class)) {
            fprintf (output, "%s, ", thread_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *process_info_class[] = {
    "Basic",
    "QuotaLimits",
    "IoCounters",
    "VmCounters",
    "Times",
    "BasePriority",
    "RaisePriority",
    "DebugPort",
    "ExceptionPort",
    "AccessToken",
    "LdtInformation",
    "LdtSize",
    "DefaultHardErrorMode",
    "IoPortHandlers",
    "PooledUsageAndLimits",
    "WorkingSetWatch",
    "UserModeIOPL",
    "EnableAlignmentFaultFixup",
    "PriorityClass",
    "Wx86",
    "HandleCount",
    "AffinityMask",
    "PriorityBoost",
    "DeviceMap",
    "Session",
    "Foreground",
    "Wow64",
};
#define NUM_PROCESS_INFO_CLASS (sizeof (process_info_class) / sizeof (process_info_class[0]))
void
copy_arg_PROCESS_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_PROCESS_INFO_CLASS) {
            fprintf (output, "%s, ", process_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *job_info_class[] = {
    "0", /* not used */
    "BasicAccounting",
    "BasicLimit",
    "BasicProcessIdList",
    "BasicUIRestrictions",
    "SecurityLimitRestrictions",
    "EndOfJobTime",
    "AssociateCompletionPort",
    "BasicAndIoAccounting",
    "ExtendedLimit",
};
#define NUM_JOB_INFO_CLASS (sizeof (job_info_class) / sizeof (job_info_class[0]))
void
copy_arg_JOB_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_JOB_INFO_CLASS) {
            fprintf (output, "%s, ", job_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *token_info_class[] = {
    "0", /* not used */
    "User",
    "Groups",
    "Privileges",
    "Owner",
    "PrimaryGroup",
    "DefaultDacl",
    "Source",
    "Type",
    "ImpersonationLevel",
    "Statistics",
    "RestrictedSids",
    "SessionId",
};
#define NUM_TOKEN_INFO_CLASS (sizeof (token_info_class) / sizeof (token_info_class[0]))
void
copy_arg_TOKEN_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_TOKEN_INFO_CLASS) {
            fprintf (output, "%s, ", token_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *fs_info_class[] = {
    "0", /* not used */
    "Volume",
    "Label",
    "Size",
    "Device",
    "Attribute",
    "Control",
    "FullSize",
    "ObjectId",
};
#define NUM_FS_INFO_CLASS (sizeof (fs_info_class) / sizeof (fs_info_class[0]))
void
copy_arg_FS_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_FS_INFO_CLASS) {
            fprintf (output, "%s, ", fs_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *file_info_class[] = {
    "0", /* not used */
    "Directory",
    "FullDirectory",
    "BothDirectory",
    "Basic",
    "Standard",
    "Internal",
    "Ea",
    "Access",
    "Name",
    "Rename",
    "Link",
    "Names",
    "Disposition",
    "Position",
    "15", /* not used */
    "Mode",
    "Alignment",
    "All",
    "Allocation",
    "EndOfFile",
    "AlternateName",
    "Stream",
    "Pipe",
    "PipeLocal",
    "PipeRemote",
    "MailslotQuery",
    "MailslotSet",
    "Compression",
    "ObjectId",
    "Completion",
    "MoveCluster",
    "Quota",
    "ReparsePoint",
    "NetworkOpen",
    "AttributeFlag",
    "Tracking",
};
#define NUM_FILE_INFO_CLASS (sizeof (file_info_class) / sizeof (file_info_class[0]))
void
copy_arg_FILE_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_FILE_INFO_CLASS) {
            fprintf (output, "%s, ", file_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *key_info_class[] = {
    "Basic",
    "Node",
    "Full",
    "Name",
};
#define NUM_KEY_INFO_CLASS (sizeof (key_info_class) / sizeof (key_info_class[0]))
void
copy_arg_KEY_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_KEY_INFO_CLASS) {
            fprintf (output, "%s, ", key_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *key_value_info_class[] = {
    "Basic",
    "Full",
    "Partial",
    "FullAlign64",
};
#define NUM_KEY_VALUE_INFO_CLASS (sizeof (key_value_info_class) / sizeof (key_value_info_class[0]))
void
copy_arg_KEY_VALUE_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_KEY_VALUE_INFO_CLASS) {
            fprintf (output, "%s, ", key_value_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *timer_info_class[] = {
    "Basic",
};
void
copy_arg_TIMER_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (timer_info_class)) {
            fprintf (output, "%s, ", timer_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *event_info_class[] = {
    "Basic",
};
void
copy_arg_EVENT_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (event_info_class)) {
            fprintf (output, "%s, ", event_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *semaphore_info_class[] = {
    "Basic",
};
void
copy_arg_SEMAPHORE_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (semaphore_info_class)) {
            fprintf (output, "%s, ", semaphore_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


char *mutant_info_class[] = {
    "Basic",
};
void
copy_arg_MUTANT_INFO_CLASS (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        unsigned int class = ent->args[*pbytes_used/4];

        if (class < NUM_ENTRIES (mutant_info_class)) {
            fprintf (output, "%s, ", mutant_info_class[class]);
        } else {
            fprintf (output, "%d, ", class);
        }
        *pbytes_used += 4;
    }
}


void
copy_arg_PSYSTEM_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "system", system_infos, num_system_infos);
}

void
copy_arg_POBJECT_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "object", object_infos, num_object_infos);
}

void
copy_arg_PMEMORY_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "memory", memory_infos, num_memory_infos);
}

void
copy_arg_PSECTION_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "section", section_infos, num_section_infos);
}

void
copy_arg_PTHREAD_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "thread", thread_infos, num_thread_infos);
}

void
copy_arg_PPROCESS_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "process", process_infos, num_process_infos);
}

void
copy_arg_PJOB_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "job", job_infos, num_job_infos);
}

void
copy_arg_PTOKEN_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "token", token_infos, num_token_infos);
}

void
copy_arg_PTIMER_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "timer", timer_infos, num_timer_infos);
}

void
copy_arg_PEVENT_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "event", event_infos, num_event_infos);
}

void
copy_arg_PSEMAPHORE_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "semaphore", semaphore_infos, num_semaphore_infos);
}

void
copy_arg_PMUTANT_INFO_BUFF (void *e, DWORD arg)
{
    copy_arg_generic_info_buff (e, arg, "mutant", mutant_infos, num_mutant_infos);
}


void
copy_arg_PVOID_WITH_IO_BUFF (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        unsigned long data_size;

        *pbytes_used += 4;

        data_size = ent->args[*pbytes_used/4];
        *pbytes_used += 4;

        print_buffer_as_bytes ((char *)&(ent->args[*pbytes_used/4]),
                               data_size);
        fprintf (output, ", ");
        *pbytes_used += data_size;
        *pbytes_used = ((*pbytes_used +3)/4) * 4;
    }
}


void
copy_arg_PVOID_BUFF (void *e, DWORD arg)
{
    copy_arg_PVOID_WITH_IO_BUFF (e, arg);
}


void
copy_arg_PKEY_INFO_BUFF (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int info_class;
    unsigned int buf_size;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;

        info_class = ent->args[*pbytes_used/4];
        buf_size = ent->args[*pbytes_used/4+1];

        /* FIXME: make these paranoid about buf_size */ 
        switch (info_class) {
        case 0: /* Basic */
            fprintf (output, "{LastWrite={0x%x,0x%x}, TitleIdx=%d, Name=\"%S\"}, ",
                    ent->args[*pbytes_used/4+2],
                    ent->args[*pbytes_used/4+3],
                    ent->args[*pbytes_used/4+4],
                    &(ent->args[*pbytes_used/4+6]));
            break;

        case 1: /* Node */
            fprintf (output, "{LastWrite={0x%x,0x%x}, TitleIdx=%d, Name=\"%S\", Class=\"%S\"}, ",
                    ent->args[*pbytes_used/4+2],
                    ent->args[*pbytes_used/4+3],
                    ent->args[*pbytes_used/4+4],
                    &(ent->args[*pbytes_used/4+8]),
                    ((char *)&ent->args[*pbytes_used/4+2])+
                    ent->args[*pbytes_used/4+5]);
            break;

        case 2: /* Full */
            /* FIXME: add the rest */
            fprintf (output, "{LastWrite={0x%x,0x%x}, TitleIdx=%d, Subkeys=%d, Values=%d, Class=\"%S\"}, ",
                    ent->args[*pbytes_used/4+2],
                    ent->args[*pbytes_used/4+3],
                    ent->args[*pbytes_used/4+4],
                    ent->args[*pbytes_used/4+7],
                    ent->args[*pbytes_used/4+10],
                    &(ent->args[*pbytes_used/4+13]));
            break;

        case 3: /* Name */
            fprintf (output, "{Name=\"%S\"}, ",
                    &(ent->args[*pbytes_used/4+3]));
            break;

        default:
            fprintf (output, "{key info, class %d, size %d}, ",
                    info_class, buf_size);
            break;
        }
        *pbytes_used += buf_size + 8;
        *pbytes_used = ((*pbytes_used +3)/4) * 4;
    }
}

void
copy_arg_PKEY_VALUE_INFO_BUFF (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int info_class;
    unsigned int buf_size;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;

        info_class = ent->args[*pbytes_used/4];
        buf_size = ent->args[*pbytes_used/4+1];

        /* FIXME: make these paranoid about buf_size */ 
        switch (info_class) {
        case 0:  /* Basic */
            fprintf (output, "TitleIdx=%d, Type=%d, Name=\"%S\"}, ",
                    ent->args[*pbytes_used/4+2],
                    ent->args[*pbytes_used/4+3],
                    &(ent->args[*pbytes_used/4+5]));
            break;

        case 1:  /* Full */
            fprintf (output, "TitleIdx=%d, Type=%d, Name=\"%.*S\", Data=",
                    ent->args[*pbytes_used/4+2],
                    ent->args[*pbytes_used/4+3],
                    ent->args[*pbytes_used/4+6]/2,
                    &(ent->args[*pbytes_used/4+7]));
            print_buffer_as_bytes (((char *)&(ent->args[*pbytes_used/4+2]))+
                                   ent->args[*pbytes_used/4+4],
                                   ent->args[*pbytes_used/4+5]);
            fprintf (output, "}, ");
            break;

        case 2:  /* Partial */
            fprintf (output, "TitleIdx=%d, Type=%d, Data=",
                    ent->args[*pbytes_used/4+2],
                    ent->args[*pbytes_used/4+3],
                    &(ent->args[*pbytes_used/4+5]));
            print_buffer_as_bytes ((unsigned char*)&(ent->args[*pbytes_used/4+5]),
                                   ent->args[*pbytes_used/4+4]);
            fprintf (output, "}, ");
            break;

        case 3:  /* FullAlign64 */
            break;

        default:
            fprintf (output, "{key value info, class %d, size %d}, ",
                    info_class, buf_size);
            break;
        }
        *pbytes_used += buf_size + 8;
        *pbytes_used = ((*pbytes_used +3)/4) * 4;
    }
}

void
copy_arg_PLARGE_UNICODE_STRING (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int len;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        len = ent->args[*pbytes_used/4];
        *pbytes_used += 12;

        if (ent->args[*pbytes_used/4] == -1) {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
            *pbytes_used += 8;
        } else {
            *pbytes_used += 4;
            fwprintf (output, L"\"%.*s\", ", len/2, &ent->args[*pbytes_used/4]);
            *pbytes_used += ((len +3) / 4) * 4;
        }
    }
}

void
copy_arg_PMSG (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    
    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        fprintf (output, "{0x%x, %s, 0x%x, 0x%x, 0x%x, {%d, %d}}, ",
                ent->args[*pbytes_used/4+0],
                lookup_winmsg (ent->args[*pbytes_used/4+1]),
                ent->args[*pbytes_used/4+2],
                ent->args[*pbytes_used/4+3],
                ent->args[*pbytes_used/4+4],
                ent->args[*pbytes_used/4+5],
                ent->args[*pbytes_used/4+6]);
        *pbytes_used += 28;
    }
}

void
copy_arg_HWND (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;

    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

void
copy_arg_PWINDOW_TEXT (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned long len;
    
    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        len = ent->args[*pbytes_used/4];
        *pbytes_used += 4;
        fwprintf (output, L"\"%.*s\", ", len/2,
                 &ent->args[*pbytes_used/4]);
        *pbytes_used += ((len + 3) /4) * 4;
    }
}

void
copy_arg_WINMSG (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    
    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "%s, ", lookup_winmsg (ent->args[*pbytes_used/4]));
        *pbytes_used += 4;
    }
}

void
copy_arg_WPARAM (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    
    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

void
copy_arg_LPARAM (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    
    if (ent->args_size >= *pbytes_used + 4) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4]);
        *pbytes_used += 4;
    }
}

void
copy_arg_PHWND_LIST (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int len;
    unsigned int i;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        len = ent->args[*pbytes_used/4];
        *pbytes_used += 4;

        fprintf (output, "(");
        for (i=0; i<len/4; i++) {
            fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + i]);
        }
        fprintf (output, "), ");
        *pbytes_used += len;
    }
}


void
copy_arg_PHANDLES (void *e, DWORD arg)
{
    ENTRY *ent = (ENTRY *)e;
    unsigned int *pbytes_used = (unsigned int *) arg;
    unsigned int len;
    unsigned int i;

    if (ent->args[*pbytes_used/4] == -1) {
        fprintf (output, "0x%x, ", ent->args[*pbytes_used/4 + 1]);
        *pbytes_used += 8;
    } else {
        *pbytes_used += 4;
        len = ent->args[*pbytes_used/4];
        *pbytes_used += 4;

        fprintf (output, "(");
        for (i=0; i<len/4; i++) {
            fprintf (output, "%d, ", ent->args[*pbytes_used/4 + i]);
        }
        fprintf (output, "), ");
        *pbytes_used += len;
    }
}



