/*
 * This is really a C file that's needed by both the app and the driver.
 * So they just include it from one file instead of having two copies.
 * Yuk.
 */
#define MagicFoo(call,args) struct arg_info arg_info_##call##_##args = { args/4 };
#include "syscallx.h"
#undef MagicFoo



struct arg_info *all_arg_info[] = {
#define MagicFoo(call,args) &arg_info_##call##_##args,
#include "syscallx.h"
#undef MagicFoo
};


enum all_types {
#define MagicFoo(type) typ_##type,
#include "typesx.h"
#undef MagicFoo
};


/*
 * Ok.  This is the disgustingly detailed stuff that can't be
 * solved with the preprocessor.  The type info for every syscall
 * needs to be specified, and there's no rhyme or reason to them.
 * The "default" (by virtue of what 0 means) for everything is to
 * be of type DWORD, with IN direction.  Anything other than that
 * needs to be specified here.
 *
 * Also, not every system call is fully understood, either.
 *
 * Actually, see http://www.amazon.com/exec/obidos/ASIN/1578701996
 * for surprisingly complete documentation.
 */

/*
 * Hmmm, maybe the preprocessor _can_ help some. ;)
 */
#define set_arg(a,t,d) \
    all_arg_info[call]->args[a].type = t; \
    all_arg_info[call]->args[a].dir  = d;

void
init_arg_info (void)
{
#if 1
    int call;

    call = NtAcceptConnectPort_24;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (2, typ_PLPC_MESSAGE, DIR_IN);
    set_arg (4, typ_PLPC_SECTIONINFO, DIR_IN_OUT);  /* FIXME: really just DIR_IN I think, but I'm curious */
    set_arg (5, typ_PLPC_SECTIONMAPINFO, DIR_IN_OUT);  /* FIXME: really just DIR_IN I think, but I'm curious */

    call = NtAccessCheck_32;
    set_arg (2, typ_ACCESS_MASK, DIR_IN);
    set_arg (5, typ_PDWORD, DIR_IN);
    set_arg (6, typ_PDWORDx, DIR_OUT);  /* FIXME: actually PACCESS_MASK */
    
    call = NtAccessCheckAndAuditAlarm_44;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);
    set_arg (2, typ_PUNICODE_STRING, DIR_IN);
    set_arg (3, typ_PUNICODE_STRING, DIR_IN);
    set_arg (5, typ_ACCESS_MASK, DIR_IN);
    
    call = NtAddAtom_12;
    set_arg (0, typ_PVOID_BUFF, DIR_IN);
    all_arg_info[call]->args[0].buf_len_arg = 1;
    all_arg_info[call]->args[0].use_len_arg = -1;
    
    call = NtAlertResumeThread_8;
    set_arg (1, typ_PDWORD, DIR_OUT);
    
    call = NtAllocateLocallyUniqueId_4;
    set_arg (0, typ_PLUID, DIR_OUT);

    call = NtAllocateVirtualMemory_24;
    set_arg (1, typ_PDWORD, DIR_IN_OUT);
    set_arg (3, typ_PDWORD, DIR_IN_OUT);

    call = NtAreMappedFilesTheSame_8;
    set_arg (0, typ_DWORDx, DIR_IN);
    set_arg (1, typ_DWORDx, DIR_IN);

    call = NtCancelIoFile_8;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);

    call = NtClose_4;
    set_arg (0, typ_HANDLE, DIR_IN);

    call = NtCloseObjectAuditAlarm_12;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);

    call = NtConnectPort_32;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);
    set_arg (2, typ_PSECURITY_QOS, DIR_IN);
    set_arg (3, typ_PLPC_SECTIONINFO, DIR_IN_OUT);
    set_arg (4, typ_PLPC_SECTIONMAPINFO, DIR_IN_OUT);
    set_arg (5, typ_PDWORD, DIR_OUT);
    set_arg (7, typ_PDWORD, DIR_IN_OUT);

    call = NtCreateDirectoryObject_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateEvent_20;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateEventPair_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateFile_44;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (4, typ_PLARGE_INTEGER, DIR_IN);

    call = NtCreateIoCompletion_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateJobObject_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateKey_28;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (4, typ_PUNICODE_STRING, DIR_IN);
    set_arg (6, typ_PDWORD, DIR_OUT);

    call = NtCreateMailslotFile_32;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (7, typ_PLARGE_INTEGER, DIR_IN);

    call = NtCreateMutant_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateNamedPipeFile_56;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (13, typ_PLARGE_INTEGER, DIR_IN);

    call = NtCreatePagingFile_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);

    call = NtCreatePort_20;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateProcess_32;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateProfile_36;
    set_arg (0, typ_PHANDLE, DIR_OUT);

    call = NtCreateSection_28;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PLARGE_INTEGER, DIR_IN);

    call = NtCreateSemaphore_20;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateSymbolicLinkObject_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PUNICODE_STRING, DIR_IN);

    call = NtCreateThread_32;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (4, typ_PCLIENT_ID, DIR_OUT);

    call = NtCreateTimer_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtCreateToken_52;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (4, typ_PLUID, DIR_IN);
    set_arg (5, typ_PLARGE_INTEGER, DIR_IN);

    call = NtCreateWaitablePort_20;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_POBJ_ATTRIB, DIR_IN);

    call = NtDelayExecution_8;
    set_arg (1, typ_PLARGE_INTEGER, DIR_IN);

    call = NtDeleteFile_4;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);

    call = NtDeleteObjectAuditAlarm_12;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);

    call = NtDeleteValueKey_8;
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);

    call = NtDeviceIoControlFile_40;
    set_arg (2, typ_DWORDx, DIR_IN);
    set_arg (3, typ_DWORDx, DIR_IN);
    set_arg (4, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (5, typ_DWORDx, DIR_IN);
    set_arg (6, typ_PVOID_BUFF, DIR_IN);
    all_arg_info[call]->args[6].buf_len_arg = 7;
    all_arg_info[call]->args[6].use_len_arg = -1;
    set_arg (8, typ_PVOID_WITH_IO_BUFF, DIR_OUT);
    all_arg_info[call]->args[8].buf_len_arg = 9;
    all_arg_info[call]->args[8].use_len_arg = 4;

    call = NtDuplicateObject_28;
    set_arg (3, typ_PHANDLE, DIR_OUT);
    set_arg (4, typ_ACCESS_MASK, DIR_IN);

    call = NtDuplicateToken_24;
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (5, typ_PHANDLE, DIR_OUT);

    call = NtEnumerateKey_24;
    set_arg (2, typ_KEY_INFO_CLASS, DIR_IN);
    set_arg (3, typ_PKEY_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[3].info_arg = 2;
    all_arg_info[call]->args[3].buf_len_arg = 4;
    all_arg_info[call]->args[3].use_len_arg = 5;
    all_arg_info[call]->args[3].use_len_dir = DIR_OUT;
    set_arg (5, typ_PDWORD, DIR_OUT);

    call = NtEnumerateValueKey_24;
    set_arg (2, typ_KEY_VALUE_INFO_CLASS, DIR_IN);
    set_arg (3, typ_PKEY_VALUE_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[3].info_arg = 2;
    all_arg_info[call]->args[3].buf_len_arg = 4;
    all_arg_info[call]->args[3].use_len_arg = 5;
    all_arg_info[call]->args[3].use_len_dir = DIR_OUT;
    set_arg (5, typ_PDWORD, DIR_OUT);

    call = NtExtendSection_8;
    set_arg (1, typ_PLARGE_INTEGER, DIR_IN);

    call = NtFilterToken_24;
    set_arg (5, typ_PHANDLE, DIR_OUT);

    call = NtFindAtom_12;
    set_arg (0, typ_PVOID_BUFF, DIR_IN);
    all_arg_info[call]->args[0].buf_len_arg = 1;
    all_arg_info[call]->args[0].use_len_arg = -1;
    
    call = NtFlushBuffersFile_8;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);

    call = NtFlushVirtualMemory_16;
    set_arg (1, typ_PDWORDx, DIR_IN_OUT);
    set_arg (2, typ_PDWORD, DIR_IN_OUT);
    set_arg (3, typ_PIO_STATUS_BLOCK, DIR_OUT);

    call = NtFreeVirtualMemory_16;
    set_arg (1, typ_PDWORDx, DIR_IN_OUT);
    set_arg (2, typ_PDWORD, DIR_IN_OUT);

    call = NtFsControlFile_40;
    set_arg (2, typ_DWORDx, DIR_IN);
    set_arg (3, typ_DWORDx, DIR_IN);
    set_arg (4, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (5, typ_DWORDx, DIR_IN);
    set_arg (6, typ_PVOID_BUFF, DIR_IN);
    all_arg_info[call]->args[6].buf_len_arg = 7;
    all_arg_info[call]->args[6].use_len_arg = -1;
    set_arg (8, typ_PVOID_WITH_IO_BUFF, DIR_OUT);
    all_arg_info[call]->args[8].buf_len_arg = 9;
    all_arg_info[call]->args[8].use_len_arg = 4;

    call = NtImpersonateClientOfPort_8;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN);

    call = NtImpersonateThread_12;
    set_arg (2, typ_PSECURITY_QOS, DIR_IN);

    call = NtListenPort_8;
    set_arg (1, typ_PLPC_MESSAGE, DIR_OUT);

    call = NtLoadDriver_4;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);

    call = NtLoadKey_8;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (1, typ_POBJ_ATTRIB, DIR_IN);

    call = NtLoadKey2_12;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (1, typ_POBJ_ATTRIB, DIR_IN);

    call = NtLockFile_40;
    set_arg (4, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (5, typ_PLARGE_INTEGER, DIR_IN); /* FIXME: technically, this and the next are PULARGE_INTEGER */
    set_arg (6, typ_PLARGE_INTEGER, DIR_IN);

    call = NtLockVirtualMemory_16;
    set_arg (1, typ_PDWORDx, DIR_IN_OUT);
    set_arg (2, typ_PDWORD, DIR_IN_OUT);

    call = NtMapViewOfSection_40;
    set_arg (2, typ_PDWORDx, DIR_IN_OUT);
    set_arg (5, typ_PLARGE_INTEGER, DIR_IN_OUT);
    set_arg (6, typ_PDWORD, DIR_IN_OUT);

    call = NtNotifyChangeMultipleKeys_48;
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenDirectoryObject_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenEvent_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenEventPair_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenFile_24;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PIO_STATUS_BLOCK, DIR_OUT);

    call = NtOpenIoCompletion_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenJobObject_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenKey_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenKeyedEvent_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenMutant_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenObjectAuditAlarm_48;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);
    set_arg (2, typ_PUNICODE_STRING, DIR_IN);
    set_arg (3, typ_PUNICODE_STRING, DIR_IN);
    set_arg (6, typ_ACCESS_MASK, DIR_IN);
    set_arg (7, typ_ACCESS_MASK, DIR_IN);

    call = NtOpenProcess_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PCLIENT_ID, DIR_IN);

    call = NtOpenProcessToken_12;
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_PHANDLE, DIR_OUT);

    call = NtOpenProcessTokenEx_16;
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (3, typ_PHANDLE, DIR_OUT);

    call = NtOpenSection_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenSemaphore_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenSymbolicLinkObject_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtOpenThread_16;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (3, typ_PCLIENT_ID, DIR_IN);

    call = NtOpenThreadToken_16;
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (3, typ_PHANDLE, DIR_OUT);

    call = NtOpenThreadTokenEx_20;
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (4, typ_PHANDLE, DIR_OUT);

    call = NtOpenTimer_12;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtPrivilegedServiceAuditAlarm_20;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);

    call = NtPrivilegeObjectAuditAlarm_24;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);
    set_arg (3, typ_ACCESS_MASK, DIR_IN);

    call = NtProtectVirtualMemory_20;
    set_arg (1, typ_PDWORDx, DIR_IN_OUT);
    set_arg (2, typ_PDWORD, DIR_IN_OUT);
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtPulseEvent_8;
    set_arg (1, typ_PDWORD, DIR_OUT);

    call = NtQueueApcThread_20;
    set_arg (1, typ_DWORDx, DIR_IN);
    set_arg (2, typ_DWORDx, DIR_IN);
    set_arg (3, typ_DWORDx, DIR_IN);
    set_arg (4, typ_DWORDx, DIR_IN);

    call = NtQueryAttributesFile_8;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);

    call = NtQueryDirectoryFile_44;
    set_arg (4, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (7, typ_FILE_INFO_CLASS, DIR_IN);
    set_arg (9, typ_PUNICODE_STRING, DIR_IN);

    call = NtQueryDirectoryObject_28;
    set_arg (5, typ_PHANDLE, DIR_IN_OUT);
    set_arg (6, typ_PHANDLE, DIR_OUT);

    call = NtQueryEvent_20;
    set_arg (1, typ_EVENT_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PEVENT_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryFullAttributesFile_8;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);

    call = NtQueryInformationFile_20;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (4, typ_FILE_INFO_CLASS, DIR_IN);

    call = NtQueryInformationJobObject_20;
    set_arg (1, typ_JOB_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PJOB_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryInformationProcess_20;
    set_arg (1, typ_PROCESS_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PPROCESS_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryInformationThread_20;
    set_arg (1, typ_THREAD_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PTHREAD_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryInformationToken_20;
    set_arg (1, typ_TOKEN_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PTOKEN_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryKey_20;
    set_arg (1, typ_KEY_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PKEY_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryMutant_20;
    set_arg (1, typ_MUTANT_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PMUTANT_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryObject_20;
    set_arg (1, typ_OBJECT_INFO_CLASS, DIR_IN);
    set_arg (2, typ_POBJECT_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryOleDirectoryFile_44;
    set_arg (7, typ_FILE_INFO_CLASS, DIR_IN);
    set_arg (9, typ_PUNICODE_STRING, DIR_IN);

    call = NtQueryOpenSubKeys_8;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (1, typ_PDWORD, DIR_OUT);

    call = NtQueryPerformanceCounter_8;
    set_arg (0, typ_PLARGE_INTEGER, DIR_OUT);
    set_arg (1, typ_PLARGE_INTEGER, DIR_OUT);

    call = NtQuerySection_20;
    set_arg (1, typ_SECTION_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PSECTION_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQuerySecurityObject_20;
    set_arg (2, typ_PSECURITY_DESCRIPTOR, DIR_OUT);
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQuerySemaphore_20;
    set_arg (1, typ_SEMAPHORE_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PSEMAPHORE_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQuerySymbolicLinkObject_12;
    set_arg (1, typ_PUNICODE_STRING, DIR_OUT);
    set_arg (2, typ_PHANDLE, DIR_OUT);

    call = NtQuerySystemEnvironmentValue_16;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);

    call = NtQuerySystemInformation_16;
    set_arg (0, typ_SYSTEM_INFO_CLASS, DIR_IN);
    set_arg (1, typ_PSYSTEM_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[1].info_arg = 0;
    all_arg_info[call]->args[1].buf_len_arg = 2;
    all_arg_info[call]->args[1].use_len_arg = 3;
    all_arg_info[call]->args[1].use_len_dir = DIR_OUT;
    set_arg (3, typ_PDWORD, DIR_OUT);

    call = NtQuerySystemTime_4;
    set_arg (0, typ_PLARGE_INTEGER, DIR_OUT);

    call = NtQueryTimer_20;
    set_arg (1, typ_TIMER_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PTIMER_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    all_arg_info[call]->args[2].use_len_dir = DIR_OUT;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtQueryTimerResolution_12;
    set_arg (0, typ_PDWORD, DIR_OUT);
    set_arg (1, typ_PDWORD, DIR_OUT);
    set_arg (2, typ_PDWORD, DIR_OUT);

    call = NtQueryValueKey_24;
    set_arg (0, typ_HANDLE, DIR_IN);
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);
    set_arg (2, typ_KEY_VALUE_INFO_CLASS, DIR_IN);
    set_arg (3, typ_PKEY_VALUE_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[3].info_arg = 2;
    all_arg_info[call]->args[3].buf_len_arg = 4;
    all_arg_info[call]->args[3].use_len_arg = 5;
    all_arg_info[call]->args[3].use_len_dir = DIR_OUT;
    set_arg (5, typ_PDWORD, DIR_OUT);

    call = NtQueryVirtualMemory_24;
    set_arg (1, typ_DWORDx, DIR_IN);
    set_arg (2, typ_MEMORY_INFO_CLASS, DIR_IN);
    set_arg (3, typ_PMEMORY_INFO_BUFF, DIR_OUT);
    all_arg_info[call]->args[3].info_arg = 2;
    all_arg_info[call]->args[3].buf_len_arg = 4;
    all_arg_info[call]->args[3].use_len_arg = 5;
    all_arg_info[call]->args[3].use_len_dir = DIR_OUT;
    set_arg (5, typ_PDWORD, DIR_OUT);

    call = NtQueryVolumeInformationFile_20;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (4, typ_FS_INFO_CLASS, DIR_IN);

    call = NtReadFile_36;
    set_arg (0, typ_HANDLE, DIR_IN);
    set_arg (1, typ_HANDLE, DIR_IN);
    set_arg (4, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (5, typ_PVOID_WITH_IO_BUFF, DIR_OUT);
    all_arg_info[call]->args[5].buf_len_arg = 6;
    all_arg_info[call]->args[5].use_len_arg = 4;
    set_arg (7, typ_PLARGE_INTEGER, DIR_IN);

    call = NtReadVirtualMemory_20;
    set_arg (1, typ_DWORDx, DIR_IN);
    set_arg (2, typ_PVOID_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = 4;
    set_arg (4, typ_PDWORD, DIR_OUT);

    call = NtReadRequestData_24;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN);
    set_arg (3, typ_PVOID_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].buf_len_arg = 4;
    all_arg_info[call]->args[2].use_len_arg = 5;
    set_arg (5, typ_PDWORD, DIR_OUT);

    call = NtReleaseMutant_8;
    set_arg (1, typ_PDWORD, DIR_OUT);

    call = NtReleaseSemaphore_12;
    set_arg (2, typ_PDWORD, DIR_OUT);

    call = NtRemoveIoCompletion_20;
    set_arg (1, typ_PDWORD, DIR_OUT);
    set_arg (2, typ_PDWORD, DIR_OUT);
    set_arg (3, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (4, typ_PLARGE_INTEGER, DIR_IN);

    call = NtReplaceKey_12;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (2, typ_POBJ_ATTRIB, DIR_IN);

    call = NtReplyPort_8;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN);

    call = NtReplyWaitReceivePort_16;
    set_arg (1, typ_PDWORD, DIR_OUT);
    set_arg (2, typ_PLPC_MESSAGE, DIR_IN);
    set_arg (3, typ_PLPC_MESSAGE, DIR_OUT);

    call = NtReplyWaitReceivePortEx_20;
    set_arg (1, typ_PDWORD, DIR_OUT);
    set_arg (2, typ_PLPC_MESSAGE, DIR_IN);
    set_arg (3, typ_PLPC_MESSAGE, DIR_OUT);
    set_arg (4, typ_PLARGE_INTEGER, DIR_IN);

    call = NtReplyWaitReplyPort_8;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN_OUT);

    call = NtRequestPort_8;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN);
    
    call = NtRequestWaitReplyPort_12;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN);
    set_arg (2, typ_PLPC_MESSAGE, DIR_OUT);
    
    call = NtResetEvent_8;
    set_arg (1, typ_PDWORD, DIR_OUT);

    call = NtResumeThread_8;
    set_arg (1, typ_PDWORD, DIR_OUT);
    
    call = NtSecureConnectPort_36;
    set_arg (0, typ_PHANDLE, DIR_OUT);
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);
    set_arg (2, typ_PSECURITY_QOS, DIR_IN);
    set_arg (3, typ_PLPC_SECTIONINFO, DIR_IN_OUT);
    set_arg (5, typ_PLPC_SECTIONMAPINFO, DIR_IN_OUT);
    set_arg (6, typ_PDWORD, DIR_OUT);
    set_arg (8, typ_PDWORD, DIR_IN_OUT);

    call = NtSetEvent_8;
    set_arg (1, typ_PDWORD, DIR_OUT);

    call = NtSetInformationFile_20;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (4, typ_FILE_INFO_CLASS, DIR_IN);

    call = NtSetInformationJobObject_16;
    set_arg (1, typ_JOB_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PJOB_INFO_BUFF, DIR_IN);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = -1;

    call = NtSetInformationKey_16;
    set_arg (1, typ_KEY_INFO_CLASS, DIR_IN);

    call = NtSetInformationObject_16;
    set_arg (1, typ_OBJECT_INFO_CLASS, DIR_IN);
    set_arg (2, typ_POBJECT_INFO_BUFF, DIR_IN);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = -1;

    call = NtSetInformationProcess_16;
    set_arg (1, typ_PROCESS_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PPROCESS_INFO_BUFF, DIR_IN);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = -1;

    call = NtSetInformationThread_16;
    set_arg (1, typ_THREAD_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PTHREAD_INFO_BUFF, DIR_IN);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = -1;

    call = NtSetInformationToken_16;
    set_arg (1, typ_TOKEN_INFO_CLASS, DIR_IN);
    set_arg (2, typ_PTOKEN_INFO_BUFF, DIR_IN);
    all_arg_info[call]->args[2].info_arg = 1;
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = -1;

    call = NtSetSecurityObject_12;
    set_arg (2, typ_PSECURITY_DESCRIPTOR, DIR_IN);

    call = NtSetSystemEnvironmentValue_8;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);

    call = NtSetSystemInformation_12;
    set_arg (0, typ_SYSTEM_INFO_CLASS, DIR_IN);
    set_arg (1, typ_PSYSTEM_INFO_BUFF, DIR_IN);
    all_arg_info[call]->args[1].info_arg = 0;
    all_arg_info[call]->args[1].buf_len_arg = 2;
    all_arg_info[call]->args[1].use_len_arg = -1;
    set_arg (2, typ_DWORD, DIR_IN);

    call = NtSetSystemTime_8;
    set_arg (0, typ_PLARGE_INTEGER, DIR_IN);
    set_arg (1, typ_PLARGE_INTEGER, DIR_OUT);

    call = NtSetTimer_28;
    set_arg (1, typ_PLARGE_INTEGER, DIR_IN);
    set_arg (2, typ_DWORDx, DIR_IN);
    set_arg (3, typ_DWORDx, DIR_IN);

    call = NtSetTimerResolution_12;
    set_arg (2, typ_PDWORD, DIR_OUT);

    call = NtSetValueKey_24;
    set_arg (0, typ_HANDLE, DIR_IN);
    set_arg (1, typ_PUNICODE_STRING, DIR_IN);
    set_arg (4, typ_PVOID_BUFF, DIR_IN);
    all_arg_info[call]->args[4].buf_len_arg = 5;
    all_arg_info[call]->args[4].use_len_arg = -1;

    call = NtSetVolumeInformationFile_20;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (4, typ_FS_INFO_CLASS, DIR_IN);

    call = NtSignalAndWaitForSingleObject_16;
    set_arg (3, typ_PLARGE_INTEGER, DIR_IN);

    call = NtSuspendThread_8;
    set_arg (1, typ_PDWORD, DIR_OUT);
    
    call = NtUnloadDriver_4;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);

    call = NtUnloadKey_4;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);

    call = NtUnlockFile_20;
    set_arg (1, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (2, typ_PLARGE_INTEGER, DIR_IN); /* FIXME: technically, this and the next are PULARGE_INTEGER */
    set_arg (3, typ_PLARGE_INTEGER, DIR_IN);

    call = NtUnlockVirtualMemory_16;
    set_arg (1, typ_PDWORDx, DIR_IN_OUT);
    set_arg (2, typ_PDWORD, DIR_IN_OUT);

    call = NtUnmapViewOfSection_8;
    set_arg (1, typ_DWORDx, DIR_IN);

    call = NtUserBeginPaint_8;
    set_arg (0, typ_HWND, DIR_IN);

    call = NtUserBuildHwndList_28;
    set_arg (5, typ_PHWND_LIST, DIR_OUT);
    all_arg_info[call]->args[5].buf_len_arg = 4;
    all_arg_info[call]->args[5].use_len_arg = 6;
    set_arg (6, typ_PDWORD, DIR_OUT);

    call = NtUserCreateWindowEx_52;
    set_arg (2, typ_PLARGE_UNICODE_STRING, DIR_IN);

    call = NtUserCreateWindowEx_60;
    set_arg (3, typ_PLARGE_UNICODE_STRING, DIR_IN);

    call = NtUserDispatchMessage_4;
    set_arg (0, typ_PMSG, DIR_IN);

    call = NtUserEndPaint_8;
    set_arg (0, typ_HWND, DIR_IN);

    call = NtUserFindWindowEx_20;
    set_arg (2, typ_PUNICODE_STRING, DIR_IN);
    set_arg (3, typ_PUNICODE_STRING, DIR_IN);

    call = NtUserGetControlBrush_12;
    set_arg (0, typ_HWND, DIR_IN);

    call = NtUserGetMessage_16;
    set_arg (0, typ_PMSG, DIR_OUT);

    call = NtUserHideCaret_4;
    set_arg (0, typ_HWND, DIR_IN);

    call = NtUserInternalGetWindowText_12;
    set_arg (0, typ_HWND, DIR_IN);
    set_arg (1, typ_PWINDOW_TEXT, DIR_OUT);
    all_arg_info[call]->args[1].buf_len_arg = 2;
    all_arg_info[call]->args[1].use_len_arg = -2;

    call = NtUserMessageCall_28;
    set_arg (0, typ_HWND, DIR_IN);
    set_arg (1, typ_WINMSG, DIR_IN);
    set_arg (2, typ_WPARAM, DIR_IN);
    set_arg (3, typ_LPARAM, DIR_IN);

    call = NtUserOpenDesktop_12;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (2, typ_ACCESS_MASK, DIR_IN);

    call = NtUserOpenWindowStation_8;
    set_arg (0, typ_POBJ_ATTRIB, DIR_IN);
    set_arg (1, typ_ACCESS_MASK, DIR_IN);

    call = NtUserPeekMessage_20;
    set_arg (0, typ_PMSG, DIR_OUT);

    call = NtUserRegisterWindowMessage_4;
    set_arg (0, typ_PUNICODE_STRING, DIR_IN);

    call = NtUserShowCaret_4;
    set_arg (0, typ_HWND, DIR_IN);

    call = NtWaitForMultipleObjects_20;
    set_arg (1, typ_PHANDLES, DIR_IN);
    all_arg_info[call]->args[1].buf_len_arg = 0;
    all_arg_info[call]->args[1].use_len_arg = -1;
    set_arg (4, typ_PLARGE_INTEGER, DIR_IN);

    call = NtWaitForSingleObject_12;
    set_arg (2, typ_PLARGE_INTEGER, DIR_IN);

    call = NtWriteFile_36;
    set_arg (4, typ_PIO_STATUS_BLOCK, DIR_OUT);
    set_arg (5, typ_PVOID_WITH_IO_BUFF, DIR_IN);
    all_arg_info[call]->args[5].buf_len_arg = 6;
    all_arg_info[call]->args[5].use_len_arg = -1;
    set_arg (7, typ_PLARGE_INTEGER, DIR_IN);

    call = NtWriteRequestData_24;
    set_arg (1, typ_PLPC_MESSAGE, DIR_IN);
    set_arg (3, typ_PVOID_BUFF, DIR_OUT);
    all_arg_info[call]->args[2].buf_len_arg = 4;
    all_arg_info[call]->args[2].use_len_arg = -1;
    set_arg (5, typ_PDWORD, DIR_OUT);

    call = NtWriteVirtualMemory_20;
    set_arg (1, typ_DWORDx, DIR_IN);
    set_arg (2, typ_PVOID_BUFF, DIR_IN);
    all_arg_info[call]->args[2].buf_len_arg = 3;
    all_arg_info[call]->args[2].use_len_arg = -1;
    set_arg (4, typ_PDWORD, DIR_OUT);

#endif
}
#undef set_arg
