/*
 * filter.c
 * 
 * Copyright (c) 2000, BindView Corporation.
 *
 * See LICENSE file.
 *
 * filter system calls of a process (or all processes)
 */

#include "syscalls.h"
#include "ioctlcmd.h"

/*
 * Which calls to trace.  Defaults to everything on.
 */
#define MagicFoo(call,args)  1,
unsigned char do_trace[] = {
#include "syscallx.h"
};
#undef MagicFoo


/*
 * Definitions of system call groups
 */
static int all_calls[] = {
#define MagicFoo(call,args)  call##_##args,
#include "syscallx.h"
#undef MagicFoo
};

static int ntos_calls[] = {
#define MagicFoo(call,args)  call##_##args,
#include "filt_ntosx.h"
#undef MagicFoo
};

static int win32k_calls[] = {
#define MagicFoo(call,args)  call##_##args,
#include "filt_win32kx.h"
#undef MagicFoo
};

static int system_calls[] = {
#define MagicFoo(call,args)  call##_##args,
#include "filt_systemx.h"
#undef MagicFoo
};

static int object_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_objectx.h"
#undef MagicFoo
};

static int memory_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_memoryx.h"
#undef MagicFoo
};

static int section_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_sectionx.h"
#undef MagicFoo
};

static int thread_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_threadx.h"
#undef MagicFoo
};

static int process_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_processx.h"
#undef MagicFoo
};

static int job_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_jobx.h"
#undef MagicFoo
};

static int token_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_tokenx.h"
#undef MagicFoo
};

static int synch_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_synchx.h"
#undef MagicFoo
};

static int time_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_timex.h"
#undef MagicFoo
};

static int profile_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_profilex.h"
#undef MagicFoo
};

static int port_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_portx.h"
#undef MagicFoo
};

static int file_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_filex.h"
#undef MagicFoo
};

static int key_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_keyx.h"
#undef MagicFoo
};

static int security_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_securityx.h"
#undef MagicFoo
};

static int misc_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_miscx.h"
#undef MagicFoo
};

static int ntuser_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_ntuserx.h"
#undef MagicFoo
};

static int ntgdi_calls[] = {
#define MagicFoo(call,args) call##_##args,
#include "filt_ntgdix.h"
#undef MagicFoo
};


static struct {
    int *calls;
    int num;
} filter_groups[] = {
#define FOO(a) { a, (sizeof (a) / sizeof (a[0])) },
FOO (all_calls)
FOO (ntos_calls)
FOO (win32k_calls)
FOO (system_calls)
FOO (object_calls)
FOO (memory_calls)
FOO (section_calls)
FOO (thread_calls)
FOO (process_calls)
FOO (job_calls)
FOO (token_calls)
FOO (synch_calls)
FOO (time_calls)
FOO (profile_calls)
FOO (port_calls)
FOO (file_calls)
FOO (key_calls)
FOO (security_calls)
FOO (misc_calls)
FOO (ntuser_calls)
FOO (ntgdi_calls)
};


unsigned int
set_filter (unsigned int filter)
{
    int setting = (filter & FILTER_ON) >> 31;
    int group   = filter & FILTER_GROUP;

    filter &= 0x3fffffff;

    if (group) {
        if (filter < (sizeof (filter_groups) / sizeof (filter_groups[0]))) {
            int i;
            for (i=0; i < filter_groups[filter].num; i++) {
                do_trace[filter_groups[filter].calls[i]] = setting;
            }
        } else {
            return -1;
        }
    } else {
        if (filter < (sizeof (do_trace) / sizeof (do_trace[0]))) {
            do_trace[filter] = setting;
        } else {
            return -1;
        }
    }
    return 0;
}
