/*
 * hooks.c
 * 
 * Copyright (c) 2000, BindView Corporation.
 *
 * See LICENSE file.
 *
 */

#include <ntddk.h>
#include <ioctlcmd.h>
#include "syscalls.h"
#include "driver.h"
#include "types.h"

extern unsigned long traced_pid;
extern unsigned long ignored_pid;
extern unsigned long call_count;
extern unsigned long calls_in_progress;
extern unsigned long inc (unsigned long *l);
extern void add_entry (ENTRY *sys_call);

typedef ULONG DWORD;

void
common_before (ENTRY *ent, enum syscall num, int *record, ULONG *args)
{
    ULONG pid = (ULONG) PsGetCurrentProcessId ();
    int i;

    InterlockedIncrement (&calls_in_progress);
    if ((traced_pid != 0 && pid != traced_pid)
        || (do_trace[num] == 0)
        || (ignored_pid && pid == ignored_pid)) {
        *record = 0;
    } else {
        *record = 1;
        ent->seq = inc (&call_count);
        ent->pid = (ULONG) PsGetCurrentProcessId ();
        ent->tid = (ULONG) PsGetCurrentThreadId ();
        ent->call_num = num;
        ent->direction = 0;
        ent->prev_mode = ExGetPreviousMode ();
        ent->result = 0;
        ent->args_size = 0;
        /*
         * Copy IN arguments
         */
        for (i=0; i< all_arg_info[num]->num; i++) {
            if ((all_arg_info[num]->args[i].dir == DIR_IN)
                || (all_arg_info[num]->args[i].dir == DIR_IN_OUT)) {
                /* call the proper handler for this type */
                all_types[all_arg_info[num]->args[i].type].copy_arg (ent, args, i);
            }
        }
        add_entry (ent);
    }
}

void
common_after (ENTRY *ent, NTSTATUS rc, int record, ULONG *args)
{
    int i;
    int num=ent->call_num;

    if (record) {
        ent->direction = 1;
        ent->result = rc;
        ent->args_size = 0;
        /*
         * Copy OUT arguments
         */
        if (rc >= 0) {
            for (i=0; i< all_arg_info[num]->num; i++) {
                if ((all_arg_info[num]->args[i].dir == DIR_OUT)
                    || (all_arg_info[num]->args[i].dir == DIR_IN_OUT)) {
                    /* call the proper handler for this type */
                    all_types[all_arg_info[num]->args[i].type].copy_arg (ent, args, i);
                }
            }
        }
        add_entry (ent);
    }
    InterlockedDecrement (&calls_in_progress);
}


/*
 * hold onto your preprocessor... this is gonna be hairy.
 */
#define ARGS_0() 
#define ARGS_4() arg1
#define ARGS_8() arg1, arg2
#define ARGS_12() arg1, arg2, arg3
#define ARGS_16() arg1, arg2, arg3, arg4
#define ARGS_20() arg1, arg2, arg3, arg4, arg5
#define ARGS_24() arg1, arg2, arg3, arg4, arg5, arg6
#define ARGS_28() arg1, arg2, arg3, arg4, arg5, arg6, arg7
#define ARGS_32() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8
#define ARGS_36() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9
#define ARGS_40() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10
#define ARGS_44() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11
#define ARGS_48() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12
#define ARGS_52() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13
#define ARGS_56() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14
#define ARGS_60() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15
#define ARGS_64() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16
#define ARGS_68() arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17

#define DECL_ARGS_0() ()
#define DECL_ARGS_4() (DWORD arg1)
#define DECL_ARGS_8() (DWORD arg1, DWORD arg2)
#define DECL_ARGS_12() (DWORD arg1, DWORD arg2, DWORD arg3)
#define DECL_ARGS_16() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4)
#define DECL_ARGS_20() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5)
#define DECL_ARGS_24() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6)
#define DECL_ARGS_28() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7)
#define DECL_ARGS_32() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8)
#define DECL_ARGS_36() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9)
#define DECL_ARGS_40() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10)
#define DECL_ARGS_44() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11)
#define DECL_ARGS_48() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12)
#define DECL_ARGS_52() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13)
#define DECL_ARGS_56() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14)
#define DECL_ARGS_60() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14, DWORD arg15)
#define DECL_ARGS_64() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14, DWORD arg15, DWORD arg16)
#define DECL_ARGS_68() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14, DWORD arg15, DWORD arg16, DWORD arg17)




#define MagicFoo(call, args) \
NTSTATUS \
hook_##call##_##args DECL_ARGS_##args() \
{ \
    ENTRY ent; \
    NTSTATUS rc; \
    int record; \
    ULONG the_args[20] = { 0, ARGS_##args() }; \
 \
    common_before (&ent, call##_##args, &record, &the_args[1]); \
    rc = ((NTSTATUS (*)DECL_ARGS_##args()) all_syscalls[call##_##args].real) (ARGS_##args()); \
    common_after (&ent, rc, record, &the_args[1]); \
    return rc; \
}
#include "syscallx.h"
#undef MagicFoo





