/*
 * ioctlcmd.h
 * 
 * Copyright (c) 2000, BindView Corporation.
 *
 * See LICENSE file.
 *
 */


#ifndef IOCTLCMD_H
#define IOCTLCMD_H


#define FILE_DEVICE_STRACE      0x0000A32F

/*
 * actual ioctls
 */
#define STRACE_hook      (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x00, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define STRACE_unhook    (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x01, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define STRACE_getdata   (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x02, METHOD_NEITHER,  FILE_ANY_ACCESS )
#define STRACE_getout    (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x03, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define STRACE_getver    (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x04, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define STRACE_setfilter (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x05, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define STRACE_setignore (unsigned long) CTL_CODE( FILE_DEVICE_STRACE, 0x06, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define FILTER_ON    (0x80000000)
#define FILTER_OFF   (0x00000000)
#define FILTER_GROUP (0x40000000)

#define FILTER_all      (0)
#define FILTER_ntos     (1)
#define FILTER_win32k   (2)
#define FILTER_system   (3)
#define FILTER_object   (4)
#define FILTER_memory   (5)
#define FILTER_section  (6)
#define FILTER_thread   (7)
#define FILTER_process  (8)
#define FILTER_job      (9)
#define FILTER_token    (10)
#define FILTER_synch    (11)
#define FILTER_time     (12)
#define FILTER_profile  (13)
#define FILTER_port     (14)
#define FILTER_file     (15)
#define FILTER_key      (16)
#define FILTER_security (17)
#define FILTER_misc     (18)
#define FILTER_ntuser    (19)
#define FILTER_ntgdi    (20)

typedef struct {
    unsigned long seq;
    unsigned long pid;
    unsigned long tid;
    unsigned long call_num;
    unsigned short direction;
    unsigned short prev_mode;
    unsigned long result;
    unsigned long args_size;
    unsigned long args[256];
} ENTRY, *PENTRY;

#define ENT_SIZE(ent)  (sizeof (*ent) - sizeof (ent->args) + ent->args_size)

#define MAX_DATA (0x10000 - 12)

#endif
