/*
 * strace.c
 * 
 * Copyright (c) 2000, BindView Corporation.
 *
 * See LICENSE file.
 *
 */

#include "syscalls.h"

typedef unsigned long DWORD;

#define DECL_ARGS_0() (void)
#define DECL_ARGS_4() (DWORD arg1)
#define DECL_ARGS_8() (DWORD arg1, DWORD arg2)
#define DECL_ARGS_12() (DWORD arg1, DWORD arg2, DWORD arg3)
#define DECL_ARGS_16() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4)
#define DECL_ARGS_20() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5)
#define DECL_ARGS_24() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6)
#define DECL_ARGS_28() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7)
#define DECL_ARGS_32() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8)
#define DECL_ARGS_36() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9)
#define DECL_ARGS_40() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10)
#define DECL_ARGS_44() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11)
#define DECL_ARGS_48() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12)
#define DECL_ARGS_52() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13)
#define DECL_ARGS_56() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14)
#define DECL_ARGS_60() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14, DWORD arg15)
#define DECL_ARGS_64() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14, DWORD arg15, DWORD arg16)
#define DECL_ARGS_68() (DWORD arg1, DWORD arg2, DWORD arg3, DWORD arg4, DWORD arg5, DWORD arg6, DWORD arg7, DWORD arg8, DWORD arg9, DWORD arg10, DWORD arg11, DWORD arg12, DWORD arg13, DWORD arg14, DWORD arg15, DWORD arg16, DWORD arg17)

#define MagicFoo(call,args) extern struct arg_info arg_info_##call##_##args;
#include "syscallx.h"
#undef MagicFoo

#define MagicFoo(call,args) extern long hook_##call##_##args DECL_ARGS_##args();
#include "syscallx.h"
#undef MagicFoo

#define MagicFoo(call,args) { call##_##args, #call, hook_##call##_##args, 0, &arg_info_##call##_##args },
struct syscall_props all_syscalls[] = {
#include "syscallx.h"
};
#undef MagicFoo

/*
 * Define the different maps.  There's one for nt4-sp456 and one for nt5,
 * currently.
 */
#define MagicFoo(call,args) { call##_##args, hook_##call##_##args },

struct syscall_map nt4sp3_map[] = {
#include "sp3callx.h"
};
unsigned int nt4sp3_map_size;

struct syscall_map nt4sp3_win32k_map[] = {
#include "sp3w32callx.h"
};
unsigned int nt4sp3_win32k_map_size;

struct syscall_map nt4sp4_map[] = {
#include "sp456callx.h"
};
unsigned int nt4sp4_map_size;

struct syscall_map nt4sp45_win32k_map[] = {
#include "sp45w32callx.h"
};
unsigned int nt4sp45_win32k_map_size;

struct syscall_map nt4sp6_win32k_map[] = {
#include "sp6w32callx.h"
};
unsigned int nt4sp6_win32k_map_size;

struct syscall_map nt5_map[] = {
#include "nt5callx.h"
};
unsigned int nt5_map_size;

struct syscall_map nt5_win32k_map[] = {
#include "nt5w32callx.h"
};
unsigned int nt5_win32k_map_size;

struct syscall_map nt5_q328310_win32k_map[] = {
#include "nt5q328310w32callx.h"
};
unsigned int nt5_q328310_win32k_map_size;

struct syscall_map xp_map[] = {
#include "xpcallx.h"
};
unsigned int xp_map_size;

struct syscall_map xp_win32k_map[] = {
#include "xpw32callx.h"
};
unsigned int xp_win32k_map_size;

struct syscall_map xpsp1_win32k_map[] = {
#include "xpsp1w32callx.h"
};
unsigned int xpsp1_win32k_map_size;

struct syscall_map nt4termsp4_map[] = {
#include "nt4termsp4callx.h"
};
unsigned int nt4termsp4_map_size;

struct syscall_map nt4termsp4_win32k_map[] = {
#include "nt4termsp4w32callx.h"
};
unsigned int nt4termsp4_win32k_map_size;

struct syscall_map nt4termsp6_win32k_map[] = {
#include "nt4termsp6w32callx.h"
};
unsigned int nt4termsp6_win32k_map_size;



#undef MagicFoo


void
calc_map_sizes ()
{
    nt4sp3_map_size = sizeof (nt4sp3_map) / sizeof (nt4sp3_map[0]);
    nt4sp4_map_size = sizeof (nt4sp4_map) / sizeof (nt4sp4_map[0]);
    nt5_map_size = sizeof (nt5_map) / sizeof (nt5_map[0]);
    xp_map_size = sizeof (xp_map) / sizeof (xp_map[0]);
    nt4termsp4_map_size = sizeof (nt4termsp4_map) / sizeof (nt4termsp4_map[0]);
    nt4sp3_win32k_map_size = sizeof (nt4sp3_win32k_map) / sizeof (nt4sp3_win32k_map[0]);
    nt4sp45_win32k_map_size = sizeof (nt4sp45_win32k_map) / sizeof (nt4sp45_win32k_map[0]);
    nt4sp6_win32k_map_size = sizeof (nt4sp6_win32k_map) / sizeof (nt4sp6_win32k_map[0]);
    nt5_win32k_map_size = sizeof (nt5_win32k_map) / sizeof (nt5_win32k_map[0]);
    nt5_q328310_win32k_map_size = sizeof (nt5_q328310_win32k_map) / sizeof (nt5_q328310_win32k_map[0]);
    xp_win32k_map_size = sizeof (xp_win32k_map) / sizeof (xp_win32k_map[0]);
    xpsp1_win32k_map_size = sizeof (xpsp1_win32k_map) / sizeof (xpsp1_win32k_map[0]);
    nt4termsp4_win32k_map_size = sizeof (nt4termsp4_win32k_map) / sizeof (nt4termsp4_win32k_map[0]);
    nt4termsp6_win32k_map_size = sizeof (nt4termsp6_win32k_map) / sizeof (nt4termsp6_win32k_map[0]);
}
