/*
 * syscalls.h
 * 
 * Copyright (c) 2000, BindView Corporation.
 *
 * See LICENSE file.
 *
 * System call definitions.  Shared by kernel and user sides.
 *
 */

#ifndef SYSCALL_H
#define SYSCALL_H

typedef unsigned long DWORD;
/*
 * The calls for our purposes. (based on NT 4 SP4)
 *
 * Note that this is not necessarily the order that these appear in
 * the kernel's service table.  This is just for identifying kernel calls
 * within strace itself.
 */
#define MagicFoo(call,args) call##_##args,
enum syscall {
#include "syscallx.h"
};
#undef MagicFoo


#define DIR_IN      0
#define DIR_OUT     1
#define DIR_IN_OUT  2  /* used ? */


struct single_arg {
    unsigned short type;
    unsigned short dir;
    unsigned char info_arg;
    unsigned char buf_len_arg;
    unsigned char use_len_arg;
    unsigned char use_len_dir;
};


struct arg_info {
    int num;
    struct single_arg args[20];   /* big enough ? */
};

struct syscall_props {
    enum syscall num;
    char *       name;
    void *       hook;
    void *       real;
    struct arg_info *arg_info;
};

/*
 * kernel version specific mappings
 */
struct syscall_map {
    enum syscall fn;
    void *hook;
};

extern struct arg_info *all_arg_info[];

extern void init_arg_info (void);

extern struct syscall_props all_syscalls[];

extern struct syscall_map nt4sp3_map[];
extern unsigned int nt4sp3_map_size;
extern struct syscall_map nt4sp4_map[];
extern unsigned int nt4sp4_map_size;
extern struct syscall_map nt5_map[];
extern unsigned int nt5_map_size;
extern struct syscall_map xp_map[];
extern unsigned int xp_map_size;
extern struct syscall_map nt4termsp4_map[];
extern unsigned int nt4termsp4_map_size;
extern struct syscall_map nt4sp3_win32k_map[];
extern unsigned int nt4sp3_win32k_map_size;
extern struct syscall_map nt4sp45_win32k_map[];
extern unsigned int nt4sp45_win32k_map_size;
extern struct syscall_map nt4sp6_win32k_map[];
extern unsigned int nt4sp6_win32k_map_size;
extern struct syscall_map nt5_win32k_map[];
extern unsigned int nt5_win32k_map_size;
extern struct syscall_map nt5_q328310_win32k_map[];
extern unsigned int nt5_q328310_win32k_map_size;
extern struct syscall_map xp_win32k_map[];
extern unsigned int xp_win32k_map_size;
extern struct syscall_map xpsp1_win32k_map[];
extern unsigned int xpsp1_win32k_map_size;
extern struct syscall_map nt4termsp4_win32k_map[];
extern unsigned int nt4termsp4_win32k_map_size;
extern struct syscall_map nt4termsp6_win32k_map[];
extern unsigned int nt4termsp6_win32k_map_size;


#endif
