using System;

namespace vu.ch.argee.MemoryMapping
{
	/// <summary>
	/// Abstract interface of an unmanaged memory block
	/// </summary>
	public interface IUnmanagedMemory
	{
		/// <summary>
		/// Base address of the unmanaged memory block
		/// </summary>
		/// <value>The base address of the unmanaged memory block</value>
		IntPtr BaseAddress
		{
			get;
		}

		/// <summary>
		/// Length of the unmanaged memory block
		/// </summary>
		/// <value>The length of the unmanaged memory block</value>
		uint Length
		{
			get;
		}

		/// <summary>
		/// Defines if the unmanaged memory block is writable
		/// </summary>
		/// <value><b>true</b> if the IUnmanagedMemoryResource is writable.</value>
		bool CanWrite
		{
			get;
		}
	}

	/// <summary>
	/// Abstract interface of unmanaged memory resource
	/// </summary>
	/// <remarks>
	/// <para><b>Classes that Implement IUnmanagedMemoryResource</b></para>
	/// <list type="table">
	/// <listheader>
	/// <term>Class</term>
	/// <description>Description</description>
	/// </listheader>
	/// <item>
	/// <term><see cref="FileMappingView">FileMappingView</see></term>
	/// <description>
	/// Maps a part of a file (view) into the address space of the calling process.
	/// Use UnmanagedMemoryStream and BinaryReader/BinaryWriter 
	/// resp. any other StreamReader and StreamWriter
	/// classes to access the mapped memory.
	/// </description>
	/// </item>
	/// </list>
	/// </remarks>
	public interface IUnmanagedMemoryResource: IUnmanagedMemory, IDisposable 
	{
	}

	/// <summary>
	/// Abstract interface of a buffered resource
	/// </summary>
	public interface IBufferedResource: IDisposable
	{
		/// <summary>
		/// Flushes all buffers
		/// </summary>
		void Flush();
	}
}

