using System;
using System.Runtime.InteropServices;

namespace vu.ch.argee.WindowsAPI
{
	/// <summary>
	/// Imports functions of the Windows Plattform MemoryManagement API.
	/// </summary>
	public class MemoryManagementAPI
	{
		/// <summary>
		/// Constructor is private.
		/// </summary>
		private MemoryManagementAPI()
		{}

		/// <summary>
		/// Moves a block of memory from one location to another.
		/// </summary>
		/// <param name="destination">Pointer to the starting address of the move destination.</param>
		/// <param name="source">Pointer to the starting address of the block of memory to be moved.</param>
		/// <param name="Length">Size of the block of memory to move, in bytes.</param>
		[DllImport("kernel32", EntryPoint="RtlMoveMemory")]
		public static extern void MoveMemory(
			IntPtr destination,
			IntPtr source,
			uint Length
		);

		/// <summary>
		/// Moves a block of memory from one location to another.
		/// </summary>
		/// <param name="destination">Pointer to the starting address of the move destination.</param>
		/// <param name="source">Pointer to the starting address of the block of memory to be moved.</param>
		/// <param name="Length">Size of the block of memory to move, in bytes.</param>
		[DllImport("kernel32", EntryPoint="RtlMoveMemory")]
		public static extern void MoveMemory(
			uint destination,
			uint source,
			uint Length
			);

		/// <summary>
		/// Fills a block of memory with zeros.
		/// </summary>
		/// <param name="ptr">Pointer to the starting address of the block of memory to fill with zeros.</param>
		/// <param name="Length">Size of the block of memory to fill with zeros, in bytes.</param>
		[DllImport("KERNEL32.DLL", EntryPoint="RtlZeroMemory")]
		public static extern void SecureZeroMemory(
			IntPtr ptr,
			uint Length
			);

		/// <summary>
		/// Fills a block of memory with zeros.
		/// </summary>
		/// <param name="ptr">Pointer to the starting address of the block of memory to fill with zeros.</param>
		/// <param name="Length">Size of the block of memory to fill with zeros, in bytes.</param>
		[DllImport("KERNEL32.DLL", EntryPoint="RtlZeroMemory")]
		public static extern void SecureZeroMemory(
			uint ptr,
			uint Length
			);

		/// <summary>
		/// Fills a block of memory with a specified value.
		/// </summary>
		/// <param name="destination">Pointer to the starting address of the block of memory to fill.</param>
		/// <param name="Length">Size of the block of memory to fill, in bytes.</param>
		/// <param name="fillValue">Byte value with which to fill the memory block.</param>
		[DllImport("kernel32", EntryPoint="RtlFillMemory")]
		public static extern void FillMemory(
			IntPtr destination,
			uint Length,
			byte fillValue
			);

		/// <summary>
		/// Fills a block of memory with a specified value.
		/// </summary>
		/// <param name="destination">Pointer to the starting address of the block of memory to fill.</param>
		/// <param name="Length">Size of the block of memory to fill, in bytes.</param>
		/// <param name="fillValue">Byte value with which to fill the memory block.</param>
		[DllImport("kernel32", EntryPoint="RtlFillMemory")]
		public static extern void FillMemory(
			uint destination,
			uint Length,
			byte fillValue
			);
	}
}
