using System;
using System.IO;
using System.Runtime.InteropServices;

namespace vu.ch.argee.WindowsAPI
{
	// <summary>
	// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	// </summary>
	[Flags]
	internal enum FILE_ACCESS: uint
	{
		/// <summary>
		/// To be done.
		/// </summary>
		GENERIC_WRITE = 0x40000000,
		/// <summary>
		/// To be done.
		/// </summary>
		GENERIC_READ  = 0x80000000
	};

	// <summary>
	// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	// </summary>
	[Flags]
	internal enum FILE_SHARE: uint
	{
		/// <summary>
		/// To be done.
		/// </summary>
		READ   = 0x00000001,
		/// <summary>
		/// To be done.
		/// </summary>
		WRITE  = 0x00000002,
		/// <summary>
		/// To be done.
		/// </summary>
		DELETE = 0x00000004 
	}

	/// <summary>
	/// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	/// </summary>
	[Flags]
	internal enum FILE_MODE: uint
	{
		/// <summary>
		/// To be done.
		/// </summary>
		CREATE_NEW        = 1,
		/// <summary>
		/// To be done.
		/// </summary>
		CREATE_ALWAYS     = 2,
		/// <summary>
		/// To be done.
		/// </summary>
		OPEN_EXISTING     = 3,
		/// <summary>
		/// To be done.
		/// </summary>
		OPEN_ALWAYS       = 4,
		/// <summary>
		/// To be done.
		/// </summary>
		TRUNCATE_EXISTING = 5
	};

	/// <summary>
	/// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	/// </summary>
	[Flags]
	internal enum FILE_ATTRIBUTE: uint
	{
		/// <summary>
		/// To be done.
		/// </summary>
		READONLY            = 0x00000001,  
		/// <summary>
		/// To be done.
		/// </summary>
		HIDDEN              = 0x00000002,  
		/// <summary>
		/// To be done.
		/// </summary>
		SYSTEM              = 0x00000004,  
		/// <summary>
		/// To be done.
		/// </summary>
		DIRECTORY           = 0x00000010,  
		/// <summary>
		/// To be done.
		/// </summary>
		ARCHIVE             = 0x00000020,  
		/// <summary>
		/// To be done.
		/// </summary>
		DEVICE              = 0x00000040,  
		/// <summary>
		/// To be done.
		/// </summary>
		NORMAL              = 0x00000080,  
		/// <summary>
		/// To be done.
		/// </summary>
		TEMPORARY           = 0x00000100,  
		/// <summary>
		/// To be done.
		/// </summary>
		SPARSE_FILE         = 0x00000200,  
		/// <summary>
		/// To be done.
		/// </summary>
		REPARSE_POINT       = 0x00000400,  
		/// <summary>
		/// To be done.
		/// </summary>
		COMPRESSED          = 0x00000800,  
		/// <summary>
		/// To be done.
		/// </summary>
		OFFLINE             = 0x00001000,  
		/// <summary>
		/// To be done.
		/// </summary>
		NOT_CONTENT_INDEXED = 0x00002000,  
		/// <summary>
		/// To be done.
		/// </summary>
		ENCRYPTED           = 0x00004000  
	}

	/// <summary>
	/// Contains constants for controlling the kind of protection of the memory pages of the file mapping.<br/>
	/// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	/// </summary>
	[Flags]
	public enum PAGE_PROTECTION: uint
	{
		/// <summary>
		/// Gives read-only access to the committed region of pages. 
		/// An attempt to write to or execute the committed region results in an access violation.
		/// </summary>
		PAGE_READONLY         = 0x02,
		/// <summary>
		/// Gives read-write access to the committed region of pages.
		/// </summary>
		PAGE_READWRITE        = 0x04,
		/// <summary>
		/// Gives copy on write access to the committed region of pages.
		/// </summary>
		PAGE_WRITECOPY        = 0x08,
		/// <summary>
		/// The file specified for a section's file mapping is an executable image file. 
		/// </summary>
		SEC_IMAGE			  = 0x1000000,
		/// <summary>
		/// Allocates physical storage in memory or in the paging file on disk for all pages of a section.
		/// </summary>
		SEC_COMMIT			  = 0x8000000,     
		/// <summary>
		/// All pages of a section are to be set as non-cacheable. SEC_NOCACHE requires either the SEC_RESERVE or SEC_COMMIT to also be set.
		/// </summary>
		SEC_NOCACHE           = 0x10000000  

		// SEC_RESERVE			= ??????         Reserves all pages of a section without allocating physical storage.
	}

	/// <summary>
	/// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	/// </summary>
	[Flags]
	public enum FILE_MAP_ACCESS: uint
	{
		/// <summary>
		/// Copy-on-write access.
		/// </summary>
		FILE_MAP_COPY       = 0x0001,
		/// <summary>
		/// Read-only access.
		/// </summary>
		FILE_MAP_WRITE      = 0x0002,
		/// <summary>
		/// Read and write access.
		/// </summary>
		FILE_MAP_READ       = 0x0004,
		/// <summary>
		/// Includes all access rights to a file mapping object. 
		/// </summary>
		FILE_MAP_ALL_ACCESS = FILE_MAP_WRITE | FILE_MAP_READ | 0x0008 | 0x0010
	}

	/// <summary>
	/// This enumeration has a FlagsAttribute attribute that allows a bitwise combination of its member values.
	/// </summary>
	[Flags]
	internal enum DUPLICATE_OPTIONS
	{
		/// <summary>
		/// Closes the source handle. 
		/// </summary>
		DUPLICATE_CLOSE_SOURCE,
		/// <summary>
		/// Ignores the <i>desiredAccess</i> parameter. The duplicate handle has the same access as the source handle.
		/// </summary>
		DUPLICATE_SAME_ACCESS
	}

	/// <summary>
	/// The SECURITY_ATTRIBUTES class contains the security descriptor for an object and specifies whether the handle retrieved by specifying this structure is inheritable.
	/// </summary>
	/// <seealso href="http://msdn.microsoft.com/library/default.asp?url=/library/en-us/security/security/security_attributes.asp">Platform SDK</seealso>
	[StructLayout(LayoutKind.Sequential)] 
	public class SECURITY_ATTRIBUTES
	{
		/// <summary>
		/// Initializes a new instance of the SECURITY_ATTRIBUTES class.
		/// </summary>
		/// <remarks>The constructor sets the dwSize member to the size in bytes of this structure.</remarks>
		public SECURITY_ATTRIBUTES()
		{
			dwSize = (uint)Marshal.SizeOf(typeof(SECURITY_ATTRIBUTES));
		}

		/// <summary>
		/// Specifies the size, in bytes, of this structure.
		/// </summary>
		public uint dwSize;
		/// <summary>
		/// Pointer to a security descriptor for the object that controls the sharing of it. If NULL is specified for this member, the object is assigned the default security descriptor of the calling process. This is not the same as granting access to everyone by assigning a NULL DACL. The default security descriptor is based on the default DACL of the access token belonging to the calling process. By default, the default DACL in the access token of a process allows access only to the user represented by the access token. If other users must access the object, you can either create a security descriptor with the appropriate access, or add ACEs to the DACL that grants access to a group of users. 
		/// </summary>
		public IntPtr lpSecurityDescriptor;
		/// <summary>
		/// Specifies whether the returned handle is inherited when a new process is created. If this member is TRUE, the new process inherits the handle.
		/// </summary>
		public bool bInheritHandle;
	}

	/// <summary>
	/// Imports file mapping related functions of the Windows Plattform Storage API
	/// </summary>
	internal class StorageAPI
	{
		/// <summary>
		/// Constructor is private.
		/// </summary>
		private StorageAPI()
		{}

		/// <summary>
		/// Constant for an invalid file handle
		/// </summary>
		public static readonly IntPtr INVALID_HANDLE_VALUE = new IntPtr(-1);

		internal static readonly int ERROR_ALREADY_EXISTS = 183;

		// <summary>
		// The CreateFile function creates or opens a file, directory, physical disk, volume, console buffer, tape drive, communications resource, mailslot, or named pipe. 
		// The function returns a handle that can be used to access the object.
		// </summary>
		// <param name="filename">string that specifies the name of the object to create or open</param>
		// <param name="fileAccess">Access to the object (reading, writing, or both). </param>
		// <param name="shareMode">Sharing mode of the object (reading, writing, both, or neither).</param>
		// <param name="securityAttributes">SECURITY_ATTRIBUTES object that determines whether the returned handle can be inherited by child processes. If lpSecurityAttributes is <strong>null</strong>, the handle cannot be inherited. </param>
		// <param name="fileMode">Action to take on files that exist, and which action to take when files do not exist.</param>
		// <param name="flagsAndAttributes">File attributes and flags.</param>
		// <param name="templateFile"> Handle to a template file, with the <see cref="FILE_ACCESS.GENERIC_READ">GENERIC_READ</see> access right. The template file supplies file attributes and extended attributes for the file being created. This parameter can be <strong>null</strong>.</param>
		// <returns>Handle to the specified file or <see cref="INVALID_HANDLE_VALUE"/>.</returns>
		// <remarks>If the specified file exists before the function call and dwCreationDisposition is CREATE_ALWAYS or OPEN_ALWAYS, a call to GetLastError returns ERROR_ALREADY_EXISTS (even though the function has succeeded). If the file does not exist before the call, GetLastError returns zero.</remarks>
		[DllImport("kernel32", CharSet=CharSet.Auto, SetLastError=true)]
		internal static extern IntPtr CreateFile(
			string filename, 
			FILE_ACCESS fileAccess,
			FILE_SHARE shareMode,    
			SECURITY_ATTRIBUTES securityAttributes,   
			FILE_MODE fileMode,
			FILE_ATTRIBUTE flagsAndAttributes,
			IntPtr templateFile);

		// <summary>
		// The CreateFile function creates or opens a file, directory, physical disk, volume, console buffer, tape drive, communications resource, mailslot, or named pipe. 
		// The function returns a handle that can be used to access the object.
		// </summary>
		// <param name="filename">string that specifies the name of the object to create or open</param>
		// <param name="desiredAccess">Access to the object (reading, writing, or both). </param>
		// <param name="shareMode">Sharing mode of the object (reading, writing, both, or neither).</param>
		// <param name="securityAttributes">SECURITY_ATTRIBUTES object that determines whether the returned handle can be inherited by child processes. If lpSecurityAttributes is <strong>null</strong>, the handle cannot be inherited. </param>
		// <param name="creationDisposition">Action to take on files that exist, and which action to take when files do not exist. </param>
		// <param name="flagsAndAttributes">File attributes and flags.</param>
		// <param name="templateFile"> Handle to a template file, with the <see cref="FILE_ACCESS.GENERIC_READ">GENERIC_READ</see> access right. The template file supplies file attributes and extended attributes for the file being created. This parameter can be <strong>null</strong>.</param>
		// <returns>Handle to the specified file or <see cref="INVALID_HANDLE_VALUE"/>.</returns>
		// <remarks>If the specified file exists before the function call and dwCreationDisposition is CREATE_ALWAYS or OPEN_ALWAYS, a call to GetLastError returns ERROR_ALREADY_EXISTS (even though the function has succeeded). If the file does not exist before the call, GetLastError returns zero.</remarks>
		[DllImport("kernel32", CharSet=CharSet.Auto, SetLastError=true)]
		internal static extern IntPtr CreateFile(
			string filename, 
			uint desiredAccess,
			uint shareMode,    
			SECURITY_ATTRIBUTES securityAttributes,   
			uint creationDisposition,
			uint flagsAndAttributes,
			IntPtr templateFile);

		[DllImport("kernel32.dll", CharSet=CharSet.Auto, SetLastError=true)]
		internal static extern IntPtr CreateFileMapping(
			IntPtr hFile, 
			SECURITY_ATTRIBUTES securityAttributes, 
			PAGE_PROTECTION protection, 
			uint maximumSizeHigh, 
			uint maximumSizeLow, 
			string name);

		[DllImport("kernel32.dll", CharSet=CharSet.Auto, SetLastError=true)]
		internal static extern IntPtr OpenFileMapping(
			uint desiredAccess,
			bool inheritHandle,
			string name
			);

		[DllImport("kernel32.dll", SetLastError=true)]
		internal static extern IntPtr MapViewOfFile(
			IntPtr fileMappingObject,
			uint desiredAccess,
			uint fileOffsetHigh,
			uint fileOffsetLow,
			uint numberOfBytesToMap
			);

		[DllImport("kernel32.dll", SetLastError=true)]
		internal static extern bool UnmapViewOfFile(IntPtr baseAddress);

		// <summary>
		// To be done.
		// </summary>
		// <param name="baseAddress"></param>
		// <param name="numberOfBytesToFlush"></param>
		// <returns></returns>
		[DllImport("kernel32.dll", SetLastError=true)]
		internal static extern bool FlushViewOfFile(
			IntPtr baseAddress,
			uint numberOfBytesToFlush
			);

		// <summary>
		// The CloseHandle function closes an open object handle.
		// </summary>
		// <param name="hObject">Handle to an open object.</param>
		// <returns>
		// If the function succeeds, the return value is <strong>True</strong>.<br/>
		// If the function fails, the return value is <strong>False</strong>. To get extended error information, call GetLastError.
		// </returns>
		[DllImport("kernel32", SetLastError=true)]
		internal static extern bool CloseHandle(IntPtr hObject);

		[DllImport("kernel32", SetLastError=true)]
		internal static extern bool DuplicateHandle(IntPtr sourceProcessHandle, IntPtr sourceHandle, IntPtr targetProcessHandle, out IntPtr targetHandle, uint desiredAccess, bool inheritHandle, DUPLICATE_OPTIONS options);


		/*
		[StructLayout(LayoutKind.Sequential)] 
		public struct SYSTEM_INFO 
		{
			public uint dwOemId;
			public uint dwPageSize;
			public uint lpMinimumApplicationAddress;
			public uint lpMaximumApplicationAddress;
			public uint dwActiveProcessorMask;
			public uint dwNumberOfProcessors;
			public uint dwProcessorType;
			public uint dwAllocationGranularity;
			public uint dwProcessorLevel;
			public uint dwProcessorRevision; 
		};
 
		[DllImport("kernel32")]
		public static extern void GetSystemInfo(ref SYSTEM_INFO systemInfo);
		*/
	}
}

