using System;
using System.Runtime.InteropServices;

namespace vu.ch.argee.WindowsAPI
{
	[StructLayout(LayoutKind.Sequential)] 
	internal struct SYSTEM_INFO 
	{
		public uint dwOemId;
		public uint dwPageSize;
		public uint lpMinimumApplicationAddress;
		public uint lpMaximumApplicationAddress;
		public uint dwActiveProcessorMask;
		public uint dwNumberOfProcessors;
		public uint dwProcessorType;
		public uint dwAllocationGranularity;
		public uint dwProcessorLevel;
		public uint dwProcessorRevision; 

	}

	/// <summary>
	/// Summary description for SystemInformationAPI.
	/// </summary>
	internal class SystemInformationAPI
	{
		/// <summary>
		/// Constructor is private.
		/// </summary>
		private SystemInformationAPI()
		{
		}
 
		[DllImport("kernel32")]
		public static extern void GetSystemInfo(ref SYSTEM_INFO systemInformation); 
	}
}
