using System;
using System.Runtime.InteropServices;

namespace vu.ch.argee.MemoryMapping
{
	/// <summary>
	/// Helper class to access the managed memory byte-wise through an indexer
	/// </summary>
	public class UnmanagedByteAccessor
	{
		#region ------------ fields ------------

		private IUnmanagedMemory unmanagedMemory;

		#endregion

		#region ------------ constructors ------------

		/// <summary>
		/// Creates byte-wise memory accessor
		/// </summary>
		/// <param name="unmanagedMemory">The memory block to access</param>
		public UnmanagedByteAccessor(IUnmanagedMemory unmanagedMemory)
		{
			this.unmanagedMemory = unmanagedMemory;			
		}

		#endregion

		#region ------------ private methods ------------

		private void CheckIndex(int index)
		{
			if (index >= unmanagedMemory.Length)
			{
				throw new IndexOutOfRangeException(string.Format("Index of {0} exceeds the upper bound of {1}", index, unmanagedMemory.Length - 1));
			}
		}

		#endregion

		#region ------------ indexer property ------------

		/// <summary>
		/// Gets or sets a byte value at the specified offset in bytes.
		/// </summary>
		public byte this[int index]
		{
			get
			{
				CheckIndex(index);
				return Marshal.ReadByte(unmanagedMemory.BaseAddress, index);
			}
			set
			{
				CheckIndex(index);
				Marshal.WriteByte(unmanagedMemory.BaseAddress, index, value);
			}
		}

		#endregion
	}
}
