
#ifndef DRIVERCONTROL_H

#define DRIVERCONTROL_H

#include "Loader.h"

/* 
---------------------------------------------------------
DriverControl.h
	Driver management functions

	Registry keys created during installation of this driver:
	HKLM\System\CurrentControlSet\Services\<DriverName>
		(removed on uninstall) 
	HKLM\SYSTEM\ControlSet\Enum\Root\LEGACY_<DriverName>
---------------------------------------------------------
*/


//////////////////////////////////////////////////////
//////////////////////////////////////////////////////

BOOL InstallService (PTSTR lpFileName) {

	BOOL status = FALSE;	// return status			

	//-------------------------------------------------------
	// Establish a connection to the service control manager
	//-------------------------------------------------------
	
	SC_HANDLE hScManager = OpenSCManager( 0, 0, SC_MANAGER_ALL_ACCESS );
	if (!hScManager) {

		formatGetLastError ("Error OpenSCManager: ");			
		return FALSE;
	}

	//------------------------------------------
    // Install from current directory
    //------------------------------------------

	TCHAR FilePath[MAX_PATH];
	LPTSTR lpFilePart = NULL; 

    // Get full path of driver in current directory
	GetFullPathName( lpFileName, MAX_PATH, FilePath, &lpFilePart );
 

	//------------------------------------------
    // Request ownership of the SCM database lock 
    //------------------------------------------

	SC_LOCK ScLock = LockServiceDatabase( hScManager );

	if (!ScLock) {

		formatGetLastError ("Error LockServiceDatabase: ");			
		CloseServiceHandle( hScManager );
		return FALSE;
	}

	//------------------------------------------
    // Create the service
    //------------------------------------------

    SC_HANDLE hService = CreateService( 
		hScManager,
		ServiceName,
		ServiceName,
		SERVICE_ALL_ACCESS,
		SERVICE_KERNEL_DRIVER,
		SERVICE_DEMAND_START,
		SERVICE_ERROR_NORMAL,
		FilePath,
		0,0,0,0,0);

	if (!hService) {

		if (GetLastError() == ERROR_SERVICE_EXISTS) {

			printf ("The service is already installed\n");			
	
		} else {
			
			formatGetLastError ("Error CreateService:");			
		}
	} else {
		
//		printf ("Service installed successfully\n");			
		CloseServiceHandle( hService );
		status = TRUE;
	}
	
	CloseServiceHandle( hScManager );
	UnlockServiceDatabase( ScLock );
	
	return status;
}

//////////////////////////////////////////////////////
//////////////////////////////////////////////////////

BOOL UnInstallService (PTSTR lpFileName) {

	BOOL status = FALSE;	// return status			

	//-------------------------------------------------------
	// Establish a connection to the service control manager
	//-------------------------------------------------------
	
	SC_HANDLE hScManager = OpenSCManager( 0, 0, SC_MANAGER_ALL_ACCESS );
	if (!hScManager) {

		formatGetLastError ("Error OpenSCManager:");			
		return FALSE;
	}

	//------------------------------------------
    // Request ownership of the SCM database lock 
    //------------------------------------------

	SC_LOCK ScLock = LockServiceDatabase( hScManager );

	if (!ScLock) {

		formatGetLastError ("Error LockServiceDatabase:");			
		CloseServiceHandle( hScManager );
		return FALSE;
	}

	//------------------------------------------
    // Open the service for deletion
    //------------------------------------------

   SC_HANDLE hService = OpenService(
	   hScManager,   
	   lpFileName,
	   SERVICE_ALL_ACCESS);
   
	if (!hService) {
		formatGetLastError ("Error OpenService:");			

	} else {

		SERVICE_STATUS ServiceStatus;		
		if (ControlService(hService, SERVICE_CONTROL_STOP, &ServiceStatus))
        {
			// make sure it's stopped
			Sleep(1000);
			while (QueryServiceStatus(hService, &ServiceStatus))
            {
				if (ServiceStatus.dwCurrentState == SERVICE_STOP_PENDING)

                    Sleep(1000);
                else
	                break;
			}
//			printf ("Driver stopped successfully\n");	
		}

		// delete it
		if (!DeleteService(hService)) {
			formatGetLastError ("Error DeleteService: ");			
		
		} else {

			printf ("Service uninstalled successfully\n");			
			status = TRUE;
		}

		CloseServiceHandle( hService );
	}	

	CloseServiceHandle( hScManager );
	UnlockServiceDatabase( ScLock );
	
	return status;
}


//////////////////////////////////////////////////////
//////////////////////////////////////////////////////

BOOL StartStopService (PTSTR lpFileName) {

	BOOL status = FALSE;	// return status			

	//-------------------------------------------------------
	// Establish a connection to the service control manager
	//-------------------------------------------------------
	
	SC_HANDLE hScManager = OpenSCManager( 0, 0, SC_MANAGER_ALL_ACCESS );
	if (!hScManager) {

		formatGetLastError ("Error OpenSCManager:");			
		return FALSE;
	}

	//------------------------------------------
    // Open the service
    //------------------------------------------

	SC_HANDLE hService = OpenService(
	   hScManager,   
	   lpFileName,
	   SERVICE_ALL_ACCESS);
   
	if (!hService) {
		formatGetLastError ("Error OpenService:");			

	} else {

		SERVICE_STATUS ServiceStatus;		
		QueryServiceStatus(hService, &ServiceStatus);

		//#################################################

		// Dispatch on dwCurrentState

		switch ( ServiceStatus.dwCurrentState )
		{

		//#################################################

		case SERVICE_STOPPED:		// equ 1
		
		//------------------------------------------
		// If the service is currently stopped - Start it.
		// DriverEntry procedure will be called,
		// function does not return until the device driver
		// has finished initializing. 
		//------------------------------------------

			if (!StartService( hService, 0, NULL )) {		
				printf ("Cannot start the service\n");
				formatGetLastError ("Error StartService:");			
				break;
			}		
			
//			printf ("Driver started successfully\n");	
			status = TRUE;	
			break;


		//#################################################

		case SERVICE_RUNNING:		// equ 4

			//------------------------------------------
			// Stop the service
			//------------------------------------------
	
			SERVICE_STATUS ServiceStatus;		
			if (ControlService(hService, SERVICE_CONTROL_STOP, &ServiceStatus))
			{				
//				printf ("Service stopped successfully\n");	
				status = TRUE;			
			}
				break;

		//#################################################

		case SERVICE_START_PENDING:		// equ 2

			break;

		//#################################################

		case SERVICE_STOP_PENDING:		// equ 3

			break;
			
		//#################################################

		default:
			break;
		}	

		CloseServiceHandle( hService );
	}
	CloseServiceHandle( hScManager );
	
	return status;
}

///////////////////////////////////////////////////////
///////////////////////////////////////////////////////

BOOL OpenDevice (PTSTR lpFileName) {

    TCHAR DeviceName[64];
	
	//-----------------------------------------------
	// Obtain a handle to the loaded driver for DeviceIoControl interface
    // Driver will receive I/O request packet (IRP) of type IRP_MJ_CREATE
	//------------------------------------------------
	
	wsprintf( DeviceName, TEXT("\\\\.\\%s"), lpFileName );
	

	hDriver = CreateFile(
		DeviceName,
		GENERIC_READ || GENERIC_WRITE,
		0, NULL, OPEN_EXISTING, 0, NULL);
				
	if (hDriver == INVALID_HANDLE_VALUE) {

		printf ("Cannot obtain a handle to the driver\n");
		formatGetLastError ("Error CreateFile:");
		return FALSE;
	}
	return TRUE;
}

///////////////////////////////////////////////////////
///////////////////////////////////////////////////////


#endif //DRIVERCONTROL_H

