
/*

  defines.h - include file for main.cpp


-------------------------------------------------------
  To compile a driver in MS Visual C++:

1. Name the main file as *.c, or
2. Name the main file as *.cpp and wrap the include
	for ntddk.h around an extern "C" declaration

  The following define takes care of both cases

 /TP compiler option: specifies a C++ source file
	 allows variables to be defined outside of proc start
      
-------------------------------------------------------
*/

#ifdef __cplusplus  // C++ conversion
	extern "C" {
	#include <ntddk.h>
	}
#else
	#include <ntddk.h>
#endif

	
EXTERN_C NTSTATUS
DriverEntry(IN PDRIVER_OBJECT pDriverObject, IN PUNICODE_STRING RegistryPath);

// Declare DriverEntry as INIT code, paged out after calling
#pragma alloc_text(INIT, DriverEntry)


NTSTATUS DispatchCreateClose (PDEVICE_OBJECT pDeviceObject, PIRP pIrp);
NTSTATUS DispatchControl (PDEVICE_OBJECT pDeviceObject, PIRP pIrp);	
VOID DriverUnload (IN PDRIVER_OBJECT pDriverObject);


