
//	common.h - IOCTL function defines

// Macro definition for defining IOCTL and FSCTL function control codes.
// Function codes 0-2047 are reserved for Microsoft Corporation, and
// 2048-4095 are reserved for customers.

//////////////////////////////////////////////////////////////////////

#ifndef CTL_CODE
#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
    ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

//
// Define the method codes for how buffers are passed for I/O and FS controls
//

#define METHOD_BUFFERED                 0
#define METHOD_IN_DIRECT                1
#define METHOD_OUT_DIRECT               2
#define METHOD_NEITHER                  3

#define FILE_ANY_ACCESS					0
#define FILE_DEVICE_UNKNOWN				0x22

#endif // CTL_CODE

//////////////////////////////////////////////////////////////////////

#define IOCTL_Disassemble \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_MdlCleanup \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x801, NULL, FILE_ANY_ACCESS)

//////////////////////////////////////////////////////////////////////


// Define incoming and outgoing buffers for internal use
// Input/Output buffers used by METHOD_BUFFERED are the same

// struct format of data passed to driver
typedef struct _IO_IN_BUFFER {
	UCHAR NtKernelCall[0x64];	// name of ntoskrnl or hal function to disassemble
	ULONG Address;				// kernel or user mode address to disassemble
	int NumToDisasm;			// number of instructions to disassemble limit
} IO_IN_BUFFER, *PIO_IN_BUFFER;

// struct format of data returned from driver
typedef struct _IO_OUT_BUFFER {
	PVOID MDLAddress;			// address of shared MDL created by driver
	int NumDisasm;				// number of instructions disassembled
} IO_OUT_BUFFER, *PIO_OUT_BUFFER;


//////////////////////////////////////////////////////////////////////




