
//	SysDasm_LoadAsImage.h - include file for SysDasm_LoadAsImage.cpp

/////////////////////////////////////////////////////////////////////

PVOID BuildUserMDL (int szBuffer);
PVOID GetAddressFromName (char * function_name);

// ZwSetSystemInformation functions
PVOID LoadImage_GetExportByOrdinal (PCWSTR DriverName, int Ordinal);
PVOID UnLoadImage (PVOID module_section);


/////////////////////////////////////////////////////////////////////

// Our Device Extension
typedef struct _DEVICE_EXTENSION {
	ULONG Address;				// address to disassemble
	UCHAR OpcodeBuff[0x10];		// 16 bytes starting at Address
	UCHAR DisasmText[0x100];	// buffer holding disassembled text
} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

//////////////////////////////////////////////////////////////////

typedef struct _IMAGE_EXPORT_DIRECTORY {
    ULONG   Characteristics;
    ULONG   TimeDateStamp;
    USHORT  MajorVersion;
    USHORT  MinorVersion;
    ULONG   Name;
    ULONG   Base;
    ULONG   NumberOfFunctions;
    ULONG   NumberOfNames;
    ULONG   AddressOfFunctions;     // RVA from base of image
    ULONG   AddressOfNames;
    ULONG   AddressOfNameOrdinals;
} IMAGE_EXPORT_DIRECTORY, *PIMAGE_EXPORT_DIRECTORY;

/////////////////////////////////////////////////////////////////////
	
typedef enum _SYSTEM_INFORMATION_CLASS
  {
   SystemBasicInformation,
   SystemLoadImage = 26,
   SystemUnloadImage = 27
  }
   SYSTEM_INFORMATION_CLASS;		

/////////////////////////////////////////////////////////////////////

/* Note: These 2 structures used with ZwSetSystemInformation, originally
	described by Gary Nebbet in his classic Windows NT Native API document,
	were later corrected by him to the following definition.

	"In the SYSTEM_LOAD_IMAGE structure, the member named "Unknown" is in fact
	a pointer to the same type of data that is pointed to by the DriverSection
	member of a DRIVER_OBJECT structure, and this member should appear in the
	SYSTEM_UNLOAD_IMAGE structure."
	See Newsgroup: comp.os.ms-windows.programmer.nt.kernel-mode (2000/04/06)
*/

typedef struct _SYSTEM_LOAD_IMAGE {			// Information Class 26
    IN UNICODE_STRING ModuleName;
    OUT PVOID ModuleBase;
    OUT PVOID ModuleSection;
    OUT PVOID EntryPoint;
    OUT PVOID ExportDirectory;
} SYSTEM_LOAD_IMAGE, *PSYSTEM_LOAD_IMAGE;

typedef struct _SYSTEM_UNLOAD_IMAGE {		// Information Class 27
    IN PVOID ModuleSection;
} SYSTEM_UNLOAD_IMAGE, *PSYSTEM_UNLOAD_IMAGE;

/////////////////////////////////////////////////////////////////////

EXTERN_C NTSYSAPI
NTSTATUS
NTAPI
ZwSetSystemInformation (
    IN SYSTEM_INFORMATION_CLASS SystemInformationClass,
    IN PVOID                    SystemInformation,
    IN ULONG                    Length
);

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////




SYSTEM_LOAD_IMAGE		LoadImage;
SYSTEM_UNLOAD_IMAGE     UnloadImage;

PVOID pDisasm;			// pointer to our SysDasm DLL export function


/////////////////////////////////////////////////////////////////////
// LoadImage_GetExportByOrdinal
/////////////////////////////////////////////////////////////////////

PVOID LoadImage_GetExportByOrdinal (PCWSTR driver_name, int ordinal)
{

	//**************************************************************
	// Use ZwSetSystemInformation to load the kernel DLL module
	//**************************************************************

	//const WCHAR DriverName[] = L"\\??\\C:\\SysDasm.sys";
    RtlInitUnicodeString(&LoadImage.ModuleName, driver_name);

	NTSTATUS Status;
	Status = ZwSetSystemInformation(
	  SystemLoadImage,
	  &LoadImage,
	  sizeof(LoadImage));

	if (!NT_SUCCESS(Status))	{

		DbgPrint("SystemLoadImage failed with Error %x\n", Status);
		return 0; 
	}
	
//		DbgPrint("ModuleName %x\n", LoadImage.ModuleName);
//		DbgPrint("ModuleBase %x\n", LoadImage.ModuleBase);
//		DbgPrint("ModuleSection %x\n", LoadImage.ModuleSection);
//		DbgPrint("EntryPoint %x\n", LoadImage.EntryPoint);
//		DbgPrint("ExportDirectory %x\n", LoadImage.ExportDirectory);

	ULONG_PTR ModuleBase;
	ModuleBase = (ULONG_PTR) LoadImage.ModuleBase;

	///////////////////////////////////////////////////////////

	//**************************************************************
	// Get address of our exported function by Ordinal value
	//**************************************************************

	// Cast ExportDirectory address to IMAGE_EXPORT_DIRECTORY structure
	IMAGE_EXPORT_DIRECTORY	ImageExportDirectory;
	ImageExportDirectory = *(PIMAGE_EXPORT_DIRECTORY) LoadImage.ExportDirectory;

	// Get proper ordinal index by subtracting Base value (=1)
	ordinal = ordinal - ImageExportDirectory.Base;

	// Parse AddressOfFunctions array to get pointer to RVA of the export
	ULONG_PTR pRVA;
	pRVA = ( ModuleBase + 
		ImageExportDirectory.AddressOfFunctions +
		ordinal * sizeof (DWORD_PTR) );

	// Calculate export address
	long pExport;
	pExport = (ModuleBase + *( (ULONG*)pRVA ));

	return (PVOID) pExport;
}

/////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
// UnLoadImage
/////////////////////////////////////////////////////////////////////

PVOID UnLoadImage (PVOID module_section)
{

	// Set ModuleSection value to that returned in LoadImage.ModuleSection
	UnloadImage.ModuleSection = module_section;

	NTSTATUS Status;
	Status = ZwSetSystemInformation(
	  SystemUnloadImage,
	  &UnloadImage,
	  sizeof(UnloadImage));

	if (!NT_SUCCESS(Status))	{

		DbgPrint("SystemUnloadImage failed with Error %x\n", Status);
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////