/*
 sysdasm.cpp

	=================================================
	 SysDasm Kernel DLL Full-Text Disassembly Module
	=================================================

  This is a wrapper function around the source code of NDISASM,
  the Netwide Disassembler portion of NASM, compiled into a
  kernel mode DLL (export) driver.
  
  The module can be loaded from another driver in one of two ways:
  
	1, Linking to it explicitly by including SysDasm.LIB when compiling.
	   The module export should be imported by the driver as:

	EXTERN_C DECLSPEC_IMPORT int
	Disasm(IN unsigned char * inBuffer,     // opcode bytes to decode
		   OUT unsigned char * outBuffer,   // return disassembly text
	       IN long Address);                // instruction address
  
	(returns opcode length)
  
	When the driver is loaded by the system, the SysDasm.sys module
	is also loaded as a required kernel DLL. When the driver closes,
	the DLL is unloaded	by the system. The export can be called by name.
	

	2. Loading it with ZwSetSystemInformation using SystemLoadImage class. 	
	   The export address can be extracted from the ImageExportDirectory.

    (See examples)
		 
  
  Based on the NASM Netwide Disassembler version 0.98.38, as distributed
  under the GNU General Public License.

	  Kayaker, 2004
	  ww_paddler@hotmail.com

*/


#include <ntddk.h>
#include "Sysdasm.h"
#include "disasm.c"


/////////////////////////////////////////////////////////////////////
//
// SysDasm Exported Function
//
/////////////////////////////////////////////////////////////////////

EXPORT_API
Disasm (unsigned char * inBuffer,
		char * outBuffer,
		long Address)
{
	// Check buffers for validity
	if (!inBuffer || !outBuffer)
		return 0;

	// Call the internal disasm function which is defined as:
	// (slightly modified from the original NDISASM 0.98.38 version)

	// long disasm (unsigned char *data, char *output, int segsize,
	//			    long offset, unsigned long prefer)
	
	
	int OpcodeLength = disasm (inBuffer, outBuffer, 32, Address, 0);	
	return OpcodeLength;

}

//===================================================================



//===================================================================


/////////////////////////////////////////////////////////////////////
//
// Driver Entry
// never called, but required by compiler
// 
/////////////////////////////////////////////////////////////////////

NTSTATUS DriverEntry(IN PDRIVER_OBJECT  DriverObject,
                     IN PUNICODE_STRING RegistryPath)
{

	return STATUS_SUCCESS;
}

//===================================================================
//===================================================================
