' ****************************************************************************************
' TB_COM32.INC - Include file for COM
' (C) 2005 by Jos Roca
' ****************************************************************************************

#IF NOT %DEF(%WINAPI)
    #INCLUDE "WIN32API.INC"
#ENDIF

' ****************************************************************************************
' CONSTANTS
' ****************************************************************************************
%COINIT_APARTMENTTHREADED = &H2    ' Apartment model
%COINIT_MULTITHREADED     = &H0    ' OLE calls objects on any thread.
%CLSCTX_INPROC_SERVER     = &H1    ' Component is allowed in the same process space.
                                   ' Requires that the component be implemented as a DLL
%CLSCTX_INPROC_HANDLER    = &H2    ' Part is in-proc and the rest local or remote
%CLSCTX_LOCAL_SERVER      = &H4    ' Different process, same machine
%CLSCTX_REMOTE_SERVER     = &H10   ' Components may reside on remote computers (DCOM)
%CLSCTX_INPROC            = %CLSCTX_INPROC_SERVER OR %CLSCTX_INPROC_HANDLER
%CLSCTX_SERVER            = %CLSCTX_INPROC_SERVER OR %CLSCTX_LOCAL_SERVER OR %CLSCTX_REMOTE_SERVER
%CLSCTX_ALL               = %CLSCTX_INPROC_SERVER OR %CLSCTX_INPROC_HANDLER OR %CLSCTX_LOCAL_SERVER OR %CLSCTX_REMOTE_SERVER
' ****************************************************************************************

' ****************************************************************************************
' VarType enum
' ****************************************************************************************
%vbEmpty                                                = 0            ' &H0 (VT_EMPTY)
%vbNull                                                 = 1            ' &H1 (VT_NULL)
%vbInteger                                              = 2            ' &H2 (VT_UI2)
%vbLong                                                 = 3            ' &H3 (VT_I4)
%vbSingle                                               = 4            ' &H4 (VT_R4)
%vbDouble                                               = 5            ' &H5 (VT_R8)
%vbCurrency                                             = 6            ' &H6 (VT_CY)
%vbDate                                                 = 7            ' &H7 (VT_DATE)
%vbString                                               = 8            ' &H8 (VT_BSTR)
%vbObject                                               = 9            ' &H9 (VT_DISPATCH)
%vbError                                                = 10           ' &HA (VT_ERROR)
%vbBoolean                                              = 11           ' &HB (VT_BOOL)
%vbVariant                                              = 12           ' &HC (VT_VARIANT)
%vbDataObject                                           = 13           ' &HD (VT_UNKNOWN)
%vbDecimal                                              = 14           ' &HE (VT_DECIMAL)
%vbByte                                                 = 17           ' &H11 (VT_UI1)
%vbWord                                                 = 18           ' &H12 (VT_UI2)
%vbDWord                                                = 19           ' &H13 (VT_UI4)
%vbQuad                                                 = 20           ' &H14 (VT_I8)
%vbUserDefinedType                                      = 36           ' &H24 (VT_RECORD)
%vbClsid                                                = 72           ' &H48 (VT_CLSID)
%vbArray                                                = 8192         ' &H2000 (VT_ARRAY)
' ****************************************************************************************

' ****************************************************************************************
' TriState enum
' ****************************************************************************************
%vbUseDefault                                           = -2           ' &HFFFFFFFE
%vbTrue                                                 = -1           ' &HFFFFFFFF
%vbFalse                                                = 0            ' &H0
' ****************************************************************************************

' ****************************************************************************************
' CallType enum
' ****************************************************************************************
%vbMethod                                               = 1            ' &H1
%vbCall                                                 = 1            ' &H1
%vbGet                                                  = 2            ' &H2
%vbLet                                                  = 4            ' &H4
%vbPut                                                  = 4            ' &H4
%vbSet                                                  = 8            ' &H8
%vbPutRef                                               = 8            ' &H8
' ****************************************************************************************

' ****************************************************************************************
' CALLCONV Enumeration
' Identifies the calling convention used by a method described in a METHODDATA structure.
' ****************************************************************************************
%CC_FASTCALL   = 0
%CC_CDECL      = 1
%CC_PASCAL     = 2
%CC_MACPASCAL  = 3
%CC_STDCALL    = 4
%CC_FPFASTCALL = 5
%CC_SYSCALL    = 6
%CC_MPWCDECL   = 7
%CC_MPWPASCAL  = 8
%CC_MAX        = 9
' ****************************************************************************************

' ****************************************************************************************
' Interface name = IUnknown
' IID = {00000000-0000-0000-C000-000000000046}
' VTable offsets
' ****************************************************************************************
%VTO_IUnknown_QueryInterface                            = 0            ' &H0
%VTO_IUnknown_AddRef                                    = 4            ' &H4
%VTO_IUnknown_Release                                   = 8            ' &H8
' ****************************************************************************************

' ****************************************************************************************
' Interface name = IDispatch
' IID = {00020400-0000-0000-C000-000000000046}
' Implied interface = IUnknown
' VTable offsets
' ****************************************************************************************
%VTO_IDispatch_GetTypeInfoCount                         = 12           ' &HC
%VTO_IDispatch_GetTypeInfo                              = 16           ' &H10
%VTO_IDispatch_GetIDsOfNames                            = 20           ' &H14
%VTO_IDispatch_Invoke                                   = 24           ' &H18
' ****************************************************************************************

' ****************************************************************************************
' Interface name = IEnumVARIANT
' IID = {00020404-0000-0000-C000-000000000046}
' Implied interface = IUnknown
' VTable offsets
' ****************************************************************************************
%VTO_IEnumVARIANT_Next                                  = 12           ' &HC
%VTO_IEnumVARIANT_Skip                                  = 16           ' &H10
%VTO_IEnumVARIANT_Reset                                 = 20           ' &H14
%VTO_IEnumVARIANT_Clone                                 = 24           ' &H18
' ****************************************************************************************

' ****************************************************************************************
' Interface name = IFont
' IID = {BEF6E002-A874-101A-8BBA-00AA00300CAB}
' Documentation string = Font Object
' Implied interface = IUnknown
' VTable offsets
' ****************************************************************************************
%VTO_IFont_get_Name                                     = 12           ' &HC
%VTO_IFont_put_Name                                     = 16           ' &H10
%VTO_IFont_get_Size                                     = 20           ' &H14
%VTO_IFont_put_Size                                     = 24           ' &H18
%VTO_IFont_get_Bold                                     = 28           ' &H1C
%VTO_IFont_put_Bold                                     = 32           ' &H20
%VTO_IFont_get_Italic                                   = 36           ' &H24
%VTO_IFont_put_Italic                                   = 40           ' &H28
%VTO_IFont_get_Underline                                = 44           ' &H2C
%VTO_IFont_put_Underline                                = 48           ' &H30
%VTO_IFont_get_Strikethrough                            = 52           ' &H34
%VTO_IFont_put_Strikethrough                            = 56           ' &H38
%VTO_IFont_get_Weight                                   = 60           ' &H3C
%VTO_IFont_put_Weight                                   = 64           ' &H40
%VTO_IFont_get_Charset                                  = 68           ' &H44
%VTO_IFont_put_Charset                                  = 72           ' &H48
%VTO_IFont_get_hFont                                    = 76           ' &H4C
%VTO_IFont_Clone                                        = 80           ' &H50
%VTO_IFont_IsEqual                                      = 84           ' &H54
%VTO_IFont_SetRatio                                     = 88           ' &H58
%VTO_IFont_AddRefHfont                                  = 92           ' &H5C
%VTO_IFont_ReleaseHfont                                 = 96           ' &H60
' ****************************************************************************************

' ****************************************************************************************
' Interface name = IPicture
' IID = {7BF80980-BF32-101A-8BBB-00AA00300CAB}
' Documentation string = Picture Object
' Implied interface = IUnknown
' VTable offsets
' ****************************************************************************************
%VTO_IPicture_get_Handle                                = 12           ' &HC
%VTO_IPicture_get_hPal                                  = 16           ' &H10
%VTO_IPicture_get_Type                                  = 20           ' &H14
%VTO_IPicture_get_Width                                 = 24           ' &H18
%VTO_IPicture_get_Height                                = 28           ' &H1C
%VTO_IPicture_Render                                    = 32           ' &H20
%VTO_IPicture_put_hPal                                  = 36           ' &H24
%VTO_IPicture_get_CurDC                                 = 40           ' &H28
%VTO_IPicture_SelectPicture                             = 44           ' &H2C
%VTO_IPicture_get_KeepOriginalFormat                    = 48           ' &H30
%VTO_IPicture_put_KeepOriginalFormat                    = 52           ' &H34
%VTO_IPicture_PictureChanged                            = 56           ' &H38
%VTO_IPicture_SaveAsFile                                = 60           ' &H3C
%VTO_IPicture_get_Attributes                            = 64           ' &H40
%VTO_IPicture_SetHdc                                    = 68           ' &H44
' ****************************************************************************************

' ****************************************************************************************
' EXCEPINFO structure
' ****************************************************************************************
TYPE EXCEPINFO
   wCode AS WORD               ' An error code describing the error.
   wReserved AS WORD           ' Reserved
   bstrSource AS DWORD         ' Source of the exception.
   bstrDescription AS DWORD    ' Textual description of the error.
   bstrHelpFile AS DWORD       ' Help file path.
   dwHelpContext AS DWORD      ' Help context ID.
   pvReserved AS DWORD         ' Reserved
   pfnDeferredFillIn AS DWORD  ' Pointer to function that fills in Help and description info.
   scode AS DWORD              ' An error code describing the error
END TYPE
' ****************************************************************************************

' ****************************************************************************************
' Returns a pointer to a specified interface on an object to which a client currently
' holds an interface pointer. You must release the returned interface, when no longer
' needed, with a call to the Release method.
' ****************************************************************************************
FUNCTION IUnknown_QueryInterface (BYVAL pthis AS DWORD PTR, BYREF riid AS GUID, BYREF ppvObj AS DWORD) AS LONG
    LOCAL HRESULT AS LONG
    IF pthis = %NULL THEN FUNCTION = %E_POINTER : EXIT FUNCTION
    CALL DWORD @@pthis[0] USING IUnknown_QueryInterface(pthis, riid, ppvObj) TO HRESULT
    FUNCTION = HRESULT
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' The IUnknown_AddRef method increments the reference count for an interface on an object.
' It should be called for every new copy of a pointer to an interface on a given object.
' ****************************************************************************************
FUNCTION IUnknown_AddRef (BYVAL pthis AS DWORD PTR) AS DWORD
    LOCAL DWRESULT AS LONG
    IF pthis = %NULL THEN EXIT FUNCTION
    CALL DWORD @@pthis[1] USING IUnknown_AddRef(pthis) TO DWRESULT
    FUNCTION = DWRESULT
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Decrements the reference count for the calling interface on a object. If the reference
' count on the object falls to 0, the object is freed from memory.
' ****************************************************************************************
FUNCTION IUnknown_Release (BYVAL pthis AS DWORD PTR) AS DWORD
    LOCAL DWRESULT AS DWORD
    IF pthis = %NULL THEN EXIT FUNCTION
    CALL DWORD @@pthis[2] USING IUnknown_Release(pthis) TO DWRESULT
    FUNCTION = DWRESULT
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Maps a single member to a corresponding DispID, which can be used on subsequent calls to
' IDispatch_Invoke.
' ****************************************************************************************
DECLARE FUNCTION Proto_IDispatch_GetIDOfName (BYVAL pthis AS DWORD PTR, BYREF riid AS GUID, BYREF rgszNames AS STRING, BYVAL cNames AS DWORD, BYVAL lcid AS DWORD, BYREF rgdispid AS LONG) AS LONG
' ****************************************************************************************
FUNCTION IDispatch_GetIDOfName (BYVAL pthis AS DWORD PTR, BYREF strName AS STRING, BYREF rgdispid AS LONG) AS LONG
    LOCAL HRESULT AS LONG, riid AS GUID
    IF pthis = %NULL THEN FUNCTION = %E_POINTER : EXIT FUNCTION
    CALL DWORD @@pthis[5] USING Proto_IDispatch_GetIDOfName (pthis, riid, strName, 1, 0, rgdispid) TO HRESULT
    FUNCTION = HRESULT
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Provides access to properties and methods exposed by an object.
' Note: if the call to Invoke returns %DISP_E_EXCEPTION (&H80020009), the EXCEPINFO
' structure is filled with error information. Three of his members are pointers to
' unicode strings that you can read with the TB_ExcepInfoErrorDescription,
' TB_ExcepInfoErrorSource and TB_ExcepInfoErrorHelpFile functions, and that you must free
' with SysFreeString: SysFreeString pexcepinfo.bstrDescription,
' SysFreeString pexcepinfo.bstrSource, SysFreeString pexcepinfo.bstrHelpFile.
' ****************************************************************************************
FUNCTION IDispatch_Invoke (BYVAL pthis AS DWORD PTR, BYVAL dispidMember AS LONG, BYREF riid AS GUID, _
    BYVAL lcid AS DWORD, BYVAL wFlags AS WORD, BYREF pdispparams AS DISPPARAMS, BYREF pvarResult AS VARIANT, _
    BYREF pexcepinfo AS EXCEPINFO, BYREF puArgErr AS DWORD) AS LONG
    LOCAL HRESULT AS LONG
    IF pthis = %NULL THEN FUNCTION = %E_POINTER : EXIT FUNCTION
    CALL DWORD @@pthis[6] USING IDispatch_Invoke (pthis, dispidMember, riid, lcid, wFlags, pdispparams, pvarResult, pexcepinfo, puArgErr) TO HRESULT
    FUNCTION = HRESULT
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Returns the error description
' ****************************************************************************************
FUNCTION TB_ExcepInfoErrorDescription (BYREF pex AS EXCEPINFO) AS STRING
    LOCAL bstrlen AS LONG
    IF pex.bstrDescription THEN
       bstrlen = SysStringByteLen(BYVAL pex.bstrDescription)
       IF bstrlen THEN FUNCTION = ACODE$(PEEK$(pex.bstrDescription, bstrlen))
    END IF
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Returns the error source
' ****************************************************************************************
FUNCTION TB_ExcepInfoErrorSource (BYREF pex AS EXCEPINFO) AS STRING
    LOCAL bstrlen AS LONG
    IF pex.bstrSource THEN
       bstrlen = SysStringByteLen(BYVAL pex.bstrSource)
       IF bstrlen THEN FUNCTION = ACODE$(PEEK$(pex.bstrSource, bstrlen))
    END IF
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Returns the help file
' ****************************************************************************************
FUNCTION TB_ExcepInfoErrorHelpFile (BYREF pex AS EXCEPINFO) AS STRING
    LOCAL bstrlen AS LONG
    IF pex.bstrHelpFile THEN
       bstrlen = SysStringByteLen(BYVAL pex.bstrHelpFile)
       IF bstrlen THEN FUNCTION = ACODE$(PEEK$(pex.bstrHelpFile, bstrlen))
    END IF
END FUNCTION
' ****************************************************************************************


' ****************************************************************************************
' VARIANT API FUNCTIONS
' Note: Using AS ANY disables type checking, so you can pass variants declared with PB and
' variants declared as VARIANTAPI.
' Examples:
' DIM v1 as VARIANTAPI, v2 AS VARIANT
' VariantInit v1
' v2 = 12345 AS DWORD
' VariantCopy v1, v2
' ****************************************************************************************
%VARIANT_NOVALUEPROP    = &H1
%VARIANT_ALPHABOOL      = &H2
%VARIANT_NOUSEROVERRIDE = &H4
%VARIANT_LOCALBOOL      = &H10

DECLARE SUB      VariantInit LIB "OLEAUT32.DLL" ALIAS "VariantInit" (BYREF pvarg AS ANY)
DECLARE FUNCTION VariantCopy LIB "OLEAUT32.DLL" ALIAS "VariantCopy" (BYREF pvargDest AS ANY, BYREF pvargSrc AS ANY) AS LONG
DECLARE FUNCTION VariantCopyInd LIB "OLEAUT32.DLL" ALIAS "VariantCopyInd" (BYREF pvarg AS ANY, BYREF pvargSrc AS ANY) AS LONG
DECLARE FUNCTION VariantClear LIB "OLEAUT32.DLL" ALIAS "VariantClear" (BYREF pvarg AS ANY) AS LONG
DECLARE FUNCTION VariantChangeType LIB "OLEAUT32.DLL" ALIAS "VariantChangeType" (BYREF pvargDest AS ANY, BYREF pvargSrc AS ANY, BYVAL wFlags AS WORD, BYVAL vt AS WORD) AS LONG
DECLARE FUNCTION VariantChangeTypeEx LIB "OLEAUT32.DLL" ALIAS "VariantChangeTypeEx" (BYREF pvargDest AS ANY, BYREF pvargSrc AS ANY, BYVAL wFlags AS WORD, BYVAL vt AS WORD) AS LONG
' ****************************************************************************************

' ****************************************************************************************
' Converts a date contained in a variant to a formated string.
' ****************************************************************************************
FUNCTION TB_VariantDateToFormatedStr (BYREF vDate AS VARIANT, BYVAL strFormat AS STRING) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL st AS SYSTEMTIME
   LOCAL vbDate AS DOUBLE
   vbDate = VARIANT#(vDate)
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, BYVAL %NULL, st, BYVAL STRPTR(strFormat), d, 64
   FUNCTION = d
END FUNCTION
' ****************************************************************************************
FUNCTION TB_VariantDateToShortDateStr (BYREF vDate AS VARIANT) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL st AS SYSTEMTIME
   LOCAL vbDate AS DOUBLE
   vbDate = VARIANT#(vDate)
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, %DATE_SHORTDATE, st, BYVAL %NULL, d, 64
   FUNCTION = d
END FUNCTION
' ****************************************************************************************
FUNCTION TB_VariantDateToLongDateStr (BYREF vDate AS VARIANT) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL st AS SYSTEMTIME
   LOCAL vbDate AS DOUBLE
   vbDate = VARIANT#(vDate)
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, %DATE_LONGDATE, st, BYVAL %NULL, d, 64
   FUNCTION = d
END FUNCTION
' ****************************************************************************************
FUNCTION TB_VariantDateAndTimeToStr (BYREF vDate AS VARIANT) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL dt AS STRING
   LOCAL st AS SYSTEMTIME
   LOCAL vbDate AS DOUBLE
   vbDate = VARIANT#(vDate)
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, %DATE_SHORTDATE, st, BYVAL %NULL, d, 64
   dt = d
   GetTimeFormat %LOCALE_USER_DEFAULT, %LOCALE_NOUSEROVERRIDE, st, BYVAL %NULL, d, 64
   dt = dt & " " & d
   FUNCTION = dt
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Converts a date contained in a double variable to a formated string.
' ****************************************************************************************
FUNCTION TB_DateToFormatedStr (BYVAL vbDate AS DOUBLE, BYVAL strFormat AS STRING) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL st AS SYSTEMTIME
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, BYVAL %NULL, st, BYVAL STRPTR(strFormat), d, 64
   FUNCTION = d
END FUNCTION
' ****************************************************************************************
FUNCTION TB_DateToShortDateStr (BYVAL vbDate AS DOUBLE) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL st AS SYSTEMTIME
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, %DATE_SHORTDATE, st, BYVAL %NULL, d, 64
   FUNCTION = d
END FUNCTION
' ****************************************************************************************
FUNCTION TB_DateToLongDateStr (BYVAL vbDate AS DOUBLE) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL st AS SYSTEMTIME
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, %DATE_LONGDATE, st, BYVAL %NULL, d, 64
   FUNCTION = d
END FUNCTION
' ****************************************************************************************
FUNCTION TB_DateAndTimeToStr (BYVAL vbDate AS DOUBLE) EXPORT AS STRING
   LOCAL d  AS ASCIIZ * 64
   LOCAL dt AS STRING
   LOCAL st AS SYSTEMTIME
   VariantTimeToSystemTime vbDate, st
   GetDateFormat %LOCALE_USER_DEFAULT, %DATE_SHORTDATE, st, BYVAL %NULL, d, 64
   dt = d
   GetTimeFormat %LOCALE_USER_DEFAULT, %LOCALE_NOUSEROVERRIDE, st, BYVAL %NULL, d, 64
   dt = dt & " " & d
   FUNCTION = dt
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' SAFEARRAY API FUNCTIONS
' ****************************************************************************************
TYPE SAFEARRAYBOUND
   cElements AS DWORD
   lLbound   AS LONG
END TYPE

TYPE SAFEARRAY
   cDims        AS WORD
   fFeatures    AS WORD
   cbElements   AS DWORD
   cLocks       AS DWORD
   pvData       AS DWORD
   rgsabound(0) AS SAFEARRAYBOUND  ' Variable-length array of SAFEARRAYBOUND structures
END TYPE

DECLARE FUNCTION SafeArrayAccessData LIB "OLEAUT32.DLL" ALIAS "SafeArrayAccessData" (BYVAL psa AS DWORD, BYREF ppvData AS ANY) AS LONG
DECLARE FUNCTION SafeArrayAllocData LIB "OLEAUT32.DLL" ALIAS "SafeArrayAllocData" (BYVAL psa AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayAllocDescriptor LIB "OLEAUT32.DLL" ALIAS "SafeArrayAllocDescriptor" (BYVAL cDims AS WORD, BYREF ppsaOut AS ANY) AS LONG
DECLARE FUNCTION SafeArrayAllocDescriptorEx LIB "OLEAUT32.DLL" ALIAS "SafeArrayAllocDescriptorEx" (BYVAL vt AS WORD, BYVAL cDims AS WORD, BYREF ppsaOut AS ANY) AS LONG
DECLARE FUNCTION SafeArrayCopy LIB "OLEAUT32.DLL" ALIAS "SafeArrayCopy" (BYVAL psa AS DWORD, BYREF ppsaOut AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayCopyData LIB "OLEAUT32.DLL" ALIAS "SafeArrayCopyData" (BYVAL psaSource AS DWORD, BYVAL psaTarget AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayCreate LIB "OLEAUT32.DLL" ALIAS "SafeArrayCreate" (BYVAL vt AS WORD, BYVAL cDims AS WORD, BYREF rgsabound AS SAFEARRAYBOUND) AS DWORD
DECLARE FUNCTION SafeArrayCreateEx LIB "OLEAUT32.DLL" ALIAS "SafeArrayCreateEx" (BYVAL vt AS WORD, BYVAL cDims AS WORD, BYREF rgsabound AS SAFEARRAYBOUND, BYREF pvExtra AS ANY) AS DWORD
DECLARE FUNCTION SafeArrayCreateVector LIB "OLEAUT32.DLL" ALIAS "SafeArrayCreateVector" (BYVAL vt AS WORD, BYVAL lLbound AS LONG, BYVAL cElements AS WORD) AS DWORD
DECLARE FUNCTION SafeArrayCreateVectorEx LIB "OLEAUT32.DLL" ALIAS "SafeArrayCreateVectorEx" (BYVAL vt AS WORD, BYVAL lLbound AS LONG, BYVAL cElements AS WORD, BYREF pvExtra AS ANY) AS DWORD
DECLARE FUNCTION SafeArrayDestroy LIB "OLEAUT32.DLL" ALIAS "SafeArrayDestroy" (BYVAL psa AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayDestroyData LIB "OLEAUT32.DLL" ALIAS "SafeArrayDestroyData" (BYVAL psa AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayDestroyDescriptor LIB "OLEAUT32.DLL" ALIAS "SafeArrayDestroyDescriptor" (BYVAL psa AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayGetDim LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetDim" (BYVAL psa AS DWORD) AS DWORD
DECLARE FUNCTION SafeArrayGetElement LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetElement" (BYVAL psa AS DWORD, BYVAL rgIndices AS DWORD, BYREF pv AS ANY) AS LONG
DECLARE FUNCTION SafeArrayGetElemsize LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetElemsize" (BYVAL psa AS DWORD) AS DWORD
DECLARE FUNCTION SafeArrayGetIID LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetIID" (BYVAL psa AS DWORD, BYREF pguid AS GUID) AS LONG
DECLARE FUNCTION SafeArrayGetLBound LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetLBound" (BYVAL psa AS DWORD, BYVAL nDim AS WORD, BYREF plLbound AS LONG) AS LONG
DECLARE FUNCTION SafeArrayGetUBound LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetUBound" (BYVAL psa AS DWORD, BYVAL nDim AS WORD, BYREF plUbound AS LONG) AS LONG
DECLARE FUNCTION SafeArrayGetRecordInfo LIB "OLEAUT32.DLL" ALIAS "SafeArrayGetRecordInfo" (BYVAL psa AS DWORD, BYREF prinfo AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayGetVartype LIB "OLEAUT32.DLL" ALIAS " SafeArrayGetVartype" (BYVAL psa AS DWORD, BYREF pvt AS WORD) AS LONG
DECLARE FUNCTION SafeArrayLock LIB "OLEAUT32.DLL" ALIAS "SafeArrayLock" (BYVAL psa AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayPtrOfIndex LIB "OLEAUT32.DLL" ALIAS "SafeArrayPtrOfIndex" (BYVAL psa AS DWORD, BYVAL rgIndices AS DWORD, BYREF ppvData AS ANY) AS LONG
DECLARE FUNCTION SafeArrayPutElement LIB "OLEAUT32.DLL" ALIAS "SafeArrayPutElement" (BYVAL psa AS DWORD, BYVAL rgIndices AS DWORD, BYREF pv AS ANY) AS LONG
DECLARE FUNCTION SafeArrayRedim LIB "OLEAUT32.DLL" ALIAS "SafeArrayRedim" (BYVAL psa AS DWORD, BYREF psaboundNew AS SAFEARRAYBOUND) AS LONG
DECLARE FUNCTION SafeArraySetIID LIB "OLEAUT32.DLL" ALIAS "SafeArraySetIID" (BYVAL psa AS DWORD, BYREF pguid AS GUID) AS LONG
DECLARE FUNCTION SafeArraySetRecordInfo LIB "OLEAUT32.DLL" ALIAS "SafeArraySetRecordInfo" (BYVAL psa AS DWORD, BYVAL prinfo AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayUnaccessData LIB "OLEAUT32.DLL" ALIAS "SafeArrayUnaccessData" (BYVAL psa AS DWORD) AS LONG
DECLARE FUNCTION SafeArrayUnlock LIB "OLEAUT32.DLL" ALIAS "SafeArrayUnlock" (BYVAL psa AS DWORD) AS LONG
' ****************************************************************************************

' ****************************************************************************************
' ERRORINFO structure
' ****************************************************************************************
TYPE ERRORINFO
   hrError AS DWORD       ' // The code returned by the method.
   dwMinor AS DWORD       ' // A provider-specific error code.
   clsid AS GUID          ' // The class ID of the object that returned the error.
   iid AS GUID            ' // The interface ID of the interface that generated the error.
   dispid AS LONG         ' // Optional and provider-specific. Could be used, for example, to indicate the method that returned the error.
END TYPE
' ****************************************************************************************

' ****************************************************************************************
' Error handling API functions
' ****************************************************************************************
DECLARE FUNCTION CreateErrorInfo LIB "OLEAUT32.DLL" ALIAS "CreateErrorInfo" (BYVAL pperrinfo AS DWORD) AS LONG
DECLARE FUNCTION GetErrorInfo LIB "OLEAUT32.DLL" ALIAS "GetErrorInfo" (BYVAL dwReserved AS DWORD, BYREF pperrinfo AS DWORD) AS LONG
DECLARE FUNCTION SetErrorInfo LIB "OLEAUT32.DLL" ALIAS "SetErrorInfo" (BYVAL dwReserved AS DWORD, BYVAL perrinfo AS DWORD) AS LONG
' ****************************************************************************************

' ****************************************************************************************
' Puts the address of an object in a variant and marks it as containing a dispatch variable
' ****************************************************************************************
FUNCTION TB_MakeDispatchVariant (BYVAL lpObj AS DWORD, BYREF vObj AS VARIANT) AS LONG
   LOCAL lpvObj AS VARIANTAPI PTR                 ' Pointer to a VARIANTAPI structure
   LET vObj = EMPTY                               ' Make sure is empty to avoid memory leaks
   lpvObj = VARPTR(vObj)                          ' Get the VARIANT address
   @lpvObj.vt = %VT_DISPATCH                      ' Mark it as containing a dispatch variable
   @lpvObj.vd.pdispVal = lpObj                    ' Set the dispatch pointer address
   IF lpObj THEN IUnknown_AddRef lpObj            ' Increase the reference count
   FUNCTION = -1
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Makes a boolean variant with the %VT_BOOL flag set.
' ****************************************************************************************
FUNCTION TB_MakeBoolVariant (BYREF vVar AS VARIANT, BYVAL fBool AS INTEGER) AS LONG
   LOCAL hr AS LONG
   LOCAL vApi AS VARIANTAPI
   VariantInit vApi
   vApi.vt = %VT_BOOL
   IF fBool THEN vApi.vd.boolVal = -1
   hr = VariantCopy(vVar, vApi)
   FUNCTION = hr
   VariantClear vApi
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Makes a boolean variant with the %VT_BOOL | %VT_BYREF flags set.
' ****************************************************************************************
FUNCTION TB_MakeByRefBoolVariant (BYREF vVar AS VARIANT, BYVAL fBool AS INTEGER) AS LONG
   LOCAL hr AS LONG
   LOCAL vApi AS VARIANTAPI
   LOCAL value AS INTEGER
   VariantInit vApi
   vApi.vt = %VT_BOOL OR %VT_BYREF
   IF fBool THEN value = -1
   vApi.vd.pboolVal = VARPTR(value)
   hr = VariantCopy(vVar, vApi)
   FUNCTION = hr
   VariantClear vApi
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to return the type of a variant given his address.
' ****************************************************************************************
FUNCTION TB_VarType (BYVAL pv AS DWORD) AS DWORD
   LOCAL pvt AS VARIANT PTR
   IF pv = 0 THEN EXIT FUNCTION
   pvt = pv
   FUNCTION = VARIANTVT(@pvt)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to read the contents of a VARIANT containing an string given his address.
' This can be used to retrieve the result of functions that return the adddress of a
' variant as the result.
' ****************************************************************************************
FUNCTION TB_VarToStr (BYVAL pv AS DWORD) AS STRING
   LOCAL pvt AS VARIANT PTR
   IF pv = 0 THEN EXIT FUNCTION
   pvt = pv
   FUNCTION = VARIANT$(@pvt)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to read the contents of a VARIANT containing a numeric value given its
' address. This can be used to retrieve the result of functions that return the adddress
' of a variant as the result.
' ****************************************************************************************
FUNCTION TB_VarToNum (BYVAL pv AS DWORD) AS EXT
   LOCAL pvt AS VARIANT PTR
   IF pv = 0 THEN EXIT FUNCTION
   pvt = pv
   FUNCTION = VARIANT#(@pvt)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to read the contents of a VARIANT containing an unicode string.
' This function complements VARIANT$, that returns an ansi string.
' ****************************************************************************************
FUNCTION TB_VarToUnicode (BYREF vVar AS VARIANT) AS STRING
   LOCAL pv AS VARIANTAPI PTR
   pv = VARPTR(vVar)
   IF @pv.vt = %VT_BSTR THEN FUNCTION = PEEK$(@pv.vd.bstrVal, lstrlenW(BYVAL @pv.vd.bstrVal) * 2)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to read the contents of a VARIANT containing a reference to an unicode string.
' ****************************************************************************************
FUNCTION TB_VarByRefToUnicode (BYREF vVar AS VARIANT) AS STRING
   LOCAL pv AS VARIANTAPI PTR
   pv = VARPTR(vVar)
   IF (@pv.vt = %VT_BSTR OR %VT_BYREF) THEN FUNCTION = PEEK$(@pv.vd.@pbstrVal, lstrlenW(BYVAL @pv.vd.@pbstrVal) * 2)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to map an unicode string, given its address, to a new character string.
' This and the following function are needed to extract the contents of and UTF8 or UTF7
' encoded string contained in a variant.
' ****************************************************************************************
FUNCTION TB_WideCharToMultiByteCP (BYVAL u AS LONG, BYVAL CodePage AS DWORD) AS STRING

   DIM Buffer AS STRING
   DIM x AS STRING
   DIM l AS LONG
   DIM hr AS DWORD

   l = lstrlenW(BYVAL u)
   x = PEEK$(u, l * 2)

   ' // Get the number of bytes required for the buffer for ANSI string.
   ' // Useful to avoid a possible buffer overrun.
   ' // When we call WideCharToMultiByte passing 0 as the len of the Ansi
   ' // buffer, the function returns the needed size as the result.

   ' // Note: cchWideChar is the number of wide characters contained in the unicode
   ' // string to convert, that is l or LEN(x) \ 2, not LEN(x), because each unicode
   ' // character uses 2 bytes.

   hr = WideCharToMultiByte (CodePage, _        ' code page
                             %NULL, _           ' performance and mapping flags
                             BYVAL STRPTR(x), _ ' Unicode string to convert
                             l, _               ' cchWideChar : number of wide chars in string
                             BYVAL %NULL, _     ' buffer for ANSI string
                             0, _               ' len of ANSI buffer
                             BYVAL %NULL, _     ' default for unmappable chars
                             BYVAL %NULL)       ' default flag

   IF hr = 0 THEN EXIT FUNCTION
   Buffer = SPACE$(hr)

   ' // Convert the string. Returns the number of characters written in Buffer.
   ' // Note: Includes the byte for the null terminator, but only when we pass
   ' // an ASCIIZ string (something that the MSDN documentation don't specify),
   ' // and we are using a dynamic string. Some functions posted in the forums
   ' // use FUNCTION = LEFT$(Buffer, INSTR(Buffer, CHR$(0)) - 1), but that is
   ' // because they are using dynamic strings that contain an embedded null terminator.
   ' // To simulate the behavior of asciiz strings, pass -1 instead of l in the
   ' // ccWideChar parameter (also in the above function). In this case you will
   ' // need to trim the null terminator.

   hr = WideCharToMultiByte (CodePage, _             ' code page
                             %NULL, _                ' performance and mapping flags
                             BYVAL STRPTR(x), _      ' Unicode string to convert
                             l, _                    ' cchWideChar : number of wide chars in string
                             BYVAL STRPTR(Buffer), _ ' buffer for ANSI string
                             LEN(Buffer), _          ' len of ANSI buffer
                             BYVAL %NULL, _          ' default for unmappable chars
                             BYVAL %NULL)            ' default flag

   IF hr = 0 THEN EXIT FUNCTION

   FUNCTION = Buffer

   ' // We don't need to trim Buffer because we have calculated the exact size
   ' // needed before converting the string, but you can also use:
   ' FUNCTION = LEFT$(Buffer, hr)

END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to extract an unicode string contained in a variant and map it to an
' encoded UTF8 code page.
' ****************************************************************************************
FUNCTION TB_VarToUTF8 (BYREF vVar AS VARIANT) AS STRING
   LOCAL pv AS VARIANTAPI PTR
   pv = VARPTR(vVar)
   IF @pv.vt = %VT_BSTR THEN FUNCTION = TB_WideCharToMultiByteCP(@pv.vd.bstrVal, %CP_UTF8)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Helper function to extract an unicode string contained in a variant and map it to an
' encoded UTF7 code page.
' ****************************************************************************************
FUNCTION TB_VarToUTF7 (BYREF vVar AS VARIANT) AS STRING
   LOCAL pv AS VARIANTAPI PTR
   pv = VARPTR(vVar)
   IF @pv.vt = %VT_BSTR THEN FUNCTION = TB_WideCharToMultiByteCP(@pv.vd.bstrVal, %CP_UTF7)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Converts a null terminated Unicode string to Ansi, given his address.
' ****************************************************************************************
FUNCTION TB_WstrToAnsi (BYVAL lpwstr AS DWORD) AS STRING
   LOCAL wstrlen AS LONG
   IF lpwstr = %NULL THEN EXIT FUNCTION
   wstrlen = lstrlenW(BYVAL lpwstr)
   IF ISTRUE wstrlen THEN FUNCTION = ACODE$(PEEK$(lpwstr, wstrlen * 2))
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Converts a null terminated Unicode string to a PB Ansi Unicode string, given his address.
' ****************************************************************************************
FUNCTION TB_WstrToChar (BYVAL lpwstr AS DWORD) AS STRING
   LOCAL wstrlen AS LONG
   IF lpwstr = %NULL THEN EXIT FUNCTION
   wstrlen = lstrlenW(BYVAL lpwstr)
   IF ISTRUE wstrlen THEN FUNCTION = PEEK$(lpwstr, wstrlen * 2)
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Creates an instance of an object.
' Parameters:
' strProgID
'   Required. String. The ProgID or the CLSID of the object to create.
' ppv
'   Required. Dword. Address of pointer variable that receives the interface pointer.
'   Upon failure, ppv contains %NULL.
' Return value:
'   One of the standard HRESULT values or %S_OK
' ****************************************************************************************
FUNCTION TB_CreateObject (BYVAL strProgID AS STRING, BYREF ppv AS DWORD) EXPORT AS LONG

    LOCAL hr AS LONG                    ' HRESULT
    LOCAL pUnknown AS DWORD             ' IUnknown pointer
    LOCAL pDispatch AS DWORD            ' IDispatch pointer
    LOCAL IID_NULL AS GUID              ' Null GUID
    LOCAL IID_IUnknown AS GUID          ' Iunknown GUID
    LOCAL IID_IDispatch AS GUID         ' IDispatch GUID
    LOCAL ClassID AS GUID               ' CLSID

    ' Standard interface GUIDs
    IID_NULL = GUID$("{00000000-0000-0000-0000-000000000000}")
    IID_IUnknown = GUID$("{00000000-0000-0000-c000-000000000046}")
    IID_IDispatch = GUID$("{00020400-0000-0000-c000-000000000046}")

    ' Exit if strProgID is a null string
    IF strProgID = "" THEN
       FUNCTION = %E_INVALIDARG
       EXIT FUNCTION
    END IF

    ' Convert the ProgID in a CLSID
    ClassID = CLSID$(strProgID)

    ' If it fails, see if it is a CLSID
    IF ClassID = IID_NULL THEN ClassID = GUID$(strProgID)

    ' If not a valid ProgID or CLSID return an error
    IF ClassID = IID_NULL THEN
       FUNCTION = %E_INVALIDARG
       EXIT FUNCTION
    END IF

    ' Create an instance of the object
    ' Context: &H17 (%CLSCTX_ALL) =
    ' %CLSCTX_INPROC_SERVER OR %CLSCTX_INPROC_HANDLER OR _
    ' %CLSCTX_LOCAL_SERVER OR %CLSCTX_REMOTE_SERVER
    hr = CoCreateInstance(ClassID, BYVAL %NULL, &H17, IID_IUnknown, pUnknown)
    IF hr <> %S_OK OR pUnknown = %NULL THEN
       FUNCTION = hr
       EXIT FUNCTION
    END IF

    ' Ask for the dispatch interface
    hr = IUnknown_QueryInterface(pUnknown, IID_IDispatch, pDispatch)

    ' If it fails, return the Iunknown interface
    IF hr <> %S_OK OR pDispatch = %NULL THEN
       ppv = pUnknown
       FUNCTION = %S_OK
       EXIT FUNCTION
    END IF

    ' Release the IUnknown interface
    IUnknown_Release pUnknown

    ' Return a pointer to the dispatch interface
    ppv = pDispatch
    FUNCTION = %S_OK

END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' OCX support
' ****************************************************************************************

DECLARE FUNCTION CoGetClassObject LIB "OLE32.DLL" ALIAS "CoGetClassObject" (rclsid AS GUID, BYVAL dwclsContext AS DWORD, BYVAL pServerInfo AS DWORD, riid AS GUID, ppv AS DWORD) AS DWORD
DECLARE FUNCTION AtlAxWinInit LIB "ATL71.DLL" ALIAS "AtlAxWinInit" () AS LONG
DECLARE FUNCTION AtlAxGetControl LIB "ATL71.DLL" ALIAS "AtlAxGetControl" (BYVAL hWnd AS DWORD, BYREF pp AS DWORD) AS DWORD
DECLARE FUNCTION AtlAxAttachControl LIB "ATL71.DLL" ALIAS "AtlAxAttachControl" (BYVAL pControl AS DWORD, BYVAL hWnd AS DWORD, BYREF ppUnkContainer AS DWORD) AS DWORD
DECLARE FUNCTION AtlAxCreateControlLic LIB "ATL71.DLL" ALIAS "AtlAxCreateControlLic" (BYVAL lpszName AS DWORD, BYVAL hParent AS DWORD, _
                 BYVAL pStream AS DWORD, BYREF ppUnkContainer AS DWORD, BYVAL bstrLic AS DWORD) AS DWORD

' ****************************************************************************************
' IClassFactory2::CreateInstanceLic
' Creates an instance of the object class supported by this class factory, given a license key
' previously obtained from IClassFactory2::RequestLicKey. This method is the only possible means
' to create an object on an otherwise unlicensed machine.
' ****************************************************************************************
FUNCTION IClassFactory2_CreateInstanceLic (BYVAL pthis AS DWORD PTR, BYVAL pUnkOuter AS DWORD, BYVAL pUnkReserved AS DWORD, BYREF riid AS GUID, BYVAL pbstrKey AS DWORD, BYREF ppvObj AS DWORD) AS LONG
   LOCAL HRESULT AS LONG
   CALL DWORD @@pthis[7] USING IClassFactory2_CreateInstanceLic(pthis, pUnkOuter, pUnkReserved, riid, pbStrKey, ppvObj) TO HRESULT
   FUNCTION = HRESULT
END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Creates a licensed instance of a visual control (OCX) and attaches it to a window.
' StrProgID can be the ProgID or the ClsID. If you pass a version dependent ProgID or a ClsID,
' it will work only with this particular version.
' hWndControl is the handle of the window and strLicKey the license key.
' ****************************************************************************************
FUNCTION TB_CreateControlLic (BYVAL strProgID AS STRING, BYVAL hWndControl AS DWORD, BYVAL strLicKey AS STRING) AS LONG

    LOCAL HRESULT AS LONG               ' Result code
    LOCAL ppUnknown AS DWORD            ' IUnknown pointer
    LOCAL ppDispatch AS DWORD           ' IDispatch pointer
    LOCAL ppObj AS DWORD                ' Dispatch interface of the control
    LOCAL ppClassFactory2 AS DWORD      ' IClassFactory2 pointer
    LOCAL ppUnkContainer AS DWORD       ' IUnknown of the container
    LOCAL IID_NULL AS GUID              ' Null GUID
    LOCAL IID_IUnknown AS GUID          ' Iunknown GUID
    LOCAL IID_IDispatch AS GUID         ' IDispatch GUID
    LOCAL IID_IClassFactory2 AS GUID    ' IClassFactory2 GUID
    LOCAL ClassID AS GUID               ' CLSID
    LOCAL pbstrLicKey AS STRING         ' Unicode license key string

    pbstrLicKey = UCODE$(strLicKey)     ' Convert the license key to Unicode

    ' Standard interface GUIDs
    IID_NULL = GUID$("{00000000-0000-0000-0000-000000000000}")
    IID_IUnknown = GUID$("{00000000-0000-0000-c000-000000000046}")
    IID_IDispatch = GUID$("{00020400-0000-0000-c000-000000000046}")
    IID_IClassFactory2 = GUID$("{b196b28f-bab4-101a-b69c-00aa00341d07}")

    ' Exit if strProgID is a null string
    IF strProgID = "" THEN
       FUNCTION = &H80070057 ' %E_INVALIDARG
       EXIT FUNCTION
    END IF

    ' Convert the ProgID to a CLSID
    ClassID = CLSID$(strProgID)

    ' If it fails, see if it is a CLSID
    IF ClassID = IID_NULL THEN ClassID = GUID$(strProgID)

    ' If not a valid ProgID or CLSID return an error
    IF ClassID = IID_NULL THEN
       FUNCTION = &H80070057 ' %E_INVALIDARG
       EXIT FUNCTION
    END IF

    ' Get a reference to the IClassFactory2 interface of the control
    ' Context: &H17 (%CLSCTX_ALL) =
    ' %CLSCTX_INPROC_SERVER OR %CLSCTX_INPROC_HANDLER OR _
    ' %CLSCTX_LOCAL_SERVER OR %CLSCTX_REMOTE_SERVER
    HRESULT = CoGetClassObject(ClassID, &H17, %NULL, IID_IClassFactory2, ppClassFactory2)
    IF ISTRUE HRESULT THEN
       FUNCTION = HRESULT
       EXIT FUNCTION
    END IF

    ' Create a licensed instance of the control
    HRESULT = IClassFactory2_CreateInstanceLic(ppClassFactory2, %NULL, %NULL, IID_IUnknown, STRPTR(pbstrLicKey), ppUnknown)
    ' First release the IClassFactory2 interface
    IUnknown_Release ppClassFactory2
    IF HRESULT <> %S_OK OR ppUnknown = %NULL THEN
       FUNCTION = HRESULT
       EXIT FUNCTION
    END IF

    ' Ask for the dispatch interface of the control
    HRESULT = IUnknown_QueryInterface(ppUnknown, IID_IDispatch, ppDispatch)

    ' If it fails, use the IUnknown of the control, else use IDispatch
    IF HRESULT <> %S_OK OR ppDispatch = %NULL THEN
       ppObj = ppUnknown
    ELSE
       ' Release the IUnknown interface
       IUnknown_Release ppUnknown
       ppObj = ppDispatch
    END IF

    ' Attach the control to the window
    HRESULT = AtlAxAttachControl(ppObj, hWndControl, ppUnkContainer)

    ' Note: Do not release ppObj or your application will GPF when it ends because
    ' ATL will release it when the window that hosts the control is destroyed.

    FUNCTION = HRESULT

END FUNCTION
' ****************************************************************************************

' ****************************************************************************************
' Retrieves the interface of the ActiveX control given the handle of its ATL container
' ****************************************************************************************
FUNCTION AtlAxGetDispatch (BYVAL hWndControl AS DWORD, BYREF ppvObj AS DWORD) AS LONG

    LOCAL HRESULT AS LONG, ppUnk AS DWORD, ppDispatch AS DWORD, IID_IDispatch AS GUID
    ' Get the IUnknown of the OCX hosted in the control
    HRESULT = AtlAxGetControl(hWndControl, ppUnk)
    IF HRESULT <> %S_OK OR ppUnk = %NULL THEN
       FUNCTION = HRESULT
       EXIT FUNCTION
    END IF
    ' Query for the existence of the dispatch interface
    IID_IDispatch = GUID$("{00020400-0000-0000-c000-000000000046}")
    HRESULT = IUnknown_QueryInterface(ppUnk, IID_IDispatch, ppDispatch)
    ' If not found, return the IUnknown of the control
    IF HRESULT <> %S_OK OR ppDispatch = %NULL THEN
       ppvObj = ppUnk
       EXIT FUNCTION
    END IF
    ' Release the IUnknown of the control
    IUnknown_Release ppUnk
    ' Return the retrieved address
    ppvObj = ppDispatch
    ' Return the error code
    FUNCTION = HRESULT

END FUNCTION
' ****************************************************************************************
