%DISPATCH_METHOD         = 1  ' The member is called using a normal function invocation syntax.
%DISPATCH_PROPERTYGET    = 2  ' The function is invoked using a normal property-access syntax.
%DISPATCH_PROPERTYPUT    = 4  ' The function is invoked using a property value assignment syntax.
%DISPATCH_PROPERTYPUTREF = 8  ' The function is invoked using a property reference assignment syntax.

' ****************************************************************************************
' CallByName - Generic function to call COM methods and properties.
' Parameters:
'   pthis : Address of a pointer to IDispatch.
'   vNameOrId : Name of the method or property, or identifier number (DispID).
'   callType : Flags describing the context of the Invoke call:
'     %DISPATCH_METHOD
'       The member is invoked as a method. If a property has the same name, both this and the
'       %DISPATCH_PROPERTYGET flag may be set.
'     %DISPATCH_PROPERTYGET
'       The member is retrieved as a property or data member.
'     %DISPATCH_PROPERTYPUT
'       The member is changed as a property or data member.
'     %DISPATCH_PROPERTYPUTREF
'       The member is changed by a reference assignment, rather than a value assignment. This
'       flag is valid only when the property accepts a reference to an object.
'   vParams() : Array of variant parameters. EMPTY variants are considered as optionals by
'       the function, that assigns to the them the value ERROR %DISP_E_PARAMNOTFOUND. This
'       is the standard way to deal with optional parameters in COM programming.
'       If the method or property has not values pass BYVAL %NULL.
'   vResult : Variant where the result is to be stored (pass BYVAL %NULL if you expect no result.
'       This argument is ignored if DISPATCH_PROPERTYPUT or DISPATCH_PROPERTYPUTREF is specified.
'   pex : Address of an EXCEPINFO structure where to return error information. Can be %NULL.
'       This structure is only filled when the error returned is %DISP_E_EXCEPTION.
' ****************************************************************************************
FUNCTION TB_CallByName ( _
    BYVAL pthis AS DWORD, _                                    ' *IDispatch
    BYVAL vNameOrId AS VARIANT, _                              ' Name or identifier
    BYVAL callType AS LONG, _                                  ' Call type
    BYREF vParams() AS VARIANT, _                              ' Array of variants
    BYREF vResult AS VARIANT, _                                ' Variant result
    BYREF pex AS EXCEPINFO _                                   ' EXCEPINFO structure
    ) EXPORT AS LONG                                           ' Error code

    DIM dw_puArgErr AS DWORD, DISPID_PROPERTYPUT AS LONG, IID_NULL AS GUID
    DIM vArgs(0) AS VARIANT, udt_DispParams AS DISPPARAMS
    DIM hr AS LONG, strName AS STRING, DispID AS LONG
    DIM nParams AS LONG, i AS LONG, idx AS LONG

    ' Check for null pointer
    IF pthis = 0 THEN FUNCTION = %E_POINTER : EXIT FUNCTION

    ' Get the DispID
    IF VARIANTVT(vNameOrId) = %VT_BSTR THEN
       strName = UCODE$(VARIANT$(vNameOrId))
       hr = IDispatch_GetIDOfName(pthis, strName, DispID)
       IF hr THEN
          FUNCTION = hr
          EXIT FUNCTION
       END IF
    ELSE
       DispID = VARIANT#(vNameOrId)
    END IF

    ' Copy the array in reversed order
    IF VARPTR(vParams()) THEN
       nParams = UBOUND(vParams) - LBOUND (vParams) + 1
       IF nParams > 0 THEN
          REDIM vArgs(nParams - 1)
          idx = nParams - 1
          FOR i = LBOUND(vParams) TO UBOUND(vParams)
             IF VARIANTVT(vParams(i)) = %VT_EMPTY THEN
                vArgs(idx) = ERROR %DISP_E_PARAMNOTFOUND
             ELSE
                vArgs(idx) = vParams(i)
             END IF
             DECR idx
             IF idx < 0 THEN EXIT FOR
          NEXT
       END IF
   END IF

   IF CallType = 4 OR CallType = 8 THEN  ' %DISPATCH_PROPERTYPUT and %DISPATCH_PROPERTYPUTREF
      DISPID_PROPERTYPUT = -3
      udt_DispParams.CountNamed = 1
      udt_DispParams.NamedDispId = VARPTR(DISPID_PROPERTYPUT)
   END IF

   udt_DispParams.CountArgs = nParams
   IF nParams > 0 THEN udt_DispParams.VariantArgs = VARPTR(vArgs(0))

   FUNCTION = IDispatch_Invoke(pthis, DispID, IID_NULL, 0, CallType, udt_DispParams, vResult, pex, dw_puArgErr)

END FUNCTION
' ****************************************************************************************
