/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "symbol.h"

class Process;

/*! @brief list of BookmarkProcess

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_BOOKMARKLIST, 0)
*/
class BookmarkList : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get BookmarkProcess by Process
		@param pProcess process of BookmarkProcess to get
		@returns pointer to BookmarkProcess, or NULL if not found
	*/
	virtual Symbol* ChildByProcess(Process *pProcess);
	/*!	@brief get BookmarkProcess by id
		@param id id of BookmarkProcess to get
		@returns pointer to BookmarkProcess, or NULL if not found
	*/
	virtual Symbol* ChildById(DWORD id);

	/*!	@brief load contents of BookmarkList
		@param fileName full path of file to load contents from
		@returns nonezero if sucessfully
		@remarks contents may be partially loaded, when returning zero
	*/
	virtual BOOL Load(LPCSTR fileName);
	/*!	@brief store contents of BookmarkList
		@param fileName full path of file to store contents to
		@returns nonezero if sucessfully
	*/
	virtual BOOL Store(LPCSTR fileName);

	/*!	@brief add BookmarkProcess to BookmarkList
		@param pProcess Process for BookmarkProcess
		@returns pointer to BookmarkProcess
		@remarks may return a pointer to an already existing BookmarkProcess
	*/
	virtual Symbol* AddProcess(Process *pProcess);
	/*!	@brief add Bookmark
		@details add BookmarkProcess to BookmarkList and Bookmark to BookmarkProcess
		@param pProcess  Process for BookmarkProcess to add
		@param address va of Bookmark to add
		@param comment comment of Bookmark to add, may be NULL
		@returns pointer to newly added Bookmark
		@remarks @em va has not be unique vithin BookmarkProcess
	*/
	virtual Symbol* AddBookmark(Process *pProcess,DWORDLONG address,LPCSTR comment);
};


/*! @brief per Process Bookmark s

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_BOOKMARKPROCESS, 0)
*/
class BookmarkProcess : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get Bookmark by id
		@param id id of Bookmark to get
		@returns pointer to Bookmark or NULL if none found
	*/
	virtual Symbol* ChildById(DWORD id);

	/*!	@brief get BookmarkProcess id
		@returns id of BookmarkProcess
		@remarks id is unique whithin BookmarkList
	*/
	virtual DWORD Id() const;

	/*!	@brief get the Process
		@returns Process having name Name(), or NULL if none found
	*/		
	virtual Symbol *GetProcess();

	/*!	@brief add Bookmark for this process
		@param address va of Bookmark to add
		@param comment comment of Bookmark to add, may be NULL
		@returns pointer to newly added Bookmark
		@remarks @em va has not be unique vithin BookmarkProcess
	*/
	virtual Symbol *AddBookmark(DWORDLONG address,LPCSTR comment);
};

/*! @brief %Bookmark

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_BOOKMARK, 0)
	@remarks bookmarks are invariant to relocation
*/
class Bookmark : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get Bookmark id
		@returns id of bookmark
		@remarks id is unique whithin BookmarkProcess
	*/
	virtual DWORD Id() const;
	/*!	@brief get Module name
		@returns name of bounding module at creation time, or NULL if none
	*/
	virtual LPCSTR ModuleName() const;

	/*!	@brief set Bookmark comment
		@param name user comment
	*/
	virtual void SetComment(LPCSTR name);
};
