/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#define MSG_BROADCAST (WM_APP+10)

/*! @defgroup BROADCAST_xxx Broadcast types*/
//@{
#define BROADCAST_MESSAGE 0
#define BROADCAST_SYMBOL 1
#define BROADCAST_DATA 2
//@}


#define H_WAIT	0x8000

#define H_PROJECT_NEW 1
#define H_PROJECT_OPEN 2
#define H_PROJECT_CLOSE 3

#define H_RESERVED 5

#define H_DEBUG_ENTER 10
#define H_DEBUG_LEAVE (11 | H_WAIT)

#define H_INTERFACE_ADD 20
#define H_INTERFACE_REMOVE 21

#define H_DEBUG_ADD 22
#define H_DEBUG_REMOVE 23

#define H_PROCESS_ADD (24 | H_WAIT)
#define H_PROCESS_REMOVE (25 | H_WAIT)

#define H_MODULE_ADD (26 | H_WAIT)
#define H_MODULE_REMOVE (27 | H_WAIT)

#define H_THREAD_ADD (28 | H_WAIT)
#define H_THREAD_REMOVE (29 | H_WAIT)

#define H_BREAKPOINT_ADD (30 | H_WAIT)
#define H_BREAKPOINT_REMOVE (31 | H_WAIT)
#define H_BREAKPOINT_CHANGED 32

#define H_PATCH_ADD 35
#define H_PATCH_REMOVE 36

#define H_SYMBOL_ADD (37 | H_WAIT)
#define H_SYMBOL_REMOVE (38 | H_WAIT)

#define H_PLUGIN_LOAD 39
#define H_PLUGIN_UNLOAD 40

#define H_FRAME_CHANGED 45

#define H_FRAME_SELECT 50
#define H_THREAD_SELECT 51
#define H_PROCESS_SELECT 52
#define H_DEBUG_SELECT 53

#define H_MEMORY_CHANGED 60
#define H_REGISTER_CHANGED 61

#define H_BREAKPOINT (80 | H_WAIT)

#define H_LOADER_IDLE 100
#define H_INTERRUPT_THREAD 101

#define H_SETTINGS_CHANGED 110

#define H_RECEIVE_DATA 120

#define H_NAVBAR 152


#define H_USER 1000


#define SET_FONT "font"
#define SET_COLOR "color"
#define SET_DISASM "disasm"
#define SET_MEMORY "memory"
#define SET_LOCATION "location"
#define SET_KEYBOARD "keyboard"
#define SET_LAYOUT "layout"
#define SET_LOADER "loader"
#define SET_PROJECT "project"
#define SET_VIDEO "video"
#define SET_WINTRUDER "wintruder"
#define SET_LOG "log"

#define SET_DEBUGX86 "debug_x86"
