/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

/*************
	ConfigNode
*************/
class ConfigNode : public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual void SetValue(LPCSTR pszValue);
	virtual LPCSTR GetValue();

	virtual void SetDefault(LPCSTR pszDefault);
	virtual LPCSTR GetDefault();

	virtual void SetKind(DWORD nKind);
	virtual DWORD GetKind() const;

	virtual BOOL IsDefault() const;

	virtual LPCSTR GetValue(LPCSTR pszPath,int nElement=-1,LPCSTR pszDefault=NULL);
	virtual BOOL SetValue(LPCSTR pszPath,LPCSTR pszValue,int nElement=-1,LPCSTR pszDefault=NULL);
	virtual LPCSTR GetAttribute(LPCSTR pszPath,LPCSTR pszAttribute,int nElement=-1,LPCSTR pszDefault=NULL);
	virtual BOOL SetAttribute(LPCSTR pszPath,LPCSTR pszAttribute,LPCSTR pszValue,int nElement=-1,LPCSTR pszDefault=NULL);

	virtual BOOL DeleteValue(LPCSTR pszPath,int nElement=-1);
	virtual BOOL DeleteAttribute(LPCSTR pszPath,LPCSTR pszAttribute,int nElement=-1);
	virtual BOOL DeleteElement(LPCSTR pszPath,int nElement=-1);

	virtual Symbol* GetElement(LPCSTR pszPath,int nElement=-1);
	virtual Symbol* CreateElement(LPCSTR pszPath,int nElement=-1);
	virtual BOOL DeleteElementList(LPCSTR pszPath);
	virtual int CountElementList(LPCSTR pszPath);

	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,bool &nValue,bool nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,char &nValue,char nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,unsigned char &nValue,unsigned char nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,short &nValue,short nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,unsigned short &nValue,unsigned short nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,int &nValue,int nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,unsigned int &nValue,unsigned int nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,__int64 &nValue,__int64 nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,unsigned __int64 &nValue,unsigned __int64 nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,long &nValue,long nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,unsigned long &nValue,unsigned long nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,float &nValue,float nDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,double &nValue,double nDefault,BOOL bStore,int nElement=-1);
	virtual UINT Config(LPCSTR pszPath,LPCSTR pszValue,LPSTR pnValue,UINT nValue,LPCSTR pszDefault,BOOL bStore,int nElement=-1);
	virtual BOOL Config(LPCSTR pszPath,LPCSTR pszValue,LPCSTR pnValue,LPCSTR pszDefault,int nElement=-1);
};

/*************
	ConfigFile
*************/
class ConfigFile : public ConfigNode
{
public:
/*************
	introducing virtual
*************/
	virtual BOOL LoadXml(LPCSTR xml);
	virtual BOOL Load(LPCSTR file);
	virtual BOOL Store(LPCSTR file=NULL);

	virtual LPCSTR GetError(int &nLine,int &nColumn);
	virtual LPCSTR Path() const;

	virtual BOOL IsModified() const;
	virtual void SetModified(BOOL bModified);

	virtual BOOL GetSparse() const;
	virtual void SetSparse(BOOL bSparse);

	virtual BOOL GetAutoStore() const;
	virtual void SetAutoStore(BOOL bAutoStore);

	virtual Symbol* GetRootElement();
	virtual Symbol* CreateRootElement(LPCSTR pszName);
};

/*************
	ConfigList
*************/
class ConfigList : public Symbol
{
public:
/*************
	introducing virtual
*************/
};
