/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

//prototypes
class Interface;
class Process;
class Thread;
class Exception;
struct _tag_RegisterMap;
struct _tag_RegisterSet;
struct _tag_LinkDesc;
class EVENT_Return;

/*************
	Debug
*************/
#ifdef _USER_SYMBOL
	#include "UserSymbol.h"
	#define _BASE_CLASS UserSymbol
#else
	#include "Symbol.h"
	#define _BASE_CLASS Symbol
#endif

/*!	@brief Debugger
	@details high level debug interface
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_DEBUG, @ref DEBUG_xxx "DEBUG_xxx")
*/
class Debug : public _BASE_CLASS
{
public:
/*************
	introducing virtual
*************/
	virtual BOOL Connect(Symbol *pSym);
	virtual POSITION FirstLinkPosition(DWORD nProcessType);
	virtual const _tag_LinkDesc* NextLink(POSITION &pos);
	virtual const DWORD* Compatibility(BOOL& bDefault);

	virtual DWORD Caps(Process *pProcess)=0;

	virtual void PrepareMemory(Process *pProcess,LPBYTE pBuffer,DWORDLONG base,DWORD size,BOOL bRead);

	virtual EVENT_Return OnException(Interface *pInterface,Thread *pThread,Exception *pEx,void *p)=0;

	virtual Symbol* SingleStep(Thread *pThread)=0;
	virtual Symbol* CodeBreakpoint(Symbol *pContext, DWORDLONG Address)=0;
	virtual Symbol* DataBreakpoint(Symbol *pContext, DWORDLONG Address)=0;
	virtual Symbol* AuxBreakpoint(Symbol *pContext,DWORDLONG Address);

	virtual const _tag_RegisterMap* GetRegisterMap(int &mapSize)=0;
	virtual const _tag_RegisterSet* GetRegisterSet(int registerSet,int &mapSize,LPCSTR *ppszName=NULL)=0;

	virtual Symbol* Disassembler()=0;
	virtual Symbol *GetFrame(Thread *p_tt,int number)=0;

	virtual BOOL InterruptThread(Thread *p_tt)=0;
	virtual BOOL TerminateThread(Thread *p_tt,BOOL bFinal)=0;
/*************
	constructor
*************/
#ifdef _USER_SYMBOL
	Debug(Symbol *pParent):_BASE_CLASS(pParent){}
#endif
};
#undef _BASE_CLASS


/*************
	DebugList
*************/
/*!	@brief list of Debug
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_DEBUGLIST,0)
*/
class DebugList : public Symbol
{
public:
/*************
	introducing virtual
*************/
};
