/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#pragma pack(push,1)

union EFLAGS
{
	DWORDLONG raw;
	struct
	{
		DWORD	CF:1;
		DWORD	reserved1:2-1;
		DWORD	PF:1;
		DWORD	reserved2:4-3;
		DWORD	AF:1;
		DWORD	reserved3:6-5;
		DWORD	ZF:1;
		DWORD	SF:1;
		DWORD	TF:1;
		DWORD	IF:1;
		DWORD	DF:1;
		DWORD	OF:1;
		DWORD	IOPL:2;
		DWORD	NT:1;
		DWORD	reserved4:16-15;
		DWORD	RF:1;
		DWORD	VM:1;
		DWORD	AC:1;
		DWORD	VIF:1;
		DWORD	VIP:1;
		DWORD	ID:1;
		DWORD	reserved5:32-22;
	};
};
struct RegisterX86
{
	EFLAGS FLAGS;

	DWORDLONG EIP;

	DWORDLONG EAX;
	DWORDLONG ECX;
	DWORDLONG EDX;
	DWORDLONG EBX;
	DWORDLONG ESP;
	DWORDLONG EBP;
	DWORDLONG ESI;
	DWORDLONG EDI;

	DWORDLONG R8;
	DWORDLONG R9;
	DWORDLONG R10;
	DWORDLONG R11;
	DWORDLONG R12;
	DWORDLONG R13;
	DWORDLONG R14;
	DWORDLONG R15;

	WORD CS;
	WORD DS;
	WORD ES;
	WORD FS;
	WORD GS;
	WORD SS;

	DWORDLONG DR0;
	DWORDLONG DR1;
	DWORDLONG DR2;
	DWORDLONG DR3;
	DWORDLONG DR6;
	DWORDLONG DR7;

	FLOATING_SAVE_AREA FloatSave;
	BYTE ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];
};

enum
{
	debugX86REG_none=0,
	debugX86REG_AL,
	debugX86REG_CL,
	debugX86REG_DL,
	debugX86REG_BL,
	debugX86REG_AH,
	debugX86REG_CH,
	debugX86REG_DH,
	debugX86REG_BH,
	debugX86REG_AX,
	debugX86REG_CX,
	debugX86REG_DX,
	debugX86REG_BX,
	debugX86REG_SP,
	debugX86REG_BP,
	debugX86REG_SI,
	debugX86REG_DI,
	debugX86REG_EAX,
	debugX86REG_ECX,
	debugX86REG_EDX,
	debugX86REG_EBX,
	debugX86REG_ESP,
	debugX86REG_EBP,
	debugX86REG_ESI,
	debugX86REG_EDI,
	debugX86REG_ES,
	debugX86REG_CS,
	debugX86REG_SS,
	debugX86REG_DS,
	debugX86REG_FS,
	debugX86REG_GS,
	debugX86REG_IP,
	debugX86REG_FLAGS,
	debugX86REG_EIP,
	debugX86REG_EFLAGS,

	debugX86REG_TEMP=40,
	debugX86REG_TEMPH,

	debugX86REG_CR0=80,
	debugX86REG_CR1,
	debugX86REG_CR2,
	debugX86REG_CR3,
	debugX86REG_CR4,

	debugX86REG_DR0=90,
	debugX86REG_DR1,
	debugX86REG_DR2,
	debugX86REG_DR3,
	debugX86REG_DR4,
	debugX86REG_DR5,
	debugX86REG_DR6,
	debugX86REG_DR7,

	debugX86REG_GDTR=110,
	debugX86REG_GDTL,
	debugX86REG_IDTR,
	debugX86REG_IDTL,
	debugX86REG_LDTR,
	debugX86REG_TR,

	debugX86REG_ST=128,
	debugX86REG_ST0,
	debugX86REG_ST1,
	debugX86REG_ST2,
	debugX86REG_ST3,
	debugX86REG_ST4,
	debugX86REG_ST5,
	debugX86REG_ST6,
	debugX86REG_ST7,

	debugX86REG_CONTROL=138,
	debugX86REG_STATUS,
	debugX86REG_TAG,

	debugX86REG_MMX0=154,
	debugX86REG_MMX1,
	debugX86REG_MMX2,
	debugX86REG_MMX3,
	debugX86REG_MMX4,
	debugX86REG_MMX5,
	debugX86REG_MMX6,
	debugX86REG_MMX7,

	debugX86REG_XMM0=162,
	debugX86REG_XMM1,
	debugX86REG_XMM2,
	debugX86REG_XMM3,
	debugX86REG_XMM4,
	debugX86REG_XMM5,
	debugX86REG_XMM6,
	debugX86REG_XMM7,

	debugX86REG_RAX=170,
	debugX86REG_RCX,
	debugX86REG_RDX,
	debugX86REG_RBX,
	debugX86REG_RSP,
	debugX86REG_RBP,
	debugX86REG_RSI,
	debugX86REG_RDI,

	debugX86REG_R0B,	//a
	debugX86REG_R1B,	//c
	debugX86REG_R2B,	//d
	debugX86REG_R3B,	//b
	debugX86REG_R4B,	//sp
	debugX86REG_R5B,	//bp
	debugX86REG_R6B,	//si
	debugX86REG_R7B,	//di
	debugX86REG_R8B,
	debugX86REG_R9B,
	debugX86REG_R10B,
	debugX86REG_R11B,
	debugX86REG_R12B,
	debugX86REG_R13B,
	debugX86REG_R14B,
	debugX86REG_R15B,

	debugX86REG_R0W,	//a
	debugX86REG_R1W,	//c
	debugX86REG_R2W,	//d
	debugX86REG_R3W,	//b
	debugX86REG_R4W,	//sp
	debugX86REG_R5W,	//bp
	debugX86REG_R6W,	//si
	debugX86REG_R7W,	//di
	debugX86REG_R8W,
	debugX86REG_R9W,
	debugX86REG_R10W,
	debugX86REG_R11W,
	debugX86REG_R12W,
	debugX86REG_R13W,
	debugX86REG_R14W,
	debugX86REG_R15W,

	debugX86REG_R0D,	//a
	debugX86REG_R1D,	//c
	debugX86REG_R2D,	//d
	debugX86REG_R3D,	//b
	debugX86REG_R4D,	//sp
	debugX86REG_R5D,	//bp
	debugX86REG_R6D,	//si
	debugX86REG_R7D,	//di
	debugX86REG_R8D,
	debugX86REG_R9D,
	debugX86REG_R10D,
	debugX86REG_R11D,
	debugX86REG_R12D,
	debugX86REG_R13D,
	debugX86REG_R14D,
	debugX86REG_R15D,

	debugX86REG_R0,		//a
	debugX86REG_R1,		//c
	debugX86REG_R2,		//d
	debugX86REG_R3,		//b
	debugX86REG_R4,		//sp
	debugX86REG_R5,		//bp
	debugX86REG_R6,		//si
	debugX86REG_R7,		//di
	debugX86REG_R8,
	debugX86REG_R9,
	debugX86REG_R10,
	debugX86REG_R11,
	debugX86REG_R12,
	debugX86REG_R13,
	debugX86REG_R14,
	debugX86REG_R15,

	debugX86REG_RIP,
	debugX86REG_RFLAGS,

	debugX86REG_XMM8,
	debugX86REG_XMM9,
	debugX86REG_XMM10,
	debugX86REG_XMM11,
	debugX86REG_XMM12,
	debugX86REG_XMM13,
	debugX86REG_XMM14,
	debugX86REG_XMM15,

	debugX86REG_TR0,
	debugX86REG_TR1,
	debugX86REG_TR2,
	debugX86REG_TR3,
	debugX86REG_TR4,
	debugX86REG_TR5,
	debugX86REG_TR6,
	debugX86REG_TR7
};

#pragma pack(pop)
