/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Tool.h"
/*! @brief container storing frequently used path information
*/
class DirContainer : public Tool
{
public:
/*************
	introducing virtual
*************/
	/*! @brief set or add file/path to container
		@param pszId identifer of path
		@param pszFilePath file or path name to store
		@returns nonezero if successful
		@remarks @em pszId is caseinsensitive
		@remarks @em pszFilePath can be a path terminated by an backslash or any filename @n
			howsoever only the part predeceeding the final backslash is stored
	*/
	virtual BOOL Set(LPCSTR pszId,LPCSTR pszFilePath);
	/*!	@brief retrieve path from container
		@param pszId identifer of path
		@returns the path stored or NULL if @em pszId not found
		@remarks @em pszId is caseinsensitive
		@remarks the path returned is terminated by a backslash
		@remarks use @em pszId = "Main" or "Wintruder" to get the path of the wintruder executable
	*/
	virtual LPCSTR Get(LPCSTR pszId);
};