/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

struct DisasmData;
struct DisasmOperand;

/*************
	Disasm
*************/
#ifdef _USER_SYMBOL
	#include "UserSymbol.h"
	#define _BASE_CLASS UserSymbol
#else
	#include "symbol.h"
	#define _BASE_CLASS Symbol
#endif
/*!	@brief disassembler
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_DISASM, @ref DISASM_xxx "DISASM_xxx")
*/
class Disasm : public _BASE_CLASS
{
public:
/*************
	introducing virtual
*************/
	virtual int GetDataSize()=0;

	virtual DWORD GetNop()=0;
	virtual void IllegalOpcode(DisasmData *pds)=0;
	virtual BOOL Disassemble(Symbol *pContext,DWORDLONG Address,DisasmData *pds,DWORD nFlags=0)=0;

	virtual DWORDLONG Destination(Symbol *pContext,DisasmData *pds)=0;
	virtual UINT OpCount(DisasmData *pds) const=0;
	virtual const DisasmOperand* Op(DisasmData *pds,UINT i) const=0;

	virtual UINT GenerateCodeBytes(DisasmData *pds,LPSTR pBuffer,UINT nBuffer,DWORD nFlags)=0;
	virtual UINT GenerateMnemonic(DisasmData *pds,LPSTR pBuffer,UINT nBuffer,DWORD nFlags)=0;
	virtual UINT GenerateOperand(DisasmData *pds,UINT i,LPSTR pBuffer,UINT nBuffer,DWORD nFlags)=0;
/*************
	constructor
*************/
#ifdef _USER_SYMBOL
	Disasm(Symbol *pParent):_BASE_CLASS(pParent){}
#endif
};
#undef _BASE_CLASS

/*************
	DisasmList
*************/
/*!	@brief list of Disasm
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_DISASMLIST, 0)
*/
class DisasmList : public Symbol
{
public:
/*************
	introducing virtual
*************/
};
