/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "DisasmDef.h"

#pragma pack(push,1)


#define GEN(x)	instCIL##x
enum
{
	#include "DisasmCILInst.h"
	,instCILMax
};
#undef GEN

struct DisasmCILOperand : public DisasmOperand
{
	union
	{
		struct
		{
			DWORDLONG Immediate;
			struct 
			{
				BYTE ImmediateSize:6;
				BYTE ImmediateExpanded:1;
				BYTE ImmediateSigned:1;
			};						
		};
	};
	struct
	{
		BYTE isfloat:1;
	}Flags;

};

#define DISASM_MAX_CODE_SIZE_CIL (2+8)
struct DisasmCILData : public DisasmData
{
	BYTE _CodeBytes[DISASM_MAX_CODE_SIZE_CIL];

	DisasmCILOperand Operand[1];

	struct
	{
		BYTE Volatile:1;
		BYTE Tail:1;
		BYTE Unaligned:1;
	}Flags;
};

#pragma pack(pop)
