/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#pragma pack(push,1)

//disassembler result codes
#define disasmResSuccess 0
#define disasmResInvalid 1
#define disasmResMemory 2

//disassembler mnemonic types
#define disasmTypeNone 0
#define disasmTypeSet 1
#define disasmTypeCSet 2	//conditional move
#define disasmTypeFSet 3	//flag set lahf, ... , seto, ..
#define disasmTypeFDef 4	//flag set stc, ...
#define disasmTypeLSet 5	//lds, ...
#define disasmTypeXchg 6

#define disasmTypeConv 7	//conversion cbw, ...

#define disasmTypeLea 8
#define disasmTypeXlat 9

#define disasmTypeBcd 15

#define disasmTypePush 20
#define disasmTypePop 21

#define disasmTypeArith	30	//arithmetic
#define disasmTypeInc 31
#define disasmTypeDec 32
#define disasmTypeAdd 33
#define disasmTypeSub 34
#define disasmTypeMul 35
#define disasmTypeDiv 36
#define disasmTypeRem 37
#define disasmTypeNeg 38
#define disasmTypeAbs 39

#define disasmTypeLogic	50	//logic
#define disasmTypeShift 51
#define disasmTypeNot 52
#define disasmTypeOr 53
#define disasmTypeAnd 54
#define disasmTypeXor 55
#define disasmTypeEqv 56

#define disasmTypeCmp 60	//compare
#define disasmTypeTest 61

#define disasmTypeCond 80	//flow
#define disasmTypeJmp 81
#define disasmTypeCall 82
#define disasmTypeInt 83
#define disasmTypeRet 84
#define disasmTypeIRet 85

#define disasmTypeIn 90
#define disasmTypeOut 91

#define disasmTypeCrit 100

#define disasmTypeSwitch 110
#define disasmTypeObj 111
#define disasmTypeFnc 112

//disassembler operand types
#define disasmOpNone 0
#define disasmOpRegister 1
#define disasmOpIndirect 2
#define disasmOpIndirect2 17

#define disasmOpImmediate 3
#define disasmOpRelative 4

#define disasmOpMemory 5
#define disasmOpMemory2 15

#define disasmOpObject 16
#define disasmOpThis 18

#define disasmOpSlot 6
#define disasmOpToken 7
#define disasmOpLocale 8
#define disasmOpArg 9
#define disasmOpSwitch 10

#define disasmOpConst 11
#define disasmOpPool 12

#define disasmOpVBVar 13	//multiple operands

#define disasmOpTemp 14


typedef DWORD _sym_type;

//general disasm structures
struct DisasmOperand
{
	BYTE OpType;
	union
	{
		_sym_type SymType;
		struct
		{
			WORD DataSize;
			BYTE DataSubSize;
			BYTE DataType;
		};
	};
	DWORDLONG Value;
};

struct DisasmData
{
	DWORDLONG Address;

	DWORD CodeSize;

	BYTE InstructionSize;
	BYTE PrefixSize;

	BYTE Type;

	BYTE ErrorCode;

	short InstructionIndex;

	BYTE CodeBytes[1];
};
#pragma pack(pop)
