/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "DisasmDef.h"

#pragma pack(push,1)

#define GEN(x)	instVB##x
enum
{
	#include "DisasmVBInst.h"
	,instVBMax
};
#undef GEN


struct DisasmVBOperand : public DisasmOperand
{
	union
	{
		struct
		{
			BYTE ImmediateSize;
			DWORDLONG Immediate;
		};
		struct
		{
			union
			{
				struct
				{
					BYTE DisplacementSize;
					DWORD Displacement;
				};
				struct
				{
					BYTE LocaleSize;
					DWORD Locale;
				};
			};
			struct
			{
				BYTE MemorySize;
				DWORD Memory;
			};
		};
	};
};


#define DISASM_MAX_CODE_SIZE_VBP 20

struct DisasmVBData : public DisasmData
{
	BYTE _CodeBytes[DISASM_MAX_CODE_SIZE_VBP];

	DisasmVBOperand Operand[4];

};

#pragma pack(pop)