/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once
#include "DisasmDef.h"

#pragma pack(push,1)

#define GEN(x)	instX86##x
enum
{
	#include "DisasmX86Inst.h"
	,instX86Max
};
#undef GEN

union disasmX86Flags
{
	DWORD raw;
	struct
	{
		DWORD mode:3;
	};
};

#define disasmX86ModeDefault 0
#define disasmX86Mode1616 1
#define disasmX86Mode1632 2
#define disasmX86Mode3216 3
#define disasmX86Mode3232 4
#define disasmX86Mode64 5
#define disasmX86ModeAuto 6


struct DisasmX86Operand : public DisasmOperand
{
	BYTE Reg1;
	BYTE Reg2;
	BYTE Scale;

	union
	{
		struct
		{
			DWORDLONG Displacement;
			struct
			{
				BYTE DisplacementSize:7;
				BYTE DisplacementExanded:1;
			};
			BYTE DisplacementOffset;
		};
		struct
		{
			DWORDLONG Immediate;
			struct
			{
				BYTE ImmediateSize:7;
				BYTE ImmediateExpanded:1;
			};
			BYTE ImmediateOffset;
		};
		WORD Register;
	};
	struct
	{
		BYTE es_reg:1;
	}Flags;
};


#define DISASM_MAX_CODE_SIZE_X86 15

struct DisasmX86Data : public DisasmData
{
	BYTE _CodeBytes[DISASM_MAX_CODE_SIZE_X86];

	DisasmX86Operand Operand[3];

	struct
	{
		WORD DefaultAddressSize:4;
		WORD DefaultStackSize:4;
		WORD AddressSize:4;
		WORD OperandSize:4;
		BYTE StackSize:4;
	};

	BYTE SegDefault;
	BYTE SegReg;

	DWORDLONG ReadAddress;
	DWORDLONG WriteAddress;
	struct
	{
		WORD W:1;
		WORD D:1;
		WORD Q:1;
		WORD Far:1;
		WORD pfx66:1;
		WORD pfx67:1;
		WORD pfxF2:1;	//repne
		WORD pfxF3:1;	//rep/repe
		WORD String:1;
		WORD rexW:1;
		WORD rexR:1;
		WORD rexX:1;
		WORD rexB:1;
	}Flags;
};
#pragma pack(pop)