/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

/*! @brief exported function

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_EXPORT, 0)
*/
class Export : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*! @brief get export ordinal
		@returns ordinal of exported function
	*/
	virtual WORD Ordinal() const=0;
};

/*! @brief exported and forewarded function

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_EXPORTFOREWARD, 0)
*/
class ExportForeward : public Export
{
public:
/*************
	introducing virtual
*************/
	/*! @brief get forewarder string
		@returns forewarder string
	*/
	virtual LPCSTR Foreward() const =0;
};

/*!	@brief list of Export or ExportForeward

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_EXPORTLIST,0) or 
	@ref SYM_MAKEID(@ref SYMID_EXPORTFOREWARDLIST,0)
*/
class ExportList : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*! @brief get Export or ExportForeward by ordinal
		@param wOrdinal ordinal of the child to retrieve
		@returns symbol pointer if existing, NULL otherwise
	*/
	virtual Symbol *ChildByOrdinal(WORD wOrdinal)=0;
};
