/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

struct ParserResult;

/*************
	Frame
*************/
#ifdef _USER_SYMBOL
	#include "UserSymbol.h"
	#define _BASE_CLASS UserSymbol
#else
	#include "symbol.h"
	#define _BASE_CLASS Symbol
#endif
/*!	@brief execution frame

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_FRAME,  @ref DEBUG_xxx "DEBUG_xxx")
	@todo more virtuals
**/
class Frame : public _BASE_CLASS
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get frame index
		@returns zero based frame index
	*/
	virtual int Index()=0;

	virtual BOOL IsValid()=0;

	/*!	@brief get linear instruction pointer
		@param ip buffer for ip address
		@returns nonezero if successful
	*/
	virtual BOOL GetIP(DWORDLONG &ip)=0;
	/*!	@brief set instruction pointer to linear address
		@param ip linear ip address
		@returns nonezero if successful
	*/
	virtual BOOL SetIP(DWORDLONG ip)=0;

	virtual BOOL GetIPRegister(DWORDLONG &ip)=0;
	virtual BOOL SetIPRegister(DWORDLONG ip)=0;

	/*!	@brief get linear stack pointer
		@param sp buffer for sp address
		@returns nonezero if successful
	*/
	virtual BOOL GetSP(DWORDLONG &sp)=0;
	/*!	@brief set stack pointer to linear address
		@param sp linear sp address
		@returns nonezero if successful
	*/
	virtual BOOL SetSP(DWORDLONG sp)=0;

	virtual BOOL GetSPRegister(DWORDLONG &sp)=0;
	virtual BOOL SetSPRegister(DWORDLONG sp)=0;

	/*!	@brief get register value by index
		@param nReg register to get
		@param reg buffer for register value
		@returns nonezero if successful
		@remarks @em nReg is Debug specific
	*/
	virtual BOOL GetRegister(int nReg,DWORDLONG &reg)=0;
	/*!	@brief set register value by index
		@param nReg register to set
		@param reg new register value
		@returns nonezero if successful
		@remarks @em nReg is Debug specific
	*/
	virtual BOOL SetRegister(int nReg,DWORDLONG reg)=0;

	/*!	@brief get register value by name
		@param sReg name of register to get
		@param reg buffer for register value
		@returns nonezero if successful
	*/
	virtual BOOL GetRegister(LPCSTR sReg,DWORDLONG &reg)=0;
	/*!	@brief set register value by name
		@param sReg name of register to set
		@param reg new register value
		@returns nonezero if successful
	*/
	virtual BOOL SetRegister(LPCSTR sReg,DWORDLONG reg)=0;

	virtual BOOL GetRegister(int nReg,ParserResult &res)=0;
	virtual BOOL SetRegister(int nReg,ParserResult &res)=0;

	virtual BOOL GetRegister(LPCSTR sReg,ParserResult &res)=0;
	virtual BOOL SetRegister(LPCSTR sReg,ParserResult &res)=0;

	/*!	@brief get associated Debug
		@returns pointer to Debug
	*/
	virtual Symbol *GetDebug()=0;

	/*!	@brief get current Module
		@returns pointer to Module related to the current ip position
	*/
	virtual Symbol *GetModule()=0;

	/*!	@brief get current function or logical block
		@returns pointer to WintruderSymbol of type _sym_typeProc or _sym_typeBlock
			related to the current ip position
	*/
	virtual Symbol* GetFunctionBlock()=0;
	/*!	@brief get current function
		@returns pointer to WintruderSymbol of type _sym_typeProc
			related to the current ip position
	*/
	virtual Symbol* GetFunction()=0;
/*************
	constructor
*************/
#ifdef _USER_SYMBOL
	Frame(Symbol *pParent):_BASE_CLASS(pParent){}
#endif
};
#undef _BASE_CLASS


/*************
	FrameArray
*************/
#ifdef _USER_SYMBOL
	#define _BASE_CLASS UserSymbolList
#else
	#define _BASE_CLASS Symbol
#endif
/*!	@brief execution frame array

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_FRAMEARRAY,  @ref DEBUG_xxx "DEBUG_xxx")
**/
class FrameArray : public _BASE_CLASS
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get a Frame by index
		@param nFrame frame index
		@returns Frame of index @em nFrame
		@remarks the children of FrameArray are created on demand
	*/	
	virtual Symbol *ChildByIndex(int nFrame)=0;
	/*!	@brief reset all frames
	*/	
	virtual void ResetFrames();
/*************
	constructor
*************/
#ifdef _USER_SYMBOL
	FrameArray(Symbol *pParent):_BASE_CLASS(pParent){}
#endif
};
#undef _BASE_CLASS
