/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once
/*! @defgroup LOG_xxx Log types */
//@{

//event log
#define LOGEVENT_EVENT		(1<<31)
#define LOGEVENT_SHOW		(LOGEVENT_EVENT+(1<<29))
#define LOGEVENT_DROP		(LOGEVENT_EVENT+(2<<29))
#define LOGEVENT_RESERVED	(LOGEVENT_EVENT+(3<<29))

#define LOGEVENT_MASK		(7<<29)

//log classes
#define LOGCLASS_NONE		(0<<27)
#define LOGCLASS_INFO		(1<<27)
#define LOGCLASS_WARNING	(2<<27)
#define LOGCLASS_ERROR		(3<<27)

#define LOGCLASS_MASK		(3<<27)

//default
#define LOGTYPE_DEFAULT 0

//info icon types
#define LOGTYPE_INFO	(LOGTYPE_DEFAULT+LOGCLASS_INFO)
#define LOGTYPE_WARNING	(LOGTYPE_DEFAULT+LOGCLASS_WARNING)
#define LOGTYPE_ERROR	(LOGTYPE_DEFAULT+LOGCLASS_ERROR)

//other log types
#define LOGTYPE_PROCESS 5
#define LOGTYPE_THREAD 6
#define LOGTYPE_MODULE 7

#define LOGTYPE_FILE 10
#define LOGTYPE_PELOADER 11
#define LOGTYPE_PELOADERMINOR 12

#define LOGTYPE_PLUGIN 13

#define LOGTYPE_DBGMSG 14
#define LOGTYPE_DEBUG 15

#define LOGTYPE_CONDBP 16
#define LOGTYPE_BREAKPOINT 17

#define LOGTYPE_SCRIPT 18
#define LOGTYPE_NET 19

#define LOGTYPE_DYNIMPORT 20

//first user log type
#define LOGTYPE_USER_FIRST	0x100

//@}
