/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

/*!	@brief Module loaded by a Process
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_MODULE, 0)
**/
class Module : public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual LPCSTR Path() const =0;
	virtual Symbol *GetModuleInfo()=0;
	virtual void SetModuleInfo(Symbol *pSym)=0;
};

/*!	@brief list of Module objects loaded by a Process
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_MODULELIST, 0)
	@remarks ChildByName() is not casesensitive
**/
class ModuleList: public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*! @brief get module by path
		@param path full path of module
		@returns Module if found in list, NULL otherwise
		@remarks path compare is not casesensitive
	*/
	virtual Symbol *ChildByPath(LPCSTR path)=0;
};
