/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

/*!	@brief maintains per Module information

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_MODULEINFO, @ref MAKE_MI(@ref MI_xxx "MI_xxx", @ref PC_xxx "PC_xxx"))
	@remarks the %ModuleInfo remains available for the whole lifetime of a project
*/
class ModuleInfo : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief identify Module type and setup %ModuleInfo parameter
		@returns nonezero if successfull
		@param ModuleProcessor %ModuleInfo type
		@param TimeStamp timestamp of the %Module, 0 if no value assigned
		@param DefaultImageBase default load address of the %Module, -1 if no value assigned
		@param ImageSize default image size of the %Module, -1 if no value assigned
		@param pszDescription optional string describing image and processor type
		@remarks this function fails if already identified
		@remarks @em ModuleProcessor is a value of type @ref MAKE_MI(@ref MI_xxx "MI_xxx", @ref PC_xxx "PC_xxx").
		further calls to Identifer() will return this value.
		@remarks @em TimeStamp is regarded as information from the Modules compiler/linker and should be found in
		the Module header. (@em TimeStamp is NOT the filetime or something.)
		@remarks @em pszDescription can be NULL if @em ModuleProcessor consist of default values
		@remarks called by a SymbolLoader symbols.
		@sa FileOffsetToRVA(), RVAToFileOffset(), ReadImage()
	*/
	virtual BOOL Identify(DWORD ModuleProcessor,DWORD TimeStamp,DWORDLONG DefaultImageBase,DWORDLONG ImageSize,LPCSTR pszDescription)=0;
	/*! @brief path of associated Module
		@returns the full qualified path of the associated Module symbol
	*/
	virtual LPCSTR Path()=0;

	virtual Symbol* GetModuleList()=0;

	/*!	@brief load %ModuleInfo information

		invokes SymbolLoader::LoadInformation() of each SymbolLoader installed.
		@param info a single @ref SL_xxx "SL_xxx" value. specifies the information to be loaded.
		@returns none zero if requested information available
		@remarks fails if @em info consists of more than one @ref SL_xxx "SL_xxx" value.
	*/
	virtual BOOL LoadInformation(DWORD info)=0;

	virtual BOOL OpenImage(DWORD flags)=0;
	virtual void CloseImage()=0;
	virtual BOOL ReadFile(DWORDLONG pos,DWORD n,void *buf)=0;
	virtual BOOL ReadImage(DWORD rva,DWORD n,void *buf)=0;
	virtual BOOL ReadMemory(DWORD rva,DWORD n,void *buf)=0;
	virtual DWORDLONG ImageFileSize() const=0;

	virtual DWORD TimeStamp() const=0;
	virtual DWORDLONG DefaultImageBase() const=0;
	virtual DWORDLONG ImageSize() const=0;

	virtual DWORD FileOffsetToRVA(DWORDLONG ofs)=0;
	virtual DWORDLONG RVAToFileOffset(DWORD rva)=0;

	virtual DWORD PEDataDirectoryEntry(UINT entry,DWORD &size)=0;
};

/*!	@brief list of ModuleInfo
	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_MODULEINFOLIST, 0)
*/
class ModuleInfoList  : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief get ModuleInfo by path
		@param pszPath full qualified path
		@returns pointer to ModuleInfo if found, NULL otherwise
	*/
	virtual Symbol *ChildByPath(LPCSTR pszPath)=0;
};