/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

/*! @brief a page of memory

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_PAGE, 0)
*/
class Page : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*! @brief get current page flags
		@returns current page flags of %Page
		@remarks @em flags is a combination of PAGE_xxx, MEM_xxx and SEC_xxx flags as found in winnt.h
	*/
	virtual DWORD Flags() const=0;
	/*!	@brief get page allocation base
		@returns allocation base of %Page
	*/
	virtual DWORDLONG AllocationBase() const=0;
	/*!	@brief get page allocation flags
		@returns allocation flags of %Page. i.e. any combination of PAGE_xxx values
		@see Flags()
	*/
	virtual DWORD AllocationFlags() const=0;
};


/*!	@brief list of Page

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_PAGELIST,0)
*/
class PageList : public Symbol
{
public:
/*************
	introducing virtual
*************/
};
