/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

/*!	@brief plugin symbol

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_PLUGIN, 0)
	@sa WPI_Data
*/
class PlugIn : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*! @brief get plugin version
		@returns plugin version
	*/
	virtual DWORD Version() const =0;
	virtual DWORD Flags() const =0;
	virtual LPCSTR Dependices() const=0;
	virtual LPCSTR Path() const=0;

	virtual BOOL Load()=0;
	virtual BOOL Unload(BOOL bForce)=0;

	/*! @brief get current load state
		@returns nonezero if plugin is loaded
	*/
	virtual BOOL IsLoaded()=0;
};

/*! @defgroup DEPEND_xxx PlugIn dependices*/
//@{
#define DEPEND_UNRESOLVED	(1<<0)
#define DEPEND_UNLOADED		(1<<1)
#define DEPEND_DEPENDING	(1<<2)
#define DEPEND_BUFFER		(1<<31)
//@}

/*!	@brief list of PlugIn

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_PLUGINLIST, 0)
*/
class PlugInList : public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual DWORD CheckDependices(PlugIn *pPlugIn,LPSTR pBuffer,UINT nSize);
};