/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

/*! @brief debugged process

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_PROCESS, @ref PROC_xxx "PROC_xxx")
*/
class Process : public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual HANDLE Handle() const;
	virtual DWORD Id() const;
//memory access
	virtual BOOL GetMemory(DWORDLONG base, DWORD n, void * buf,BOOL bIgnoreCache=FALSE);
	virtual BOOL SetMemory(DWORDLONG base, DWORD n, void * buf,BOOL bIgnoreCache=FALSE,BOOL bNoPatch=FALSE);
//start, terminate
	virtual BOOL Start();
	virtual BOOL Attach(HANDLE hSignalEvent);
	virtual BOOL Detach();
//contiue
	virtual BOOL Continue(BOOL bIgnore=FALSE);
//intermediates
	virtual void ResetIntermediates();
//state
	virtual BOOL IsRunning();
	virtual BOOL IsSuspended();
	virtual BOOL CanContinue();
	virtual BOOL CanIgnoreEvent();
	virtual BOOL CanSuspend();
	virtual BOOL CanStartRestart();
//process properties
	virtual LPCSTR Path() const;
	virtual LPCSTR Parameter() const;
	virtual LPCSTR DefaultPath() const;
	virtual LPCSTR Environment() const;
	virtual BOOL InheritDebugging() const;
	virtual BOOL ReadOnly() const;
	virtual BOOL ReadCache() const;

	virtual void SetPath(LPCSTR p);
	virtual void SetEnvironment(LPCSTR p);
	virtual void SetDefaultPath(LPCSTR p);
	virtual void SetParameter(LPCSTR p);
	virtual void SetInheritDebugging(BOOL b);
	virtual void SetReadOnly(BOOL b);
	virtual void SetReadCache(BOOL b);
//address range
	virtual Symbol* AddressRange();
};


/*! @brief list of Process

	@remarks Identifer() returns @ref SYM_MAKEID(@ref SYMID_PROCESSLIST, 0)
*/
class ProcessList: public Symbol
{
public:
/*************
	introducing virtual
*************/
	virtual Symbol *ChildById(DWORD dwProcessId);
};