/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#include "Symbol.h"

/*! @brief Progress indicator in main window status bar

	@remarks different modes or operation
		- normal	@n
			Current()=100 / Overall() * Position()
		- stage @n
			Current()=100 / (StageOverall() * Overall()) * (Stage() * Overall() + Position())
		- partial @n
			Current()=100 / (Overall() / Part() * PartOverall()) * Position()
*/
class ProgressIndicator : public Symbol
{
public:
/*************
	introducing virtual
*************/
	/*!	@brief increase Overall()
		@param tick overall position delta
	*/
	virtual void TickOverall(int tick);
	/*!	@brief increase Position()
		@param tick position delta
	*/
	virtual void Tick(int tick);
	/*!	@brief set Position() and Overall()
		@param current new position
		@param overall new overall position
		@remarks @em overall is ignored if -1
	*/
	virtual void Set(int current,int overall=-1);

	/*!	@brief increase StageOverall()
		@param tick stage overall position delta
	*/
	virtual void TickStageOverall(int tick);
	/*!	@brief increase Stage()
		@param tick stage position delta
		@param size new overall value
	*/
	virtual void TickStage(int tick,int size=0);
	/*!	@brief set Stage() and StageOverall()
		@param current new stage position
		@param overall new overall position, ignored if -1
	*/
	virtual void SetStage(int current,int overall=-1);

	/*!	@brief increase PartOverall()
		@param tick partial overall position delta
	*/
	virtual void TickPartOverall(int tick);
	/*!	@brief increase Part()
		@param tick partial position delta
		@param size overall delta
	*/
	virtual void TickPart(int tick,int size=0);
	/*!	@brief set Part() and PartOverall()
		@param current new partial position
		@param overall new partial overall position, ignored if -1
	*/
	virtual void SetPart(int current,int overall=-1);

	/*!	@brief check last recent update more than 100ms behind the times
	*/
	virtual BOOL UpdateFrequency() const;

	/*!	@brief get normalized current position
		@return position in range [0,100]
	*/
	virtual int Current() const;

	/*!	@brief get current position
		@return position in range [0,Overall()]
	*/

	virtual int Position() const;
	/*!	@brief get current overall
		@return overall Position()
	*/
	virtual int Overall() const;

	/*!	@brief get current stage
		@return stage position in range [0,StageOverall()]
	*/
	virtual int Stage() const;
	/*!	@brief get current stage overall
		@return overall Stage()
	*/
	virtual int StageOverall() const;

	/*!	@brief get current part
		@return partial position in range [0,PartOverall()]
	*/
	virtual int Part() const;
	/*!	@brief get current partial overall
		@return overall Part()
	*/
	virtual int PartOverall() const;
};
