/***************************
	wintruder sdk
	copyright future vision - all rights reserved
	
	this is preliminary information and may be subject to change
***************************/
#pragma once

#define BPFNC_ENTER			0
#define BPFNC_RETURN		1
#define BPFNC_ERROR			2
#define BPFNC_SUSPICIOUS	3
#define BPFNC_REMOVE		-1

class Thread;
class Breakpoint;
typedef int (*pBreakpointX86FunctionCb)(Thread *pThread,Breakpoint* pBreakpoint,void *pCallbackCookie,int nReason);

/*************
	BreakpointListX86Function
*************/
class BreakpointListX86Function : public BreakpointList
{
public:
/*************
	introducing virtual
*************/
/*************
	inherited
*************/
	/*!	@brief simplified creation of BreakpointX86Function
		@details the full parameter list is:
		@code
		Symbol* CreateEx(
			DWORDLONG Address,					//address of first byte of function
			pBreakpointX86FunctionCb pCallback,	//callback function (required)
			void* pCallbackCookie,				//callback cookie
			LPCSTR pszDescription);				//callback/breakpoint description
		@endcode
		@see BreakpointList::Create(), BreakpointList::CreateEx()
	*/
	virtual Symbol *CreateEx(DWORDLONG Address,...);
};

/*************
	BreakpointX86Function
*************/
class BreakpointX86Function : public Breakpoint
{
public:
/*************
	introducing virtual
*************/
	virtual BOOL SetCallbackEx(pBreakpointX86FunctionCb pCallback,void* pCallbackCookie,LPCSTR pszDescription=NULL);
	virtual pBreakpointX86FunctionCb GetCallbackEx(LPVOID &pCallbackCookie);
};
